import os
import sys
import locale


# gDesklets home paths
HOME = os.path.abspath(os.path.join(os.path.dirname(__file__), os.pardir))
USERHOME = os.path.join(os.path.expanduser("~"), ".gdesklets")

# the name of the purge key
PURGE_KEY = "_paths_to_purge_"

# the ID of the default sensor
DEFAULT_SENSOR = "_default_"

UNSET_COORD = -1000

# paths where gDesklets looks for sensors and displays
SENSORPATHS = [os.path.join(USERHOME, "Sensors"),
               os.path.join(HOME, "Sensors")]
DISPLAYPATHS = [os.path.join(USERHOME, "Displays"),
                os.path.join(HOME, "Displays")]

NAME = "gDesklets"
VERSION = "0.26.2"
COPYRIGHT = u"Copyright \xa9 2003, 2004 The gDesklets Team"
DESCRIPTION = u"A desktop applet system for GNOME"
AUTHORS = [u"Martin Grimme <martin@pycage.de>",
           u"Christian Meyer <chrisime@gnome-de.org>",
           u"Jesse Andrews <jdandr2@cs.uky.edu>",
           u"Sebastien Bacher <seb128@debian.org>",
           u"Beno\xeet Dejean <bnet@ifrance.com>"]
DOCUMENTERS = [u"Martin Grimme <martin@pycage.de>"]
ICON = os.path.join(HOME, "data", "gdesklets.png")

# setup i18n
from utils.i18n import Translator
_ = Translator(NAME.lower(), os.path.join(HOME, "locale"))





def init():

    import gnome.ui
    import gtk
    import signal

    # init gnome
    chldhandler = signal.getsignal(signal.SIGCHLD)
    program = gnome.program_init(NAME, VERSION)

    # gnome.program_init has the bad new habit to modify the locale settings
    # (bug #135055); repair it
    import locale; locale.setlocale(locale.LC_NUMERIC, "C")
    
    # gnome.program_init < 1.99.18 breaks the SIGCHLD handler; gotta repair it
    signal.signal(signal.SIGCHLD, chldhandler)
    
    # install signal handler to quit on Ctrl-C
    signal.signal(signal.SIGINT, gtk.mainquit)


    #
    # Make sure that EventBoxes are transparent.
    #
    rc_style = """
    style "transparent" { bg_pixmap[NORMAL] = "<parent>"
                          bg_pixmap[INSENSITIVE] = "<parent>"
                          bg_pixmap[PRELIGHT] = "<parent>"
                          bg_pixmap[SELECTED] = "<parent>"
                          bg_pixmap[ACTIVE] = "<parent>"
                          }
    class "GtkEventBox" style "transparent"
    """

    gtk.rc_parse_string(rc_style)

    


def print_about():

    print NAME + " " + VERSION
    print COPYRIGHT.replace(u"\xa9", u"(C)")
    print
    print "This software is licensed under the terms of the GNU GPL."
    print
