from FileWatcher import FileWatcher
from GConfWatcher import GConfWatcher
from Observable import Observable
from TargetSettings import TargetSettings
import dialog


import os
import errno



def makedirs(path):
    
    """Recursive directory creation function
    
    Returns :
    - True if path has been created
    - False if path already exists
    
    (Re)Raises an OSError exception if path does not exist and
    cannot be created or if path cannot be accessed"""

    try:
        os.makedirs(path)
        return True
    
    except OSError, e:

        if e.errno != errno.EEXIST or not os.path.isdir(path):
            raise
        
        if not os.access(path, os.F_OK | os.R_OK | os.W_OK | os.X_OK):
            raise OSError("[Errno %d] %s: '%s'"
                          %
                          (errno.EACCES,
                           os.strerror(errno.EACCES),
                           path)
                          )

        return False
