from main import USERHOME
import utils


import os
import os.path
import commands
import tempfile


TAR = "tar"


#
# Class for handling archives of different formats.
#
class _Archive:

    __TYPE_GZ = "gz"
    __TYPE_BZ2 = "bz2"
    __TYPE_UNKNOWN = "unknown"

    def __init__(self, file):

        self.__file = file

        name, ext = os.path.splitext(file)
        if (ext.lower() == ".gz"): self.__type = self.__TYPE_GZ
        elif (ext.lower() == ".tgz"): self.__type = self.__TYPE_GZ
        elif (ext.lower() == ".bz2"): self.__type = self.__TYPE_BZ2
        else: self.__type = self.__TYPE_UNKNOWN



    #
    # Returns a list of all paths in this archive.
    #
    def get_list(self):

        if (self.__type == self.__TYPE_GZ):
            cmd = TAR + " -tzf " + self.__file
        elif (self.__type == self.__TYPE_BZ2):
            cmd = TAR + " -tjf " + self.__file
        else:
            cmd = ""

        fail, entries = commands.getstatusoutput(cmd)

        if (fail):
            print entries
            return ""

        return entries.splitlines()



    #
    # Extracts this archive to the given destination. Sensors are excluded.
    #
    def extract(self, dest):

        utils.makedirs(dest)
        if (self.__type == self.__TYPE_GZ):
            cmd = TAR + " -xzf " + self.__file + \
                  " --exclude 'Install_*Sensor.bin' --exclude sensors"
        elif (self.__type == self.__TYPE_BZ2):
            cmd = TAR + " -xjf " + self.__file + \
                  " --exclude 'Install_*Sensor.bin' --exclude sensors"
        else:
            cmd = ""

        cmd = "cd " + dest + " && " + cmd
        fail, out = commands.getstatusoutput(cmd)
        if (fail): print out



    #
    # Returns the contents of the given file in this archive.
    #
    def read_file(self, file):

        if (self.__type == self.__TYPE_GZ):
            cmd = TAR + " -O -xzf " + self.__file + " " + file
        elif (self.__type == self.__TYPE_BZ2):
            cmd = TAR + " -O -xjf " + self.__file + " " + file
        else:
            cmd = ""

        fail, out = commands.getstatusoutput(cmd)
        if (fail): out = ""
        
        return out
        



#
# Finds and installs all sensors in the given archive to the given destination.
#
def install_sensors(archive, dest):

    for f in archive.get_list():
        name = os.path.basename(f)
        if (name.startswith("Install_")):
            print name
            tmp = tempfile.mktemp()
            fd = open(tmp, "w")
            fd.write(archive.read_file(f))
            fd.close()
            os.system("python " + tmp + " --nomsg")
            os.unlink(tmp)



#
# Returns a list of the paths of all .display files after installation.
#
def find_displays(archive, dest):

    displays = []
    for f in archive.get_list():
        name, ext = os.path.splitext(f)
        if (ext == ".display"):
            displays.append(os.path.join(dest, f))
    #end for

    return displays



#
# Installs the given archive to the given prefix and returns a list of the
# installed .display files.
#
def install(path, prefix):

    archive = _Archive(path)
    displays = []
    if (archive.get_list()):
        install_sensors(archive, os.path.join("Sensors"))
        archive.extract(os.path.join(prefix, "Displays"))
        displays = find_displays(archive, os.path.join(prefix, "Displays"))

    return displays



if (__name__ == "__main__"):
    import sys
    
    prefix = USERHOME
    install(sys.argv[1], prefix)
