/* Functions for using the systray.
 * Copyright (C) 2004 Martin Grimme
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <Python.h>
#include <gtk/gtk.h>
#include <libgnomeui/gnome-icon-theme.h>
#include "eggstatusicon.h"

#define SYSTRAY_ICON(o) EGG_STATUS_ICON(o)



EggStatusIcon*
systray_icon_new ()
{
  EggStatusIcon *icon;

  icon = egg_status_icon_new ();
  return icon;
}


void
systray_icon_set_icon (EggStatusIcon *icon, char *icon_name)
{
  gchar *path;
  GdkPixbuf *pixbuf, *scaled;
  GError *error = NULL;
  GnomeIconTheme *icon_theme = NULL;

  icon_theme = gnome_icon_theme_new ();  
  path = gnome_icon_theme_lookup_icon (icon_theme, (gchar*) icon_name,
				       egg_status_icon_get_size (icon),
				       NULL, NULL);

  if (path)
    {
      pixbuf = gdk_pixbuf_new_from_file (path, &error);
      if (error)
	{
	  g_warning ("Failed to load %s: %s", path, error->message);
	  g_error_free (error);
	}
      else
	{
	  scaled = gdk_pixbuf_scale_simple (pixbuf, 24, 24,
					    GDK_INTERP_BILINEAR);
	  egg_status_icon_set_from_pixbuf (icon, scaled);
	  g_object_unref (pixbuf);
	  g_object_unref (scaled);
	}
      g_free (path);
    }
  else
    {
      g_warning ("Failed to lookup icon %s", icon_name);
    }

  g_object_unref (icon_theme);

}


static void
activate_cb (EggStatusIcon *icon, gpointer cb)
{
  PyEval_CallObject ((PyObject*) cb, NULL);
}


void
systray_icon_set_activate_cb (EggStatusIcon *icon, PyObject *cb)
{
  g_signal_connect (icon, "activate", G_CALLBACK (activate_cb),
		    (gpointer) cb);
}


/*
int
main(int argc, char **argv)
{
  EggStatusIcon *icon;
  gtk_init (&argc, &argv);

  
  icon = systray_icon_new ();
  systray_icon_set_icon (icon, "gdesklets");

  gtk_main ();

  g_object_unref (icon_theme);

  return 0;
}
*/
