from StateSaver import DefaultStateSaver
from ConfigDialog import ConfigDialog
from main import ICON, VERSION
from utils.datatypes import *
import settings

import getopt
import sys


class DaemonConfigger(ConfigDialog):
    """
      Configuration Dialog for the daemon.
    """

    __ITEMS = (
      ("title", {"label": "Editor to view/edit the desklet source code"}),
      ("uri",   {"label": "Your favorite editor", "bind": "editor"}),
      ("title", {"label": "XComposite support (requires composition manager)"}),
      ("boolean", {"label": "Translucency (takes effect after restarting a display)", "bind": "translucency"}),
      ("title", {"label": "Screen Resolution (DPI)"}),
      ("dpi",   {"label": "<small>" +
                          _("Adjust the value above so that the bar will be "
                            "exactly <b>5 cm</b> or <b>1.97\"</b> wide") +
                          "</small>",
                          "bind": "dpi", "value": 96})
      )


    def __init__(self):

        self.__backend = DefaultStateSaver()

        ConfigDialog.__init__(self)

        self.set_property("title", _("Configuration"))
        self.set_banner(ICON, "<big>gDesklets Configuration</big>\n"
                        "Version %s" % (VERSION,))

        self._set_setter(self.__setter)
        self._set_getter(self.__getter)
        self._set_caller(self.__caller)

        self.build(self.__ITEMS)

        self.__load_config()
        self.__read_cmd_line()



    def __setter(self, key, value, datatype):

        if (key == "editor"):
            settings.editor = value

        elif (key == "dpi"):
            settings.dpi = value

        elif (key == "translucency"):
            settings.translucent = value

        self.__backend.set_key(key, value)


    def __getter(self, key):

        if (key == "editor"):
            return settings.editor

        if (key == "dpi"):
            return settings.dpi

        elif (key == "translucency"):
            return settings.translucent

        else:
            return "gDesklets killed a kitten!"


    def __caller(self, *args): pass


    def __load_config(self):

        settings.editor = self.__backend.get_key("editor", settings.editor)
        settings.dpi = self.__backend.get_key("dpi", settings.dpi)
        settings.translucent = self.__backend.get_key("translucency", settings.translucent)


    def __read_cmd_line(self):

        OPTIONS = ("sm-client-id=", "sm-config-prefix=", "sm-disable",
                   "no-tray-icon", "translucent")

        #
        # Parses the given list of command line arguments. This is usually
        # sys.argv[1:].
        #

        try:
            opts, rest = getopt.getopt(sys.argv[1:], "nop:v", OPTIONS)
        except getopt.GetoptError:
            return

        for o, a in opts:
            if (o == "--translucent"):
                settings.translucent = True
            elif (o == "--no-tray-icon"):
                settings.show_tray_icon = False
            elif (o in ("--sm-client-id", "--sm-config-prefix",
                        "--sm-disable")):
                pass
        #end for
