from utils.Observable import Observable
import gconf


class GConfBackend(Observable):

    OBS_UPDATE = 0
    CONFIG_LOCATION = "/apps/gdesklets"

    UNDEF = "-- undef --"


    def __init__(self):

        self.__client = gconf.client_get_default()
        self.__client.add_dir(self.CONFIG_LOCATION,
                              gconf.CLIENT_PRELOAD_RECURSIVE)
        self.__client.notify_add(self.CONFIG_LOCATION, self.__on_notify)



    def __on_notify(self, client, cid, entry, err):

        path = entry.get_key()[len(self.CONFIG_LOCATION) + 1:]
        path = path.split("/")
        value = entry.get_value()
        # keep compatibility with sensors
        if (value and value.type == gconf.VALUE_STRING):
            self.update_observer(self.OBS_UPDATE, path, value.get_string())



    def set(self, *args):

        """
        Sets a configuration entry.
        """

        value = args[-1]
        if (type(value) == str or type(value) == unicode):
            v = gconf.Value(gconf.VALUE_STRING)
            v.set_string(value)
        elif (type(value) == float):
            v = gconf.Value(gconf.VALUE_FLOAT)
            v.set_float(value)
        elif (type(value) == int):
            v = gconf.Value(gconf.VALUE_INT)
            v.set_int(value)
        elif (type(value) == bool):
            v = gconf.Value(gconf.VALUE_BOOL)
            v.set_bool(value)
        else:
            raise ValueError("Invalid data type %s." % (`type(value)`))
            
        #v = gconf.Value(gconf.VALUE_STRING)
        #v.set_string(args[-1])
        path = self.CONFIG_LOCATION
        if args: path += "/" + "/".join(args[:-1])
        self.__client.set(path, v)



    def get(self, *args):

        """
        Returns a configuration entry.
        """

        path = self.CONFIG_LOCATION
        if args: path += "/" + "/".join(args)
        v = self.__client.get(path)
        if (v):
            dtype = v.type
            if (dtype == gconf.VALUE_STRING):
                return v.get_string()
            elif (dtype == gconf.VALUE_FLOAT):
                return v.get_float()
            elif (dtype == gconf.VALUE_INT):
                return v.get_int()
            elif (dtype == gconf.VALUE_BOOL):
                return v.get_bool()
            else:
                raise ValueError("Invalid data type %s." % (dtype))
        else:
            return self.UNDEF



    def clear(self, *paths):

         """
         Removes the given folder.
         """

         path = self.CONFIG_LOCATION
         if paths: path += "/" + "/".join(paths)
         self.__client.unset(path)



    def list(self, *args):

        """Returns a list of all directories at the given path."""

        path = self.CONFIG_LOCATION
        if args: path += "/" + "/".join(args)
        dirs = self.__client.all_dirs(path)
        entries = self.__client.all_entries(path)

        ret = [ d[len(path) + 1:] for d in dirs ]

        for e in entries:
            ret.append(e.get_key()[len(path) + 1:])

        return ret


backend = GConfBackend()
