from ContainerTarget import ContainerTarget
from DisplayTarget import DisplayTarget
from utils.datatypes import *
from utils import Unit

import gtk


#
# Class for aligning targets.
#
class TargetAlignment(ContainerTarget):

    def __init__(self, name, parent):

        self.__alignment = (0.0, 0.0)

        ContainerTarget.__init__(self, name, parent)
        self.__align = gtk.Alignment(0.5, 1, 0, 0)
        self.__align.show()

        self._register_property("align-x", TYPE_FLOAT,
                                self._setp_alignment, self._getp)
        self._register_property("align-y", TYPE_FLOAT,
                                self._setp_alignment, self._getp)


    def get_widget(self): return self.__align


    def new_child(self, childtype, settings, children):

        child = ContainerTarget.new_child(self, childtype, settings, children)
        self.__align.add(child.get_widget())



    def handle_action(self, action, px, py, args):

        DisplayTarget.handle_action(self, action, px, py, args)

        bw, bn, be, bs = self.get_border_size()
        child = self._get_child()
        px -= bw; py -= bn

        align_x, align_y = self.__alignment
        x, y, w, h = self.get_geometry()
        cx, cy, cw, ch = child.get_geometry()
        cx = Unit.Unit((w - cw).as_pt() * align_x, Unit.UNIT_PT)
        cy = Unit.Unit((h - ch).as_pt() * align_y, Unit.UNIT_PT)

        if (cx <= px <= cx + cw and cy <= py <= cy + ch):
            child.handle_action(action, px - cx, py - cy, args)
            child.notify_handle_action(True)
        else:
            child.notify_handle_action(False)



    #
    # Alignment properties.
    #
    def _setp_alignment(self, key, value):

        if (key == "align-x"):
            ax, ay = self.__alignment
            self.__align.set(value, ay, 0, 0)
            self.__alignment = (value, ay)

        elif (key == "align-y"):
            ax, ay = self.__alignment
            self.__align.set(ax, value, 0, 0)
            self.__alignment = (ax, value)

        self._setp(key, value)
