from DisplayTarget import DisplayTarget
from utils.datatypes import *
from utils import vfs

import gobject
import gtk
import gtkhtml2
import thread
import urlparse



#
# Class for a HTML display target.
#
class TargetHTML(DisplayTarget):

    def __init__(self, name, parent):

        self.__current_url = ""
        self.__is_loading = False

        DisplayTarget.__init__(self, name, parent)

        self.__document = gtkhtml2.Document()
        self.__document.connect("request_url", self.__on_request_url)
        self.__document.connect("link_clicked", self.__on_link_clicked)
        self.__document.clear()

        self.__scrwin = gtk.ScrolledWindow()
        self.__scrwin.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.__scrwin.show()

        self.__html_view = gtkhtml2.View()
        self.__html_view.set_document(self.__document)
        self.__html_view.show()
        self.__scrwin.add(self.__html_view)

        self._register_property("data", TYPE_STRING,
                                 self._setp_data, self._getp)
        self._register_property("uri", TYPE_STRING,
                                 self._setp_uri, self._getp)
        self._register_property("scrollbars", TYPE_BOOL,
                                 self._setp_scrollbars, self._getp)
        self._register_property("loading", TYPE_BOOL,
                                 None, self._getp_loading)


    def get_widget(self): return self.__scrwin


    #
    # Downloads the given URI in the background.
    #
    def __download_uri(self, uri, handler):

        if (gtk.pygtk_version[1] < 5 and gtk.pygtk_version[2] < 3):
            read_entire_file = vfs.read_entire_file_win32
        else:
            read_entire_file = vfs.read_entire_file

        def f(uri, handler):
            self.__is_loading = True
            try:
                uri = self.__resolve_uri(uri)
                try:
                    data = read_entire_file(uri)
                except:
                    return
            except:
                data = "<html><body><h1>%s</h1>The given URL could not be retrieved." \
                       "</body></html>" % uri

            self.__is_loading = False
            gobject.timeout_add(0, handler, data)

        # download in the background to avoid blocking the program
        thread.start_new_thread(f, (uri, handler))



    #
    # Returns whether the given URL is relative to the server.
    #
    def __is_relative_to_server(self, url):

        parts = urlparse.urlsplit(url)
        if parts[0] or parts[1]:
            return False
        return True



    #
    # Resolves the given URL and returns it.
    #
    def __resolve_uri(self, uri):

        if (self.__is_relative_to_server(uri)):
            return urlparse.urljoin(self.__current_url, uri)
        return uri



    #
    # Cancel function for the stream
    #
    def __stream_cancel(self, *args): pass



    #
    # Reacts on requesting an URL.
    #
    def __on_request_url(self, document, url, stream):

        stream.set_cancel_func(self.__stream_cancel, document)
        def f(data): stream.write(data)
        self.__download_uri(url, f)



    #
    # Reacts on clicking a link.
    #
    def __on_link_clicked(self, document, link):

        try:
            self.__current_url = link
            self.__download_uri(link, self.__load_html)

        except:
            log("Could not resolve %s." % (link,))



    #
    # Loads the given data into the view.
    #
    def __load_html(self, data):

        self.__document.clear()
        self.__document.open_stream("text/html")
        self.__document.write_stream(data)
        self.__document.close_stream()



    def _setp_data(self, key, value):

        self.__load_html(value)
        self._setp(key, value)



    def _setp_uri(self, key, value):

        self.__current_url = value
        self.__load_html("<html><body>Loading...</body></html>")
        self.__download_uri(value, self.__load_html)
        self._setp(key, value)



    def _setp_scrollbars(self, key, value):

        if (value): self.__scrwin.set_policy(gtk.POLICY_AUTOMATIC,
                                             gtk.POLICY_AUTOMATIC)
        else: self.__scrwin.set_policy(gtk.POLICY_NEVER,
                                       gtk.POLICY_NEVER)

        self._setp(key, value)


    def _getp_loading(self, key): return self.__is_loading
