from main import HOME, SENSORPATHS
from utils import dialog

import os, sys

if "." not in sys.path: sys.path.append(".")
if HOME not in sys.path: sys.path.append(HOME)


#
# Factory class for dynamically loaded Sensors.
#
class _SensorFactory:

    def __init__(self):

        # a set to remember the modules loaded so far
        self.__modules = {}



    #
    # Creates and returns a Sensor of the given type or None if the Sensor
    # could not be created.
    #
    def create_sensor(self, name, args):

        # find and import the sensor
        oldcwd = os.getcwd()
        sensor = None
        module = None

        try:

            for p in SENSORPATHS:

                try:
                    os.chdir(p)
                except OSError:
                    continue

                # reload old modules to force using the latest version; this
                # means we can edit modules while running gDesklets
                # TODO: clean up

                try:
                    sensordir = os.path.abspath(name)
                    if (not os.path.exists(sensordir)): continue

                    if name in self.__modules:
                        module, path = self.__modules[name]
                        reload(module)
                    else:
                        if (name in sys.modules): del sys.modules[name]
                        module = __import__(name)
                        path = sensordir

                    break

                except ImportError, e:
                    from utils.ErrorFormatter import ErrorFormatter
                    details = ErrorFormatter().format(sys.exc_info())
                    print details
                    continue

                except Exception, e:
                    dialog.warning(
                        _("Error in sensor '%(name)s'") % vars(),
                        _("An error occured while loading a sensor. "
                          "This most likely means that your system does not "
                          "fulfill all its requirements."))
                    # a stack trace could be useful for debugging sensors
                    from utils.ErrorFormatter import ErrorFormatter
                    print ErrorFormatter().format(sys.exc_info())

            if (module):
                self.__modules[name] = (module, path)
                # initalize the sensor

                try:
                    os.chdir(path)
                    sensor = module.new_sensor(args)
                except:
                    from utils.ErrorFormatter import ErrorFormatter
                    details = ErrorFormatter().format(sys.exc_info())

                    dialog.warning(_("Error in sensor %(name)s") % vars(),
                                  _("An error occured while running a sensor."),
                                   details)

            else:
                print "Could not load sensor %(name)s" % vars()
                from utils.ErrorFormatter import ErrorFormatter
                details = ErrorFormatter().format(sys.exc_info())
                print details

                dialog.warning(
                    _("Could not find sensor '%(name)s'") % vars(),
                    _("A sensor could not be found. This usually means that "
                      "it has not been installed."))


            return sensor

        finally:
            os.chdir(oldcwd)


_singleton = _SensorFactory()
def SensorFactory(): return _singleton
