from main import ICON

import gtk


class TrayIcon:

    """ Class for a simple tray icon container. """

    def __init__(self):

        from utils.systray import Icon as SysTrayIcon

        self.__trayicon = SysTrayIcon("gDesklets")

        pixbuf = gtk.gdk.pixbuf_new_from_file(ICON)
        pixbuf = pixbuf.scale_simple(24, 24, gtk.gdk.INTERP_HYPER)

        icon = gtk.Image()
        icon.set_from_pixbuf(pixbuf)

        self.__ebox = gtk.EventBox()
        self.__ebox.add(icon)
        self.__ebox.show_all()
        self.__trayicon.add(self.__ebox)

        self.__menu = gtk.Menu()

        self.__ebox.connect("button-press-event", self.__on_button)


    def __on_button(self, src, event):

        if (event.button == 3):
            self.__menu.popup(None, None, None, event.button, event.time)


    def set_menu(self, items):

        for entry in items:
            if (entry):
                icon, label, callback = entry
                if (icon):
                    item = gtk.ImageMenuItem(icon)
                    if (label):
                        item.get_children()[0].set_text_with_mnemonic(label)
                else:
                    item = gtk.MenuItem(label)

                if (callback):
                    item.connect("activate", callback)
            else:
                item = gtk.MenuItem()

            item.show()
            self.__menu.append(item)


    def connect(self, event, *args):

        self.__ebox.connect(event, *args)
