#
# Abstraction layer for VFS operations to move gnomevfs dependency out of the
# core.
#

if (HAVE_WIN32 or not HAVE_GNOME):
    import urllib2

    OPEN_READ = "r"
    OPEN_WRITE = "w"

else:
    try:
        import gnomevfs
    except ImportError:
        import gnome.vfs as gnomevfs

    OPEN_READ = gnomevfs.OPEN_READ
    OPEN_WRITE = gnomevfs.OPEN_WRITE

        

def escape_path_urllib(uri):

    import urllib
    return urllib.quote(uri)


# does not exist in gnome-python 2.6; can't use it yet
#def escape_path(uri):
#
#    return gnomevfs.escape_path_string(uri)
escape_path = escape_path_urllib


def unescape_path(uri):

    import urllib2
    return urllib2.unquote(uri)



#
# Reads the entire file and returns its contents.
#
def read_entire_file(uri):

    try:
        uri = gnomevfs.read_entire_file(uri)
    except:
        log("Warning: Couldn't read file \"%s\"." % (uri,))
        raise

    return uri

def read_entire_file_urllib2(uri):

    if (not "://" in uri): uri = "file://" + uri

    try:
        uri = urllib2.urlopen(uri).read()
    except:
        log("Warning: Couldn't read file \"%s\"." % (uri,))
        raise

    return uri



#
# Opens the given URI and returns a file descriptor.
#
def open(uri, mode = OPEN_READ):

    try:
        fd = gnomevfs.open(uri, mode)
    except:
        log("Warning: Couldn't open file \"%s\"." % (uri,))
        return

    return fd

def open_urllib2(uri, mode = OPEN_READ):

    if (not "://" in uri): uri = "file://" + uri

    try:
        fd = urllib2.urlopen(uri)
    except:
        log("Warning: Couldn't open file \"%s\"." % (uri,))
        return

    return fd



#
# Returns whether the given URI exists.
#
def exists(uri):

    return gnomevfs.exists(gnomevfs.URI(uri))

def exists_urlllib2(uri):

    if (not "://" in uri): uri = "file://" + uri

    try:
        urllib2.urlopen(uri)
    except:
        return False
    else:
        return True



if (HAVE_WIN32 or not HAVE_GNOME):
    read_entire_file = read_entire_file_urllib2
    open = open_urllib2
    exists = exists_urllib2
    escape = escape_urllib

