from shell.Plugin import Plugin
from TipOfTheDay import TipOfTheDay
from main import HOME
from main.AboutDialog import AboutDialog

import gtk
import os

UNDEF = "-- undef --"


#
# Plugin for providing the user with help.
#
class Shell_Help(Plugin):

    def init(self):
        def obs_tip(src, cmd, value):
            if (cmd == src.OBS_TIP):
                self._set_config("current_tip", value)
            elif (cmd == src.OBS_TOGGLED):
                self._set_config("show_tip_of_the_day", value)


        current_tip = self._get_config("current_tip")
        if (current_tip == UNDEF): current_tip = 0
        self.__tip = TipOfTheDay(current_tip)
        show_tip = self._get_config("show_tip_of_the_day")
        if (show_tip == UNDEF): show_tip = True
        self.__tip.set_show(show_tip)
        self.__tip.add_observer(obs_tip)
        self.__tip.next_tip()
        if (show_tip): self.__show_tip()

        menu = self._get_plugin("UI_Menu")
        menu.insert("Slot2", "Help")
        menu.set_item("Help", None, _("_Help"), None)
        menu.set_item("Help/Tip", gtk.STOCK_DIALOG_INFO, _("_Tip of the Day"),
                      self.__show_tip)
        menu.set_separator("Help/Separator2")
        menu.set_item("Help/About", "gnome-stock-about", _("_About..."),
                      self.__show_about)

        self.__about = AboutDialog(os.path.join(HOME, "data"))


    def __show_tip(self):

        self.__tip.show()


    def __show_about(self):

        self.__about.show()

        
def get_class(): return Shell_Help
