/* GDHCPD, a GTK+ frontend for ISC DHCPD
 * Copyright C 2004, 2005 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/


#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "show_info.h"


void show_help(struct gdhcpd_widgets *widgets)
{
    gchar *help;
    help = g_strconcat(_("\n\n1. Adding scopes:\n"),
    _("	If eth1 has an address on the 192.168.0.0 net and you want to share\n"),
    _("	addresses in the range 192.168.0.1 to 192.168.0.254 you type the interface\n"),
    _("	name eth1 as the network card. Add 192.168.0.0 as the subnet address.\n"),
    _("	Add 255.255.255.0 as the netmask address and click apply.\n\n"),
    
    _("	Now you need to specify the address range to share.\n"),
    _("	This is done in the shared ipaddress interval section.\n"),
    _("	As range from you can specify 192.168.0.1 and as\n"),
    _("	range to you can use 192.168.0.254\n"),
    _("	Test the setup by clicking the activate button.\n"),
    _("	The deactivated state should now change to active.\n\n"),

    _("	Now you can supply the hosts with more information about this network.\n"),
    _("	This is done in the scope settings section.\n\n\n"),

    
    _("2. Adding single hosts:\n"),
    _("	Static ip addresses are mostly used for servers and printers that\n"),
    _("	require a static location but can also be used for any dhcp client.\n\n"),
    _("	Supplying a host that has hardware address 00:20:AF:F7:AA:AA with a\n"),
    _("	hostname and ipaddress can be done by adding a hostname and ip address\n"),
    _("	in the corresponding fields and the clients network cards hardware address\n"),
    _("	in the hardware address field then clicking apply.\n"),
    _("	(You can get the clients hardware addresses by running ifconfig on them.)\n"),
    _("	Test the setup by clicking the activate button.\n"),
    _("	The deactivated state should now change to active.\n\n"),

    _("	Now you can supply this host with more information such as DNS servers\n"),
    _("	and gateway, this is done in the hosts settings section.\n\n\n"),


    _("3. Current usage:\n"),
    _("	The leases tab shows currently active clients and what values such as the\n"),
    _("	ip addresses, subnet masks and hardware addresses they currently use.\n"),
    "\n", NULL);

    show_info(help);
    g_free(help);
}
