/*
Copyright (C) 2003 by Sean David Fleming

sean@power.curtin.edu.au

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

The GNU GPL can also be found at http://www.gnu.org
*/

#include <stdlib.h>
#include <stdio.h>

#include "gdis.h"
#include "file.h"
#include "parse.h"
#include "command.h"
#include "interface.h"

/* main data structures */
extern struct sysenv_pak sysenv;

void cmd_print(gchar *str)
{
struct model_pak *data;

data = model_ptr(sysenv.active, RECALL);

printf("{\n");
if (g_ascii_strncasecmp("sys", str, 3) == 0)
  {
  printf("     active model: %d\n", sysenv.active);
  printf("    loaded models: %d\n", sysenv.num_models);
  printf("working directory: %s\n", sysenv.cwd);
  }
if (g_ascii_strncasecmp("id", str, 2) == 0)
  {
  if (data)
    {
    printf("     name: %s\n", data->basename);
    printf("   number: %d\n", data->number);
    printf("full name: %s\n", data->filename);
    printf("       id: %d\n", data->id);
    }
  }
if (g_ascii_strncasecmp("energy", str, 6) == 0)
  {
  if (data)
    {
    printf(" Total energy: %f\n", data->gulp.energy);
    if (data->periodic == 2)
      {
      printf("   Esurf (un): %f\n", data->gulp.esurf[0]);
      printf("   Esurf (re): %f\n", data->gulp.esurf[1]);
      printf("    Eatt (un): %f\n", data->gulp.eatt[0]);
      printf("    Eatt (re): %f\n", data->gulp.eatt[1]);
      }
    }
  }

printf("}\n");
}

/* TODO - process input args for a file containing commands */
/* TODO - option to run this as a thread, even with the GUI running */
void cmd_init(gint argc, gchar **argv)
{
gint n, num_tokens;
gchar **buff, line[81];

for(;;)
  {
  if (sysenv.num_models)
     printf("[%d,%d] command: ", sysenv.active, sysenv.num_models);
  else
    printf("[-,-] command: ");

  fgets(line, 80, stdin);

  buff = tokenize(line, &num_tokens);
  if (num_tokens)
    {
/* quit */
    if ((g_ascii_strcasecmp("q", *buff) == 0) ||
        (g_ascii_strncasecmp("quit", *buff, 4) == 0))
      gdis_exit();

/* load or change directory */
    if ((g_ascii_strcasecmp("l", *buff) == 0) ||
        (g_ascii_strncasecmp("load", *buff, 4) == 0) ||
        (g_ascii_strncasecmp("cd", *buff, 2) == 0))
      if (num_tokens > 1)
        file_load(*(buff+1), NULL);

/* print */
    if (g_ascii_strcasecmp("p", *buff) == 0)
      {
      if (num_tokens > 1)
        {
        n = 1;
        while (n < num_tokens)
          {
          cmd_print(*(buff+n));
          n++;
          }
        }
      else
        cmd_print("sysenv");
      }
/* change models */
    if (g_ascii_strncasecmp("pick", *buff, 4) == 0)
      {
      if (num_tokens > 1)
        {
        n = (gint) str_to_float(*(buff+1));
        pick_model(n);
        }
      }
    }
  g_strfreev(buff);
  }
return;
}
