
#define MAX_SHELL_DIST 0.2

/**********************************/
/* spatial partitioning structure */
/**********************************/
struct zone_pak
{
gint grid[3];
GSList *cores;
};

/*******************************/
/* model sub-structure (atoms) */
/*******************************/
struct core_pak
{
/* main info */
gint atom_code;
gint status;
gint primary;          /* one of the initial atoms? */
gint orig;             /* original atom? (ie part of whole unit cell) */
gint ghost;            /* QM ghost atom */
gint render;           /* rendering type */

GSList *bonds;

gint molecule;         /* the molecule it's associated with */

/* associated shell/mol (if any) */
struct shel_pak *shell;
struct mol_pak *mol;

/* region type */
gint region;
/* coordinate data, fractional or cartesian (inhomogeneous) */
gdouble x[4];
/* rotated cartesian (inhomogeneous) */
gdouble rx[4];
/* velocities */
gdouble v[3];

/* vibration vector lists */
GSList *vibx_list;
GSList *viby_list;
GSList *vibz_list;

/* bonding cutoff */
gdouble bond_cutoff;
/* site occupancy factor */
gdouble sof;
/* charge info */
gint lookup_charge;
gdouble charge;
/* display data */
gdouble colour[4];

/* offset (atom only, NOT global) */
gdouble offset[3];

gchar label[LABEL_SIZE];
gchar tail[TAIL_SIZE];
};

/********************************/
/* model sub-structure (shells) */
/********************************/
struct shel_pak
{
gint atom_code;    /* atom type of the shell */
gint status;       /* normal, deleted, highlighted etc. */
gint primary;      /* one of the initial atoms? */
gint orig;         /* original atom? (ie part of whole unit cell) */
/* associated core (if any) */
struct core_pak *core;
/* region type (marvin only) */
gint region;
/* coord data */
gdouble x[4];
gdouble rx[4];
/* velocity */
gdouble v[3];
/* periodic image coordinate */
gint pic[3];
/* charge info */
gint lookup_charge;
gdouble charge;
/* display data */
gint colour[3];
/* offset (shell only, NOT global) */
gdouble offset[3];
/* file saving info */
gchar label[LABEL_SIZE];
gchar element[ELEM_LABEL_SIZE];
gchar tail[TAIL_SIZE];
};

/*******************************/
/* model sub-structure (bonds) */
/*******************************/
struct bond_pak
{
/* deleted/normal/hidden */
gint status;
/* single/double etc. */
gint type;
/* effect of PBC (if any) */
gint periodic;

/* constituent atom indices */
struct core_pak *atom1;
struct core_pak *atom2;
/* NEW - periodic image applied to atom2 for a bond to atom1 */
gint pic[3];
/* pixel position of bond centre */
gint px;
gint py;
};

/***********************************/
/* model sub-structure (molecules) */
/***********************************/
struct mol_pak
{
GSList *cores;
gdouble centroid[3];
};

/****************************/
/* periodic image structure */
/****************************/
struct image_pak
{
/* image coordinates */
gint pic[3];
/* cartesian coordinates */
gdouble rx[3];
};

/**********************************/
/* coords/connectivity prototypes */
/**********************************/

void calc_mols(struct model_pak *);
void calc_bonds(struct model_pak *);
void calc_coords(gint, struct model_pak *);

void free_core_list(struct model_pak *);
void free_mol_list(struct model_pak *);

void print_core(struct core_pak *);
void print_shell(struct shel_pak *);
void print_cores(struct model_pak *);
void print_shells(struct model_pak *);
void print_core_shell(struct model_pak *);
void dump_cores(GSList *);
void dump_shells(GSList *);

void con_init_zones(struct model_pak *);
void con_free_zones(struct model_pak *);
void con_info_zones(struct model_pak *);
struct zone_pak *get_zone(struct core_pak *, struct model_pak *);
GSList *con_core_zones(struct core_pak *, struct model_pak *);

void wipe_atom_bonds(struct core_pak *, struct model_pak *);
void calc_atom_bonds(struct core_pak *, struct model_pak *);
void redo_atom_bonds(struct core_pak *, struct model_pak *);
void user_bond(struct core_pak *, struct core_pak *, gint, struct model_pak *);
void make_bond(struct core_pak *, gint, struct model_pak *);
void merge_ubonds(struct model_pak *);

void template_core(gchar *, struct core_pak *, struct model_pak *);
struct core_pak *new_core(gchar *, struct model_pak *);
struct shel_pak *new_shell(gchar *, struct model_pak *);

struct core_pak *dup_core(struct core_pak *);
struct shel_pak *dup_shel(struct shel_pak *);
struct bond_pak *dup_bond(struct bond_pak *);

struct core_pak *copy_core(struct core_pak *, struct model_pak *,
                                              struct model_pak *);

void delete_commit(struct model_pak *);
void delete_core(struct core_pak *);
void delete_atom_at(gdouble *, struct model_pak *);
void delete_mol(struct mol_pak *, struct model_pak *);
void move_mol(gint, gint, gint);
void move_atom(gdouble *, gint);
void add_atom(gdouble *, struct model_pak *);
void change_atom_at(gint, gint, struct model_pak *);

void remove_duplicates(struct model_pak *);

struct core_pak *seek_core(struct core_pak *, gint, struct model_pak *);
struct shel_pak *seek_shel(struct shel_pak *, gint, struct model_pak *);

struct core_pak *seek_coord(gdouble *, gint, struct model_pak *);
struct core_pak *seek_coord2d(gdouble *, struct model_pak *);

void pixel_coord_map(gint, gint, gdouble *, struct model_pak *);

void atom_properties_update(struct core_pak *, struct model_pak *);

void init_elem(struct core_pak *, gint , struct model_pak *);

gint fractional_clamp(gdouble *, gint *, gint);

void atom_colour_scheme(gint, struct core_pak *, struct model_pak *);
void model_colour_scheme(gint, struct model_pak *);

void init_atom_colour(struct core_pak *, struct model_pak *);
void init_atom_charge(struct core_pak *, struct model_pak *);
void init_model_charges(struct model_pak *);

GSList *find_unique(gint, struct model_pak *);

gint cent_coords(gint, struct model_pak *);

void cor_calc_xlimits(gdouble *, gdouble *, GSList *);


