/*
Copyright (C) 2003 by Sean David Fleming

sean@power.curtin.edu.au

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

The GNU GPL can also be found at http://www.gnu.org
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <math.h>
#include <gdk/gdk.h>

#include "gdis.h"
#include "coords.h"
#include "interface.h"
#include "matrix.h"
#include "morph.h"

#define DEBUG 0

/* externals  - put in sysenv? */
extern GtkWidget *window;
extern GdkPixmap *pixmap;

extern struct sysenv_pak sysenv;
extern struct elem_pak elements[];

/*******************************************/
/* general call to expose the drawing area */
/*******************************************/
/* deprec. */
#define DEBUG_EXPOSE_CANVAS 0
void expose_canvas()
{
GdkRectangle update_rect;

/* this is a general update, ie redraws gtk-gdk or opengl canvas */
update_rect.x = sysenv.x; 
update_rect.y = sysenv.y + 50;          /* YTF is this needed??? */
update_rect.width = sysenv.width;
update_rect.height = sysenv.height;

#if DEBUG_EXPOSE_CANVAS
printf("    origin: (%d,%d)\n",update_rect.x,update_rect.y);
printf("dimensions:  %dx%d\n",update_rect.width,update_rect.height);
#endif
}

/****************************/
/* Ensure a model is viewed */
/****************************/
void force_view(gint model)
{
gint i, j, na, nb, np;

/* nothing to do if the model is already displayed */
for (i=0 ; i<sysenv.num_displayed ; i++)
  if (sysenv.displayed[i] == model)
    return;

/* determine where to display the model */
np = model;                    /* available models previous */
na = sysenv.num_models-np-1;   /* available models after */

/* can we completely forward fill? */
if (na >= sysenv.num_displayed-1)
  {
  j = model;
  for (i=0 ; i<sysenv.num_displayed ; i++)
    sysenv.displayed[i] = j++;
  }
else
  {
/* number of required back fill models */
  i = sysenv.num_displayed-na-1;
/* assign number of possible back fill models */
  nb = (np >= i) ? i : np;
/* fill as much as possible */
  i=model-nb;
  j=0;
  while (j<sysenv.num_displayed)
    {
    if (i<sysenv.num_models)
      sysenv.displayed[j++]=i++;
    else
      sysenv.displayed[j++]=-1;
    }
  }
}

/**************************/
/* default system colours */
/**************************/
void set_colour(GdkColor *colour, gint name)
{

/* determine the required RGB code */
switch(name)
  {
  case BLACK:
    colour->red = 0;
    colour->green = 0;
    colour->blue = 0;
    break;
  case RED:
    colour->red = 65535;
    colour->green = 0;
    colour->blue = 0;
    break;
  case GREEN:
    colour->red = 0;
    colour->green = 65535;
    colour->blue = 0;
    break;
  case BLUE:
    colour->red = 0;
    colour->green = 0;
    colour->blue = 65535;
    break;
  case YELLOW:
    colour->red = 65535;
    colour->green = 65535;
    colour->blue = 0;
    break;
  case ORANGE:
  case GOLD:
    colour->red = 50000;
    colour->green = 50000;
    colour->blue = 10000;
    break;
  case SEA_GREEN:
    colour->red = 11150;
    colour->green = 55705;
    colour->blue = 40632;
    break;
  case AQUAMARINE:
    colour->red = 10000;
    colour->green = 65535;
    colour->blue = 50000;
    break;
  case NAVY_BLUE:
    colour->red = 0;
    colour->green = 32003;
    colour->blue = 65535;
    break;
  case LIGHT_TAN:
    colour->red = 65535;
    colour->green = 65535;
    colour->blue = 53739;
    break;
  case LEMON:
    colour->red = 64890;
    colour->green = 63569;
    colour->blue = 29491;
    break;
  case PURPLE:
    colour->red = 40000;
    colour->green = 20030;
    colour->blue = 40000;
    break;
  case WHITE:
  default:
    colour->red = 65535;
    colour->green = 65535;
    colour->blue = 65535;
    break;
  }

if (!gdk_color_alloc(sysenv.colourmap, colour))
  printf("Warning: colour assignment failed.\n");

}

/****************************/
/* Colour interface for RGB */
/****************************/
void set_rgb_colour(GdkGC *gc, gint *rgb)
{
GdkColor colour;

/* get the colour map */
colour.red = *rgb;
colour.green = *(rgb+1);
colour.blue = *(rgb+2);

/* TODO - default (safe) colour if fails? */
if (!gdk_color_alloc(sysenv.colourmap, &colour))
  printf("Warning: colour assignment failed.\n");

gdk_gc_set_foreground(gc, &colour);
}

/************************************************************/
/* process data structures to get current model state label */
/************************************************************/
gchar *get_mode_label(struct model_pak *data)
{
gchar *label;

switch(data->mode)
  {
  case FREE:
    label = g_strdup("normal");
    break;
  case ATOM_ADD:
    label = g_strdup("add atoms");
    break;
  case ATOM_MOVE:
    label = g_strdup("move atoms");
    break;
  case ATOM_DELETE:
    label = g_strdup("delete atoms");
    break;
  case BOND_DELETE:
    label = g_strdup("delete bonds");
    break;
  case DELETE_VECTOR:
    label = g_strdup("delete vectors");
    break;
  case BOND_SINGLE:
    label = g_strdup_printf("add single bonds (%1d/2)", data->state);
    break;
  case BOND_DOUBLE:
    label = g_strdup_printf("add double bonds (%1d/2)", data->state);
    break;
  case BOND_TRIPLE:
    label = g_strdup_printf("add triple bonds (%1d/2)", data->state);
    break;
  case MOL_MOVE:
    label = g_strdup("move mol");
    break;
  case MOL_DELETE:
    label = g_strdup("delete mols");
    break;
  case BOND_INFO:
    label = g_strdup("bonds");
    break;
  case DIST_INFO:
    label = g_strdup_printf("distance selection (%1d/2)", data->state);
    break;
  case ANGLE_INFO:
    label = g_strdup_printf("angle selection (%1d/3)", data->state);
    break;
  case DIHEDRAL_INFO:
    label = g_strdup_printf("dihedral selection (%1d/4)", data->state);
    break;

/* TODO - more complex eg if selecting vectors/whatever "vector point: 1/2" */
/* also for others eg BOND_INFO */
  case DEFINE_RIBBON:
    label = g_strdup("define ribbon");
    break;
  case DEFINE_VECTOR:
    label = g_strdup_printf("define vector (%1d/2)", data->state);
    break;
  case DEFINE_PLANE:
    label = g_strdup_printf("define plane (%1d/3)", data->state);
    break;

  case ANIMATING:
    label = g_strdup_printf("Frame: %-4d", data->cur_frame);
    break;

  default:
    label = g_strdup("undefined");
    break;
  }

return(label);
}

