
#ifdef __WIN32
#define DIR_SEP "\\"
#else
#define DIR_SEP "/"
#endif

#define KEYWORD_LEN 10

struct keyword_pak
{
gchar *label;
gint code;
};

extern struct keyword_pak keywords[];

/* main */
void file_init(void);
gint fgetline(FILE *, gchar *);
gchar *file_read_line(FILE *);
gint set_path(const gchar *);
struct file_pak *get_file_info(const gpointer *, gint);
void file_load(gchar *, struct model_pak *);
void file_save(void);
gint file_save_as(gchar *, struct model_pak *);
gchar *gun(const gchar *);

/* dialog control */
void file_dialog(gchar *, gchar *, gpointer (gchar *,  struct model_pak *), gint);
void file_load_dialog(void);
void file_save_dialog(void);

/* file writing routines */
gint write_arc(gchar *, struct model_pak *);
gint write_cif(gchar *, struct model_pak *);
gint write_fdf(gchar *, struct model_pak *);
gint write_gulp(gchar *, struct model_pak *);
gint write_gmf(gchar *, struct model_pak *);
gint write_planes(gchar *, struct model_pak *);
gint write_marvin(gchar *, struct model_pak *);
gint write_xml(gchar *, struct model_pak *);
gint write_xtl(gchar *, struct model_pak *);
gint write_xyz(gchar *, struct model_pak *);
gint write_gms(gchar *, struct model_pak *);
gint write_diffax(gchar *, struct model_pak *);

void write_sfc_data(FILE *);

/* file reading routines */
gint read_arc(gchar *, struct model_pak *);
gint read_cif(gchar *, struct model_pak *);
gint read_fdf(gchar *, struct model_pak *);
gint read_gulp(gchar *, struct model_pak *);
gint read_gulp_output(gchar *, struct model_pak *);
gint read_gmf(gchar *, struct model_pak *);
gint read_planes(gchar *, struct model_pak *);
gint read_marvin(gchar *, struct model_pak *);
gint read_mvnout(gchar *, struct model_pak *);
gint read_sout(gchar *, struct model_pak *);
gint read_xml(gchar *, struct model_pak *);
gint read_xtl(gchar *, struct model_pak *);
gint read_xyz(gchar *, struct model_pak *);
gint read_using_babel(gchar *, struct model_pak *);
gint read_gms(gchar *, struct model_pak *);
gint read_gms_out(gchar *, struct model_pak *);
gint read_diffax(gchar *, struct model_pak *);
gint read_about(gchar *, struct model_pak *);
gint read_pdb(gchar *, struct model_pak *);

/* separate scheme for these special cases */
gint read_trj_header(FILE *, struct model_pak *);
gint read_trj_frame(FILE *, struct model_pak *, gint);
gint read_arc_frame(FILE *, struct model_pak *);
gint read_sout_frame(FILE *, struct model_pak *);
gint read_gms_out_frame(FILE *, struct model_pak *);
gint read_about_frame(FILE *, struct model_pak *);
gint read_pdb_frame(FILE *, struct model_pak *);
gint load_planes(gchar *, struct model_pak *);

void swap_bytes(void *, const gint);

void gdis_blurb(FILE *);

/* parsing */
void capitals(gchar *, gchar *);
gchar **get_tokenized_line(FILE *, gint *);
gint get_keyword_code(const gchar *);

gint read_frame(FILE *, gint, struct model_pak *);
gint read_raw_frame(FILE *, gint, struct model_pak *);
gint add_frame_offset(FILE *, struct model_pak *);

gint hash_strcmp(gconstpointer, gconstpointer);

GSList *get_dir_list(const char *, gint);
struct file_pak *get_file_info(const gpointer *, gint);

