/*
Copyright (C) 2003 by Sean David Fleming

sean@power.curtin.edu.au

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

The GNU GPL can also be found at http://www.gnu.org
*/

#define VERSION 0.81
#define PATCH 0

#define MAX_ELEMENTS 110
#define MAX_TOKENS 100
#define MAX_ELEM_TOKENS 7
#define MAX_PATH_ITEMS 50
#define MAX_DISPLAYED 9
#define MAX_MODELS 14
/* NB: allowing sof's require making this unrealistically large */
#define MAX_BONDS 16
#define MAX_MOL_SIZE 100
#define MAX_POTENTIALS 256
#define MAX_MODEL_DIALOGS 10
#define MAX_DIALOGS 15
#define ELEM_LABEL_SIZE 7
#define LABEL_SIZE 7
#define TAIL_SIZE 80
#define DEFAULT_NA 30
#define DEFAULT_NL 10
#define DEFAULT_SS 10
#define BOND_FUDGE 0.1
#define RMAX_FUDGE 1.1
#define RMAX_SCALE 1.1
#define ROTATE_SCALE 1.0
#define SCALE_MAG 10
#define MESH_POINTS_MIN 2
#define MESH_POINTS_MAX 20
#define MESH_SPACE_MIN 0.1
#define MESH_SPACE_MAX 10.0
/* 1st is roughly (no accounting for latmat) in Angs */
#define POSITION_TOLERANCE 0.01
#define FRACTION_TOLERANCE 0.000001

/* parsing */
#define FILELEN 150
#define LINELEN  300
#define ITEMLEN  50

/* maths */
#define PI 3.1415926535897932384626433832795
#define D2R 0.01745329252
#define R2D 57.295779513
#define AU2ANG 0.529177249

/* location of data file - TODO - IMPROVE ie rc file/scan etc */
#ifdef __WIN32
#define INIT_FILE "gdis.rc"
#else
#define INIT_FILE ".gdisrc"
#endif

#define ELEM_FILE "gdis.elements"
#define LIBRARY "none"

/*
#ifdef __WIN32
#define GFONT "-adobe-helvetica-medium-r-normal--*-120-*-*-*-*-*-*"
#define DFONT "-adobe-helvetica-medium-r-normal--*-160-*-*-*-*-*-*"
#else
#endif
*/
#define GTK_FONT "Sans 10"
#define GL_FONT "Sans 14"

/* camera placement for POVray */
#define FRAMEZ 2003

/* non-contact molecular surface types */
#define REENTRANT -1
#define HOLE -2
#define VALLEY -3

/* convenience macros */
#define SPIN_FVAL gtk_spin_button_get_value_as_float
#define SPIN_IVAL gtk_spin_button_get_value_as_int

#define P3VEC(s,v) (printf("%s (%.8lf, %.8lf, %.8lf)\n",s,*v,*(v+1),*(v+2)))
#define P3MAT(s,m) {printf("%s\n|%lf, %lf, %lf|\n|%lf, %lf, %lf|\n|%lf, %lf, %lf|\n",\
s,*m,*(m+1),*(m+2),*(m+3),*(m+4),*(m+5),*(m+6),*(m+7),*(m+8));}

#define SUBLINE(pix,gc,sub,x1,y1,x2,y2) (gdk_draw_line(pix, gc, \
x1+sysenv.subcenx[sub], y1+sysenv.subceny[sub], \
x2+sysenv.subcenx[sub], y2+sysenv.subceny[sub]))

#define SUBTEXT(pix,gc,sub,x1,y1,text) (gdk_draw_text(pix, sysenv.dfont, gc, \
x1+sysenv.subcenx[sub], y1+sysenv.subceny[sub], \
text, strlen(text)))

#define SUBARC(pix,gc,sub,x,y,w,h,a1,a2) (gdk_draw_arc(pix, gc, FALSE,\
x+sysenv.subcenx[sub], y+sysenv.subceny[sub], w, h, a1, a2))

#define FSUBARC(pix,gc,sub,x,y,w,h,a1,a2) (gdk_draw_arc(pix, gc, TRUE,\
x+sysenv.subcenx[sub], y+sysenv.subceny[sub], w, h, a1, a2))

/* linked list loops */
#define FOR_SLIST(item, list) for (item=list ; (item=g_slist_next(item)) ; )
#define FOR_LIST(item, list) for (item=list ; (item=g_list_next(item)) ; )


/* file parsing keyword/option stuff */
enum 
{
/* 0 - 9*/
E_SINGLE, E_OPTIMIZE, DOCK, FREE_ENERGY, MD, CONP, CONV,
MOLE, MOLMEC, MOLQ, NOBUILD,
NAME, CELL, CART, FRAC, S_FRAC,
SURFACE_CELL, SURFACE_VECTORS, POLYMER_CELL, POLYMER_VECTOR, LATTICE_VECTORS,
SPACE, ORIGIN, SPECIES, MAXCYC, ENERGY, TOTAL_ENERGY, SBULK_ENERGY,
HARMONIC, MORSE, BUCKINGHAM, LENNARD,
THREE, UREYBRADLEY, FOUR, TORSION, OUTOFPLANE, SPRING,
SWITCH_OFF, SWITCH_ON, CYCLE, GNORM, BFGS_OPT, RFO_OPT, CONJ_OPT, UNIT_HESSIAN,
TEMPERATURE, ENSEMBLE, SHRINK, QEQ, ZSISA, COMPARE, NOSYM, FIX, PHONON, EIGEN,
KPOINTS, GULP_LIBRARY, 
TITLE, END, GULP_OBSERVABLES, TEMP_FILE, DUMP_FILE, LIB_FILE, OUTPUT, 
SUPER_CELL, NVE, NVT, NPT, 
NO_ESURF, NO_EATT, D_HKL,
/* LABEL is new */
ELEMENT, SYMBOL, NUMBER, LABEL, WEIGHT, COVALENT, IONIC, VDW, CHARGE, COLOUR,
LABEL_NORMAL, LABEL_GHOST,
COORD_X, COORD_Y, COORD_Z,
CIF_AUDIT, CIF_CREATION_DATE, CIF_DATA_START, CIF_LOOP_START,
CIF_DATABASE_CODE, CIF_CHEMICAL_NAME, CIF_MINERAL_NAME,
CIF_CELL_A, CIF_CELL_B, CIF_CELL_C, CIF_CELL_ALPHA, CIF_CELL_BETA,
CIF_CELL_GAMMA, CIF_SPACE_NAME, CIF_SPACE_NUM, CIF_REFINE,
CIF_ATOM_SITE, CIF_LABEL, CIF_TYPE_SYMBOL,
CIF_SOF, CIF_EQUIV_SITE, CIF_EQUIV_POS,
CIF_CART_X, CIF_CART_Y, CIF_CART_Z, CIF_FRAC_X, CIF_FRAC_Y, CIF_FRAC_Z,
MARVIN_BASIS, MARVIN_COORD,
DIPOLE_TOLERANCE,
GDIS_ELEM_START, GDIS_END
};

/* misc specifiers */
enum {UP, DOWN};
enum {DEFAULT, MODIFIED};
enum {ALL, SINGLE};
enum {APPEND, INSERT, REPLACE};
enum {LOW, MEDIUM, HIGH};
enum {CARTESIAN, OTHER};
enum {PLANE_XY, PLANE_YZ, PLANE_XZ};
enum {CHECK, CONDENSE};
enum {EXEC_PATH};
enum {SELECTED, ANY};
enum {BY_FILE_ID, BY_EXTENSION, BY_LABEL};
enum {STANDARD, WARNING, ERROR};

/* surface types */
enum {SOLSURF, MOLSURF};

/* some colour names */
enum {BLACK, WHITE, RED, GREEN, BLUE, YELLOW, GOLD, ORANGE,
      SEA_GREEN, AQUAMARINE, NAVY_BLUE, LIGHT_TAN, LEMON, PURPLE};

/* data type specifiers */
enum {MODEL, CORE, BOND, UBOND, HBOND, MOL, SHELL, ELEM,
      ATOM_LABEL, ELEM_MOL, REGION,
      GEOM, DIST, ANGLE, DIHEDRAL, SELECT,
      POLYHEDRAL, ZEOLITE, RIBBON,
      SPATIAL_VECTOR, SPATIAL_VECTORS, SPATIAL_PLANE,
      SPATIAL_TRIANGLE, SPATIAL_POLYGON, SPATIAL_MOLSURF};

/* init_objs() call modes */
enum 
{
INIT_COORDS, CENT_COORDS, REDO_COORDS,
MESH_ON, MESH_OFF, BOX_ON, BOX_OFF,
REFRESH_COLOUR, REFRESH_BONDS, SOF_COLOUR
};

/* crystal lattice types */
enum {XS_UNKNOWN, XS_TRICLINIC, XS_MONOCLINIC, XS_ORTHOROMBIC,
      XS_TETRAGONAL, XS_TRIGONAL, XS_HEXAGONAL, XS_CUBIC};

/* unit cell facets */
enum {A_LO, A_HI, B_LO, B_HI, C_LO, C_HI};

/* general update call modes */
enum {INITIAL, REFRESH, RESTORE, CREATE};

/* atom status flags */
#define NORMAL 1
#define DELETED 2
#define HIDDEN 4
#define SELECT 8
#define PRUNED 16
#define ZEOL_HIDDEN 32

/* drawing mode */
enum {DRAW_OFF, DRAW_GDK, DRAW_GL};

/* creator grid */
enum {MESH_POINTS, MESH_SPACING};

/* marvin region types */
enum {REGION1A, REGION2A, REGION1B, REGION2B, NONE};

/* selection modes */
enum {CLEAN, START, UPDATE, STOP, ASSIGN, RECALL, RELEASE};

/*****************/
/* MAIN INCLUDES */
/*****************/
#include <glib.h>
#include <gtk/gtk.h>
#include "pak.h"

#if GTK_EXTRA
#include <gtkextra/gtksheet.h>
#endif

