/* 
   Copyright (C) 1999 Kyle R. Burton, All Rights Reserved
   mortis@voicenet.com
   http://www.bgw.org
   http://www.voicenet.com/~mortis

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/*
Modified by Sean Fleming for the GDIS program
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <unistd.h>
#include <assert.h>
#include <errno.h>
#include <gtk/gtk.h>

#include "gdis.h"
#include "matrix.h"
#include "render.h"
#include "gperiodic.h"
#include "gtkshorts.h"
#include "interface.h"
#include "dialog.h"
#include "opengl.h"

extern struct sysenv_pak sysenv;
extern struct elem_pak elements[];
extern GtkWidget *window;

/* currently modifiable elem  */
/* FIXME - since it's a global, only one dialog can be allowed at a time */
struct elem_pak elem;

/*************/
/* gtk hooks */
/*************/
void dialog_destroy(GtkWidget *w)
{
gtk_grab_remove(GTK_WIDGET(w));
}

/**************************************************/
/* make a change to an elements's covalent radius */ 
/**************************************************/
void elem_change_cova(GtkWidget *w, gpointer *spin)
{
gint code;
gdouble r;
GtkWidget *parent;

/* retrieve title from top level widget, which */
/* should be the element to apply the change to */
parent = gtk_widget_get_toplevel(GTK_WIDGET(spin));
code = elem_type(GTK_WINDOW(parent)->title);
r = gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(spin));

elem.cova = r;
}

/*********************************************/
/* make a change to an elements's vdw radius */ 
/*********************************************/
void elem_change_vdw(GtkWidget *w, gpointer *spin)
{
gint code;
gdouble r;
GtkWidget *parent;

/* retrieve title from top level widget, which */
/* should be the element to apply the change to */
parent = gtk_widget_get_toplevel(GTK_WIDGET(spin));
code = elem_type(GTK_WINDOW(parent)->title);
r = gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(spin));

elem.vdw = r;
}

/*****************************************/
/* make a change to an elements's charge */ 
/*****************************************/
void elem_change_charge(GtkWidget *w, gpointer *spin)
{
gint code;
gdouble r;
GtkWidget *parent;

/* retrieve title from top level widget, which */
/* should be the element to apply the change to */
parent = gtk_widget_get_toplevel(GTK_WIDGET(spin));
code = elem_type(GTK_WINDOW(parent)->title);
r = gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(spin));

elem.charge = r;
}

/***************************/
/* update element database */
/***************************/
void elem_change_current(GtkWidget *w, struct elem_pak *element)
{
struct model_pak *data;

data = model_ptr(sysenv.active, RECALL);
if (data)
  {
  put_elem_data(element, data);
  refresh_connectivity(data);
  init_objs(REFRESH_COLOUR, data);
  redraw_canvas(SINGLE);
  }
}

void elem_change_global(GtkWidget *w, struct elem_pak *element)
{
struct model_pak *data;

put_elem_data(element, NULL);
refresh_table();

data = model_ptr(sysenv.active, RECALL);
if (data)
  {
  refresh_connectivity(data);
  init_objs(REFRESH_COLOUR, data);
  redraw_canvas(SINGLE);
  }
}

void elem_reset(GtkWidget *w, struct elem_pak *element)
{
GSList *list;
struct elem_pak *tmp;
struct model_pak *data;

data = model_ptr(sysenv.active, RECALL);

list = sysenv.elements;
while(list != NULL)
  {
  tmp = (struct elem_pak *) list->data;
  list = g_slist_next(list);
  if (tmp->number == element->number)
    sysenv.elements = g_slist_remove(sysenv.elements, tmp);
  }
refresh_table();

if (data)
  {
  refresh_connectivity(data);
  init_objs(REFRESH_COLOUR, data);
  redraw_canvas(SINGLE);
  }
}

/***************************/
/* Single element dialogue */
/***************************/
void display_element_dialog(GtkWidget *w, gint i)
{
gint id;
GtkWidget *frame, *vbox, *hbox;
GtkWidget *label, *button, *cr_spin, *vr_spin, *spin;
GtkStyle *style, *newstyle;
GtkAdjustment *adj;
struct table_entry *entry;
struct dialog_pak *edit_elem;

entry = (struct table_entry *) &table[i];

/* get global elem data */
get_elem_data(i+1, &elem, NULL);

/* TODO - request (only ONE allowed) */
/* display this in a dialog box... */

/* retrieve a suitable dialog */
if ((id = request_dialog(-1, ELEM_EDIT)) < 0)
  return;
edit_elem = &sysenv.dialog[id];

/* create the main window */
edit_elem->win = gtk_dialog_new();
gtk_window_set_title(GTK_WINDOW(edit_elem->win), elements[i+1].symbol);
g_signal_connect(GTK_OBJECT(edit_elem->win), "destroy",
                 GTK_SIGNAL_FUNC(event_close_dialog), (gpointer) id);

frame = gtk_frame_new(NULL);
gtk_box_pack_start(GTK_BOX(GTK_DIALOG(edit_elem->win)->vbox), frame, TRUE, FALSE, 0);
gtk_container_set_border_width(GTK_CONTAINER(frame), PANEL_SPACING);

/* two column element data display */
hbox = gtk_hbox_new(FALSE,0);
gtk_container_add(GTK_CONTAINER(frame), hbox);
gtk_container_set_border_width(GTK_CONTAINER(hbox), PANEL_SPACING);

/* left vbox - titles */
vbox = gtk_vbox_new(TRUE,0);
gtk_box_pack_start(GTK_BOX(hbox), vbox, TRUE, TRUE, 0);

/* TODO - put in a for loop? */
label = gtk_label_new("Name:");
gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
label = gtk_label_new("Symbol:");
gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
label = gtk_label_new("Number:");
gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
label = gtk_label_new("Weight:");
gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
label = gtk_label_new("Ionic/Covalent radius:");
gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
label = gtk_label_new("VdW radius:");
gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
label = gtk_label_new("Charge:");
gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
label = gtk_label_new("Colour:");
gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);

/* right vbox - data */
vbox = gtk_vbox_new(TRUE,0);
gtk_box_pack_start(GTK_BOX(hbox), vbox, TRUE, TRUE, 0);

label = gtk_label_new (elem.name);
gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
label = gtk_label_new (elem.symbol);
gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
label = gtk_label_new (g_strdup_printf("%d", elem.number));
gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
label = gtk_label_new (g_strdup_printf("%8.4f", elem.weight));
gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);

/* cova radius */
adj = (GtkAdjustment *) gtk_adjustment_new
                        (elem.cova, 0.1, 3.0, 0.1, 0.1, 0);
cr_spin = gtk_spin_button_new (adj, 0.1, 2);
gtk_spin_button_set_wrap(GTK_SPIN_BUTTON(cr_spin), FALSE);
g_signal_connect(GTK_OBJECT (adj), "value_changed",
                 GTK_SIGNAL_FUNC(elem_change_cova), (gpointer) cr_spin);
gtk_box_pack_start(GTK_BOX(vbox), cr_spin, TRUE, TRUE, 0);

/* vdW radius */
adj = (GtkAdjustment *) gtk_adjustment_new
                        (elem.vdw, 0.1, 4.0, 0.1, 0.1, 0);
vr_spin = gtk_spin_button_new(adj, 0.1, 2);
gtk_spin_button_set_wrap(GTK_SPIN_BUTTON(vr_spin), FALSE);
g_signal_connect(GTK_OBJECT (adj), "value_changed",
                 GTK_SIGNAL_FUNC (elem_change_vdw), (gpointer) vr_spin);
gtk_box_pack_start(GTK_BOX(vbox), vr_spin, TRUE, TRUE, 0);

/* charge */
adj = (GtkAdjustment *) gtk_adjustment_new
                        (elem.charge, -7.0, 7.0, 0.1, 0.2, 0);
spin = gtk_spin_button_new(adj, 0.1, 2);
gtk_spin_button_set_wrap(GTK_SPIN_BUTTON(spin), FALSE);
g_signal_connect(GTK_OBJECT(adj), "value_changed",
                 GTK_SIGNAL_FUNC(elem_change_charge), (gpointer) spin);
gtk_box_pack_start(GTK_BOX(vbox), spin, TRUE, TRUE, 0);


/* button with element's colour, click to edit */
gtk_widget_realize(edit_elem->win);
style = gtk_widget_get_style(window);
newstyle = gtk_style_copy(style);
newstyle->bg[0].red   = elem.colour[0];
newstyle->bg[0].green = elem.colour[1];
newstyle->bg[0].blue  = elem.colour[2];
newstyle->bg[2].red   = elem.colour[0];
newstyle->bg[2].green = elem.colour[1];
newstyle->bg[2].blue  = elem.colour[2];
/* colour update */
button = gtk_button_new_with_label("    edit    ");
gtk_box_pack_start(GTK_BOX(vbox), button, TRUE, TRUE, 0);
gtk_widget_set_style(button, newstyle);
g_signal_connect(GTK_OBJECT(button), "clicked",
                 GTK_SIGNAL_FUNC(modify_colour_dialog), elem.colour);

/* application buttons/check boxes */
frame = gtk_frame_new(NULL);
gtk_box_pack_start(GTK_BOX(GTK_DIALOG(edit_elem->win)->vbox), frame, TRUE, FALSE, 0);
gtk_container_set_border_width(GTK_CONTAINER(frame), PANEL_SPACING);

/* two column element data display */
vbox = gtk_vbox_new(FALSE,0);
gtk_container_add(GTK_CONTAINER(frame), vbox);
gtk_container_set_border_width(GTK_CONTAINER(vbox), PANEL_SPACING);

gtksh_button(" Apply to current ", elem_change_current, &elem, vbox, FF);
gtksh_button(" Apply globally", elem_change_global, &elem, vbox, FF);
gtksh_button(" Reset values", elem_reset, &elem, vbox, FF);

gtksh_stock_button(GTK_STOCK_CLOSE, event_close_dialog, GINT_TO_POINTER(id),
                   GTK_DIALOG(edit_elem->win)->action_area);

gtk_widget_show_all(edit_elem->win);
}

/***********************************/
/* on the fly table colour refresh */
/***********************************/
void refresh_table(void)
{
gint i;
GtkStyle *style;
struct elem_pak element;

if (!dialog_active(GPERIODIC))
  return;

for(i=0 ; i<sizeof(table) ; i++) 
  {
/* stop if no more element data (NB: gperiodic/gdis index mismatch) */
  if(i >= sysenv.num_elements-1) 
    break;
/* stop if no more element data (NB: gperiodic/gdis index mismatch) */
  if (get_elem_data(i+1, &element, NULL))
    break;
/* jump the gaps */
  if (GTK_IS_WIDGET(table[i].button)) 
    {
    style = gtk_style_copy(gtk_widget_get_style(window));
    style->bg[GTK_STATE_NORMAL].red = element.colour[0];
    style->bg[GTK_STATE_NORMAL].green = element.colour[1];
    style->bg[GTK_STATE_NORMAL].blue = element.colour[2];
    gtk_widget_set_style(table[i].button, style);
    }
  }
}

/*****************************************************************/
/* update the current model with values from the global database */
/*****************************************************************/
void refresh_model_from_table(GtkWidget *w, gpointer dummy)
{
struct model_pak *model;

model = model_ptr(sysenv.active, RECALL);
if (model)
  {
/* TODO - refresh bonding/connectivity & other data? */
/* refresh colour */
  init_objs(REFRESH_COLOUR, model);
  redraw_canvas(SINGLE);
  }
}

/******************************/
/* Construct a periodic table */
/******************************/
void gperiodic_win(void)
{
gint i, id;
gchar *buff=NULL;
GtkWidget *label, *vbox, *periodic_table, *hbox;
GtkStyle *style;
struct dialog_pak *gperiodic;
struct elem_pak elem;

/* retrieve a suitable dialog */
if ((id = request_dialog(-1, GPERIODIC)) < 0)
  return;
gperiodic = &sysenv.dialog[id];

/* create the main window */
gperiodic->win = gtk_dialog_new();
gtk_window_set_title(GTK_WINDOW(gperiodic->win),"GPeriodic");
g_signal_connect(GTK_OBJECT(gperiodic->win), "destroy",
                 GTK_SIGNAL_FUNC(event_close_dialog), (gpointer) id);

/* background colour for GPeriodic - LEMON */
style = gtk_widget_get_style(window);
style->bg[0].red = 64890;
style->bg[0].green = 65535;
style->bg[0].blue = 53739;
gtk_widget_set_style(gperiodic->win, style);

/* use a vbox for the menubar and the table of elements... */
vbox = gtk_vbox_new(FALSE, PANEL_SPACING);
gtk_container_border_width(GTK_CONTAINER(vbox), PANEL_SPACING);
gtk_container_add(GTK_CONTAINER(GTK_DIALOG(gperiodic->win)->vbox), vbox);

/* nice heading */
label = gtk_label_new("Periodic Table of the Elements");
gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);

/* create the table widget to hold the periodic table */
periodic_table = gtk_table_new(11, 18, TRUE);
gtk_box_pack_end(GTK_BOX(vbox), periodic_table, TRUE, TRUE, 0);

/* now for each element in the table of elements, create a display */
/* item for it, and add it to the table... */
for(i=0 ; i<sizeof(table) ; i++ ) 
  {
/* stop if no more element data (NB: gperiodic/gdis index mismatch) */
  if (get_elem_data(i+1, &elem, NULL))
    break;
/* create the button */
  table[i].button = gtk_button_new_with_label(elem.symbol);
    {
    GtkStyle *button_style = gtk_widget_get_style(window);
    table[i].style = gtk_style_copy(button_style);

/* normal colour */
    table[i].style->bg[0].red   = elem.colour[0];
    table[i].style->bg[0].green = elem.colour[1];
    table[i].style->bg[0].blue  = elem.colour[2];
/* colour under mouse pointer */
    table[i].style->bg[2].red   = 65535;
    table[i].style->bg[2].green = 65535;
    table[i].style->bg[2].blue  = 65535;

    gtk_widget_set_style(table[i].button, table[i].style );
    }

/* set up a string for the tooltips */
  buff = g_strdup_printf("%s  n:%d", elem.symbol, elem.number);

/* create a new tooltips object... */
  table[i].tooltip = gtk_tooltips_new();
  gtk_tooltips_set_delay(table[i].tooltip,100);
  gtk_tooltips_set_tip(table[i].tooltip,table[i].button,buff,NULL);
/* GTK 2 */
/*
  gtk_tooltips_set_colors(table[i].tooltip,&tooltip_color_bg,&tooltip_color_fg);
*/

/* attach the button to the table */
  gtk_table_attach_defaults(GTK_TABLE(periodic_table), table[i].button,
               table[i].x - 1, table[i].x, table[i].y - 1, table[i].y);

/* connect the destroy method to it */
  g_signal_connect(GTK_OBJECT(table[i].button), "clicked",
                   GTK_SIGNAL_FUNC(display_element_dialog), (gpointer) i);
  }

gtk_table_set_row_spacings(GTK_TABLE(periodic_table), PANEL_SPACING);
gtk_table_set_col_spacings(GTK_TABLE(periodic_table), PANEL_SPACING);

/* terminating buttons */
hbox = gtk_hbox_new(FALSE, PANEL_SPACING);
gtk_box_pack_start(GTK_BOX(GTK_DIALOG(gperiodic->win)->action_area),
                   hbox, TRUE, TRUE, 0);

gtksh_stock_button(GTK_STOCK_REFRESH, refresh_model_from_table, NULL, hbox);

gtksh_stock_button(GTK_STOCK_CLOSE, event_close_dialog, GINT_TO_POINTER(id),
                   hbox);

gtk_widget_show_all(gperiodic->win);

free(buff);
}
