
/* task modes */
enum {QUEUED, RUNNING, SUSPENDED};

/************/
/* task pak */
/************/
struct task_pak
{
/* control */
gint pid;
gint ppid;
gint status;
gint parent;
gint child;
gint sister;
gint h_sec;
gint sec;
gint min;
gint hour;
gchar *label;
gchar *message;
time_t start_time;

gchar *time;
gdouble pcpu;
gdouble pmem;
/* NEW */
gdouble progress;
gpointer locked_model;

/* main task and arguments (run by the child) */
void (*primary)(gpointer, ...);
gpointer *ptr1;
/* cleanup task and arguments (run by the parent) */
void (*cleanup) (gpointer, ...);
gpointer *ptr2;
};

/* task control */
gint init_task_thread(void);
gint update_tasks(void);
gint update_task_info(void);

void submit_task(gchar *, gpointer, gpointer, gpointer, gpointer, gpointer);

void task_dialog(void);

gint task_sync(const gchar *);

gint exec_gulp(gchar *, gchar *);

/* work functions */
void exec_gulp_task(gpointer *);
void proc_gulp_task(gpointer *);
void exec_pov_task(gpointer *);
void exec_img_task(gpointer *);




