/*
Copyright (C) 2003 by Sean David Fleming

sean@power.curtin.edu.au

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

The GNU GPL can also be found at http://www.gnu.org
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <GL/gl.h>

#include "gdis.h"
#include "gtkshorts.h"
#include "dialog.h"
#include "interface.h"

/****************/
/* about dialog */
/****************/
void about(void)
{
gint doc;
gpointer dialog;
GtkWidget *window, *notebook, *hbox, *vbox, *frame, *label;
GString *buff, *title;

/* create a dialog */
dialog = dialog_request(ABOUT, "About", NULL, NULL, NULL);
if (!dialog)
  return;
window = dialog_window(dialog);
gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);

/* notebook display */
hbox = gtk_hbox_new(FALSE,0);
gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox), hbox, TRUE, TRUE, 10);
notebook = gtk_notebook_new();
gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_TOP);
gtk_container_add(GTK_CONTAINER(hbox), notebook);

/* data strings */
buff = g_string_new(NULL);
title = g_string_new(NULL);

/* fill out the pages in the notebook */
for (doc=0 ; doc<LAST ; doc++)
  {
  switch(doc)
    {
    case GDIS:
      g_string_assign(title,"GDIS");
      g_string_sprintf(buff,"GDIS version %4.2f.%d\n\n",VERSION,PATCH);
      g_string_append(buff,"The GTK Display Interface for Structures\n\n");
      g_string_append(buff,"(c) 2004 by Sean Fleming\n");
      g_string_append(buff,"sean@power.curtin.edu.au\n\n");
      g_string_append(buff,"http://gdis.sourceforge.net\n\n");
      g_string_append(buff,"Additional programming:\n\n");
      g_string_append(buff,"Andrew Rohl\n");
      g_string_append(buff,"andrew@power.curtin.edu.au\n\n");
      g_string_append(buff,"Current development of this project is supported by the\n");
      g_string_append(buff,"Western Australian Premier's Research Fellowship.\n"); 
      break;
    case SGINFO:
      g_string_assign(title,"SgInfo");
      g_string_sprintf(buff,"Space Group information lookup.\n\n");
      g_string_append(buff,"(c) 1994-96 by Ralf W. Grosse-Kunstleve.\n\n");
      g_string_append(buff,"rwgk@laplace.csb.yale.edu\n\n");
      break;
    case SYMMETRY:
      g_string_assign(title,"Symmetry");
      g_string_sprintf(buff,"Brute force symmetry analyzer\n\n");
      g_string_append(buff,"(c) 1996 Sergei Pachkovsky\n\n");
      g_string_append(buff,"patchkov@chem.ucalgary.ca\n\n");
      g_string_append(buff,"http://www.cobalt.chem.ucalgary.ca/ps/\n\n");
      break;
    case CDD:
      g_string_assign(title,"CDD");
      g_string_sprintf(buff,"CDD uses the double description method to compute\n");
      g_string_append(buff,"the vertices and extreme rays of a polyhedron.\n");
      g_string_append(buff,"It is utilized in calculating crystal habits.\n\n");
      g_string_append(buff,"(c) 1997 by Komei Fukuda\n\n");
      g_string_append(buff,"fukuda@ifor.math.ethz.ch\n\n");
      g_string_append(buff,"http://www.ifor.math.ethz.ch/~fukuda/cdd_home/cdd.html\n\n");
      break;
    case GPERIODIC:
      g_string_assign(title,"GPeriodic");
      g_string_sprintf(buff,"Shows the periodic table of elements.\n\n");
      g_string_append(buff,"(c) 1999 by Kyle R. Burton\n\n");
      g_string_append(buff,"mortis@voicenet.com\n\n");
      g_string_append(buff,"http://www.voicenet.com/~mortis\n");
      g_string_append(buff,"http://gperiodic.seul.org\n\n");
      g_string_append(buff,"Contributing authors:\n");
      g_string_append(buff,"a.w.peters@ieee.org,\n");
      g_string_append(buff,"khazuada@univ-littoral.fr,\n");
      g_string_append(buff,"mrivera@cable.net.co,\n");
      g_string_append(buff,"chris@koeln.ccc.de,\n");
      g_string_append(buff,"lalo@linuxcenter.com.br\n");
      g_string_append(buff,"koen_kooi@hotmail.com\n\n");
      break; 
    case OPENGL:
      g_string_assign(title,"OpenGL");
      g_string_sprintf(buff,"GL_RENDERER    %s\n", glGetString(GL_RENDERER));
      g_string_sprintfa(buff,"GL_VERSION       %s\n", glGetString(GL_VERSION));
      g_string_sprintfa(buff,"GL_VENDOR        %s\n", glGetString(GL_VENDOR));
      break;
    case POVRAY:
      g_string_assign(title,"POVRay");
      g_string_sprintf(buff,"The Persistence Of Vision Raytracer\n\n");
      g_string_append(buff,"http://www.povray.org\n\n");
      g_string_append(buff,"GDIS acts only as a GUI to POVRay.\n\n");
      g_string_append(buff,"A working version of POVRay must be installed\n");
      g_string_append(buff,"on your system in order to render molecules.\n");
      break;
    case GULP:
      g_string_assign(title,"GULP");
      g_string_sprintf(buff,"The General Utility Lattice Program\n\n");
      g_string_append(buff,"(c) Julian Gale\n\n");
      g_string_append(buff,"j.gale@curtin.edu.au\n\n");
      g_string_append(buff,"http://gulp.curtin.edu.au/\n\n");
      g_string_append(buff,"GDIS acts only as a GUI to GULP.\n\n");
      g_string_append(buff,"A working version of GULP must be installed on\n");
      g_string_append(buff,"your system in order to run energy calculations.\n");
      break; 
    case BABEL:
      g_string_assign(title,"Babel");
      g_string_sprintf(buff,"A coordinate file interconversion program\n\n");
      g_string_append(buff,"(c) 1992-1996 Pat Walters and Matt Stahl\n\n");
      g_string_append(buff,"babel@mercury.aichem.arizona.edu\n\n");
      g_string_append(buff,"http://smog.com/chem/babel/\n\n");
      g_string_append(buff,"GDIS acts only as a GUI to Babel.\n\n");
      g_string_append(buff,"A working version of Babel must be installed on\n");
      g_string_append(buff,"your system in order to load certain filetypes.\n");
      break;
/* empty page */
    default:
      continue;
    }
/* frame each page */
  frame = gtk_frame_new (title->str);
  gtk_container_set_border_width (GTK_CONTAINER (frame), 10);
/* put in a vbox to get a border around the text */
  vbox = gtk_vbox_new(TRUE,0);
  gtk_container_add (GTK_CONTAINER (frame), vbox);
  gtk_container_set_border_width (GTK_CONTAINER(GTK_BOX(vbox)), 10);
/* add the title & text */
  label = gtk_label_new (buff->str);
  gtk_container_add(GTK_CONTAINER(GTK_BOX(vbox)), label);
  label = gtk_label_new (title->str);
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, label);
  }

/* starting page - GDIS, of course */
gtk_notebook_set_page(GTK_NOTEBOOK(notebook), 0);

/* terminating button */
gtksh_stock_button(GTK_STOCK_CLOSE, dialog_destroy, dialog,
                   GTK_DIALOG(window)->action_area);


/* show the dialog */
gtk_widget_show_all(window);

/* done */
g_string_free(buff, TRUE);
g_string_free(title, TRUE);
}

