
/* task modes */
enum {RUNNING, QUEUED, COMPLETED, KILLED};

/************/
/* task pak */
/************/
struct task_pak
{
/* control */
gint pid;
gint ppid;
gint status;
gint parent;
gint child;
gint sister;
gint h_sec;
gint sec;
gint min;
gint hour;
gchar *label;
gchar *message;

#ifdef __WIN32
gpointer start_time;
#else
time_t start_time;
#endif

gchar *time;
gdouble pcpu;
gdouble pmem;
/* NEW */
gdouble progress;
gpointer locked_model;

/* main task and arguments (run by the child) */
void (*primary)(gpointer, ...);
gpointer *ptr1;
/* cleanup task and arguments (run by the parent) */
void (*cleanup) (gpointer, ...);
gpointer *ptr2;
};

/* task control */
gint init_task_thread(void);
gint update_tasks(void);
gint update_task_info(void);

void submit_task(const gchar *, gpointer, gpointer, gpointer, gpointer, gpointer);

void task_dialog(void);

gint task_sync(const gchar *);

gint exec_gulp(const gchar *, const gchar *);

/* work functions */
void exec_gulp_task(gpointer *);
void proc_gulp_task(gpointer *);
void exec_pov_task(gpointer *);
void exec_img_task(gpointer *);

void task_queue_init(void);
void task_queue_free(void);
void task_new(const gchar *,
              gpointer, gpointer,
              gpointer, gpointer,
              gpointer );

