/* This file is a test for the XSLT engine working on Gdome documents.
 *
 * Copyright (C) 2002 Claudio Sacerdoti Coen <sacerdot@cs.unibo.it>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please send an email to <sacerdot@cs.unibo.it>
 */

#include <stdio.h>
#include <gdome.h>
#include <libxslt/xsltconfig.h>
#include <libxslt/xslt.h>
#include <libxslt/imports.h>

#include "gdome_xslt.h"

#define	OUTPUT_FILE		"../../test_files/output.xml"
#define CORRECT_OUTPUT_FILE	"../../test_files/output.xml.correct"

GdomeDocument* loadDocument(GdomeDOMImplementation *domimpl, char *uri)
{
   GdomeDocument *doc;
   GdomeException exc;

   doc = gdome_di_createDocFromURI(domimpl, uri, GDOME_LOAD_PARSING, &exc);
   if (doc == NULL) {
      fprintf (stderr,
               "DOMImplementation.createDocFromURI: failed\n\tException #%d\n",
               exc);
   }

   return doc;
}

/*	// old version: use gdome serialization
int saveDocument(GdomeDOMImplementation *domimpl, GdomeDocument* doc, char *uri)
{
   GdomeException exc;

   if (!gdome_di_saveDocToFile (domimpl, doc, uri, GDOME_SAVE_STANDARD, &exc)) {
      fprintf (stderr,
               "DOMImplementation.saveDocToFile: failed\n\tException #%d\n",
               exc);
      return 0;
   }

   return 1;
}
*/

	/* new version, use libxslt serialization */
int saveDocument(char* fname, GdomeDocument* result, xsltStylesheetPtr style) {
	return saveResultToFilename(fname, result, style, 0);
}

int main(void)
{
   int bytes;
   GdomeDOMImplementation *domimpl;
   GdomeDocument *input;
   GdomeDocument *style;
   xsltStylesheetPtr style_libxslt;
   GdomeDocument *output;
   GdomeException exc;
   const char* params[] = {"parameter1", "'value1'",
                           "parameter2", "'value2'",
                           "parameter3", "'value3'",
	                   NULL};

   domimpl = gdome_di_mkref();

   if (!(input = loadDocument(domimpl, "../../test_files/input.xml"))) return 1;
   if (!(style = loadDocument(domimpl, "../../test_files/stylesheet.xsl"))) return 1;

   style_libxslt = processStylesheet(style);

   output = applyStylesheet(input, style_libxslt, params);

/*    if (!(saveDocument(domimpl, output, "../../test_files/output.xml"))) return 1; */
   bytes = saveDocument("../../test_files/output.xml", output, style_libxslt);

   xsltFreeStylesheet(style_libxslt);
   gdome_di_freeDoc (domimpl, input, &exc);
   gdome_di_freeDoc (domimpl, style, &exc);
   gdome_di_freeDoc (domimpl, output, &exc);
   gdome_di_unref (domimpl, &exc);

   printf("The test was successful iff %s is equal to %s\n",
          OUTPUT_FILE,
          CORRECT_OUTPUT_FILE);

   return 0;
}
