Program ace;
	{ GearHead ACE - Adventure Construction Experiment }
	{ This is my first implementation of the extra-extra-random plot generator. }
	{ As a trial program, it will generate adventure files that can then be }
	{ loaded by GearHead Arena. }

	{ The idea behind this project is to create plots which are themselves }
	{ randomly assembled from components. My hope for this program is that }
	{ it will be able to create fun little mini-adventures, which should be }
	{ completable in a night or so. }

	{ MEGALIST CONCEPT }
	{  The megalist is a long series of events created by the random plot generator. }
	{  As each fragment is added to the list, its scripts displace the scripts that }
	{  are already present, creating a stack of script lines. Separate lists exist for }
	{  the main plot and the individual personas. }
	{ }
	{  As it is created each fragment is assigned a unique ID number. This number is }
	{  needed to access the variables, messages, and scripts associated with the fragment. }
	{  In addition, the root gear contains a "situation" counter: this corresponds to the }
	{  number of the active fragment. }
	{ }
	{  As the PC moves through the plot, the situation number will always increase. }
	{  Note that it is not true that if the situation number is greater, then a lesser }
	{  situation has been passed through. }

	{ FRAGMENT REQUEST }
	{  When a new fragment is required, the following information is provided: }
	{   PALETTE: List of "roles" currently assigned. The role of a single NPC may }
	{            change from one fragment to another. }
	{            The roles are: Mission-Giver, Target, Enemy }
	{   DESC: A string containing the requirements for the next fragment. These }
	{         requirements include the background descriptors, tasks the PC has }
	{         been assigned, and whatever else might be needed. }

	{ TOKENS: }

	{  %ID%		: The ID of the current situation. }
	{  %NEXT[n]%	: The ID of the [n]th generated situation. }
	{  %POP%	: The label that was pushed to add the current label to the megalist. }

{
	GearHead: Arena, a roguelike mecha CRPG
	Copyright (C) 2005 Joseph Hewitt

	This library is free software; you can redistribute it and/or modify it
	under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation; either version 2.1 of the License, or (at
	your option) any later version.

	The full text of the LGPL can be found in license.txt.

	This library is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
	General Public License for more details. 

	You should have received a copy of the GNU Lesser General Public License
	along with this library; if not, write to the Free Software Foundation,
	Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
}


uses gears,ghparser,texutil;

const
	Num_Palette_Entries = 3;

	PE_MissionGiver = 1;
	PE_Target = 2;
	PE_Enemy = 3;

	NAG_ACEPalette = 0;

	NAG_FragmentDesc = 1;
		NAS_FragUID = 0;

	NAG_BranchNumber = 2;

type
	Palette = Array [1..Num_Palette_Entries] of LongInt;

var
	FragList: GearPtr;
	High_Fragment_ID: LongInt;
	NPC_List: Array [1..8] of LongInt;


Function CreateFragmentList( CType: String ): GearPtr;
	{ Locate all the components that match CType, and return copies of them. }
var
	CList,C: GearPtr;
	FD: String;
begin
	CList := Nil;
	C := FragList;
	CType := UpCase( CType );
	while C <> Nil do begin
		FD := SAttValue( C^.SA , 'DESC' );
		if PartMatchesCriteria( CType , FD ) then begin
			AppendGear( CList , CloneGear( C ) );
		end;
		C := C^.Next;
	end;
	CreateFragmentList := CList;
end;

Function GetNewCharacter: Integer;
	{ A new character is needed for this plot. Attempt to locate a free cell in }
	{ the global NPC List, and return the slot number. }
	{ If this function returns 0, no free slot could be found. }
var
	T,Slot: Integer;
begin
	Slot := 0;
	for t := 8 downto 1 do if NPC_List[t] = 0 then Slot := T;
	if Slot <> 0 then NPC_List[ Slot ] := Slot;
	GetNewCharacter := Slot;
end;

Function AllocateElements( CPal: Palette; CFrag: GearPtr ): Boolean;
	{ Attempt to allocate all the required elements for this fragment. }
	{ If allocation is OK, return TRUE. Otherwise return FALSE. }
var
	T: Integer;
	EReq,Cmd: String;	{ Element Request, Command }
	AllOK: Boolean;
	NewPal: Palette;
	Character_Index: Integer;
begin
	{ Clear the new palette. }
	for t := 1 to Num_Palette_Entries do NewPal[t] := 0;

	{ Check to make sure all characters may be allocated okay. }
	AllOK := True;
	for t := 1 to Num_Palette_Entries do begin
		EReq := UpCase( SAttValue( CFrag^.SA , 'CHARA' + BStr( T ) ) );
		if EReq <> '' then begin
			{ Command One: Origin of this character. }
			cmd := ExtractWord( EReq );
			case Cmd[1] of
				'N':	{ New Character }
					Character_Index := GetNewCharacter;
				'M':	{ Mission-Giver from palette }
					Character_Index := CPal[ PE_MissionGiver ];
				'E':	{ Enemy from palette }
					Character_Index := CPal[ PE_Enemy ];
				'T':	{ Target from palette }
					Character_Index := CPal[ PE_Target ];
			else Character_Index := 0;
			end;

			{ If the requested slot wasn't found, this fragment can't be loaded. }
			if Character_Index = 0 then begin
				AllOK := False;
				Break;
			end;

			CFrag^.Stat[ T ] := Character_Index;

			{ Command Two: The purpose of this character }
			cmd := ExtractWord( EReq );
			case Cmd[1] of
				'M':	{ Mission-Giver }
					NewPal[ PE_MissionGiver ] := Character_Index;
				'E':	{ Enemy }
					NewPal[ PE_Enemy ] := Character_Index;
				'T':	{ Target }
					NewPal[PE_Target] := Character_Index;
			else AllOK := False;
			end;

		end;
	end;

	{ If everything is okay, store the fragment's palette. }
	if AllOK then begin
		for t := 1 to Num_Palette_Entries do SetNAtt( CFrag^.NA , NAG_ACEPalette , T , NewPal[t] );
	end;

	AllocateElements := AllOK;
end;

Function FragPalette( CFrag: GearPtr ): Palette;
	{ Return the palette for this fragment. }
var
	NewPal: Palette;
	T: Integer;
begin
	for t := 1 to Num_Palette_Entries do NewPal[t] := NAttValue( CFrag^.NA , NAG_ACEPalette , T );
	FragPalette := NewPal;
end;

Function BranchType( CFrag: GearPtr; N: Integer ): String;
	{ Return the description of branch N. If no such branch exists, return an }
	{ empty string. }
begin
	BranchType := SAttValue( CFrag^.SA , 'BRANCH' + BStr( N ) );
end;

Function AddComponent( CType: String; CPal: Palette; CPar: GearPtr; var CStack: GearPtr ): GearPtr;
	{ Try to add a component to CStack. }
var
	CList,C,B: GearPtr;
	C2Type: String;
	AllOK: Boolean;
	T: Integer;
begin
	{ Create the list of potential components. }
	CList := CreateFragmentList( CType );
	if CList = Nil then Exit( Nil );

	{ Repeat... select one component randomly. Remove it from the list. }
	{ Attempt to add it. If addition fails, try another component. Keep going }
	{ until either a component has been added or we've run out of possibilities. }
	repeat
		C := SelectRandomGear( CList );
		DelinkGear( CList , C );

		SetNAtt( C^.NA , NAG_FragmentDesc , NAS_FragUID , High_Fragment_ID );

		{ Attach it to the end of the stack. }
		C^.Parent := CPar;
		AppendGear( CStack , C );

		AllOk := AllocateElements( CPal, C );

		{ See if this component requires any branches. }
		for t := 1 to 8 do begin
			C2type := BranchType( C , T );
			if C2Type <> '' then begin
				B := AddComponent( C2Type , FragPalette( C ) , C , C^.SubCom );
				if B <> Nil then SetNAtt( C^.NA , NAG_BranchNumber , T , NAttValue( B^.NA , NAG_FragmentDesc , NAS_FragUID ) );
				AllOK := ( B <> Nil ) and ALlOK;
			end;
		end;

		{ If not everything could be loaded okay, delete C. }
		if not AllOK then begin
			RemoveGear( CStack , C );
		end;
	until ( CList = Nil ) or AllOK;

	Inc( High_Fragment_ID );

	AddComponent := C;
end;

Procedure MergeScripts( Src,Dest: GearPtr );
	{ Take SRC and copy its scripts to DEST, replacing tokens as appropriate. }
var
	SrcStr: SAttPtr;	{ Source String }
begin
	SrcStr := Src^.SA;
	while SrcStr <> Nil do begin

		SrcStr := SrcStr^.Next;
	end;
end;

Procedure CopyOverComponent( CPlot, CTree: GearPtr );
	{ Copy CTREE and all it's persona subcoms to CPLOT. Then, recursively }
	{ add its invcomponents. }
begin

end;

Function AssembleMegalist( CTree: GearPtr ): GearPtr;
	{ Take the megalist as created above, and assemble it into a single PLOT }
	{ structure. The eight elements of the plot will be the characters in the }
	{ palette. All other things that would normally be elements must be }
	{ hardcoded into the script lines or stored as variables. }
var
	CPlot: GearPtr;
	T: Integer;
begin
	{ CPlot is the main plot. It holds personas for all defined characters. }
	CPlot := LoadFile( 'baseplot.txt' , 'ACE/' );
	if CPlot = Nil then Exit;

	{ Copy over the NPC identities. }
	for t := 1 to NumGearStats do CPlot^.Stat[t] := NPC_List[t];

	{ Process the CTree. }
	CopyOverComponent( CPlot, CTree );

	{ Return the finished product. }
	AssembleMegalist := CPlot;
end;

var
	C,P: GearPtr;
	Pal1: Palette;
	T: Integer;

begin
	FragList := LoadFile( 'test.txt' , 'ACE/' );

	for t := 1 to Num_Palette_Entries do Pal1[t] := 0;

	{ Create the fragment list. }
	AddComponent( '+I##' , Pal1 , Nil , C );

	{ Assemble the fragments into a coherent plot. }
	P := AssembleMegaList( C );



	DisposeGear( FragList );
end.
