/* a_pan.c */
void a_pan_general(TOPLEVEL *w_current, double world_cx, double world_cy, double relativ_zoom_factor, int flags);
void a_pan_calc(TOPLEVEL *w_current, int x, int y);
void a_pan(TOPLEVEL *w_current, int x, int y);
void a_pan_mouse(TOPLEVEL *w_current, int diff_x, int diff_y);
/* a_zoom.c */
void a_zoom(TOPLEVEL *w_current, int dir, int selected_from, int pan_flags);
void a_zoom_extents(TOPLEVEL *w_current, OBJECT *o_current, int pan_flags);
void a_zoom_box(TOPLEVEL *w_current, int pan_flags);
void a_zoom_box_start(TOPLEVEL *w_current, int x, int y);
void a_zoom_box_end(TOPLEVEL *w_current, int x, int y);
void a_zoom_box_rubberband(TOPLEVEL *w_current, int x, int y);
void correct_aspect(TOPLEVEL *w_current);
/* g_funcs.c */
SCM g_funcs_print(SCM filename);
SCM g_funcs_image(SCM filename);
SCM g_funcs_exit(void);
SCM g_funcs_use_rc_values(void);
SCM g_funcs_key_name(SCM keystring);
SCM g_funcs_key_value(SCM keystring);
SCM g_funcs_key_done(void);
SCM get_selected_component_attributes(gpointer data, guint callback_action, GtkWidget *widget);
SCM get_selected_filename(gpointer data, guint callback_action, GtkWidget *widget);
/* g_hook.c */
SCM g_make_attrib_smob_list(TOPLEVEL *curr_w, OBJECT *curr_object);
SCM g_set_attrib_value_x(SCM attrib_smob, SCM scm_value);
/* g_key.c */
void set_window_current_key(TOPLEVEL *w_current);
void g_key_execute(int state, int keyval);
SCM g_key_file_new(void);
SCM g_key_file_new_window(void);
SCM g_key_file_open(void);
SCM g_key_file_script(void);
SCM g_key_file_save(void);
SCM g_key_file_save_as(void);
SCM g_key_file_save_all(void);
SCM g_key_file_print(void);
SCM g_key_file_write_png(void);
SCM g_key_file_close(void);
SCM g_key_file_quit(void);
SCM g_key_edit_undo(void);
SCM g_key_edit_redo(void);
SCM g_key_edit_select(void);
SCM g_key_edit_copy(void);
SCM g_key_edit_copy_hotkey(void);
SCM g_key_edit_move(void);
SCM g_key_edit_move_hotkey(void);
SCM g_key_edit_delete(void);
SCM g_key_edit_rotate_90(void);
SCM g_key_edit_rotate_90_hotkey(void);
SCM g_key_edit_mirror(void);
SCM g_key_edit_mirror_hotkey(void);
SCM g_key_edit_slot(void);
SCM g_key_edit_color(void);
SCM g_key_edit_edit(void);
SCM g_key_edit_text(void);
SCM g_key_edit_lock(void);
SCM g_key_edit_unlock(void);
SCM g_key_edit_linetype(void);
SCM g_key_edit_filltype(void);
SCM g_key_edit_translate(void);
SCM g_key_edit_embed(void);
SCM g_key_edit_unembed(void);
SCM g_key_edit_update(void);
SCM g_key_edit_show_hidden(void);
SCM g_key_edit_make_visible(void);
SCM g_key_edit_find(void);
SCM g_key_edit_show_text(void);
SCM g_key_edit_hide_text(void);
SCM g_key_edit_autonumber_text(void);
SCM g_key_buffer_copy1(void);
SCM g_key_buffer_copy2(void);
SCM g_key_buffer_copy3(void);
SCM g_key_buffer_copy4(void);
SCM g_key_buffer_copy5(void);
SCM g_key_buffer_cut1(void);
SCM g_key_buffer_cut2(void);
SCM g_key_buffer_cut3(void);
SCM g_key_buffer_cut4(void);
SCM g_key_buffer_cut5(void);
SCM g_key_buffer_paste1(void);
SCM g_key_buffer_paste2(void);
SCM g_key_buffer_paste3(void);
SCM g_key_buffer_paste4(void);
SCM g_key_buffer_paste5(void);
SCM g_key_buffer_paste1_hotkey(void);
SCM g_key_buffer_paste2_hotkey(void);
SCM g_key_buffer_paste3_hotkey(void);
SCM g_key_buffer_paste4_hotkey(void);
SCM g_key_buffer_paste5_hotkey(void);
SCM g_key_view_redraw(void);
SCM g_key_view_zoom_full(void);
SCM g_key_view_zoom_extents(void);
SCM g_key_view_zoom_in(void);
SCM g_key_view_zoom_out(void);
SCM g_key_view_zoom_in_hotkey(void);
SCM g_key_view_zoom_out_hotkey(void);
SCM g_key_view_zoom_box(void);
SCM g_key_view_zoom_box_hotkey(void);
SCM g_key_view_pan(void);
SCM g_key_view_pan_hotkey(void);
SCM g_key_view_update_cues(void);
SCM g_key_page_manager(void);
SCM g_key_page_next(void);
SCM g_key_page_prev(void);
SCM g_key_page_new(void);
SCM g_key_page_close(void);
SCM g_key_page_revert(void);
SCM g_key_page_discard(void);
SCM g_key_page_print(void);
SCM g_key_add_component(void);
SCM g_key_add_attribute(void);
SCM g_key_add_attribute_hotkey(void);
SCM g_key_add_net(void);
SCM g_key_add_net_hotkey(void);
SCM g_key_add_bus(void);
SCM g_key_add_bus_hotkey(void);
SCM g_key_add_text(void);
SCM g_key_add_line(void);
SCM g_key_add_line_hotkey(void);
SCM g_key_add_box(void);
SCM g_key_add_box_hotkey(void);
SCM g_key_add_circle(void);
SCM g_key_add_circle_hotkey(void);
SCM g_key_add_arc(void);
SCM g_key_add_arc_hotkey(void);
SCM g_key_add_pin(void);
SCM g_key_add_pin_hotkey(void);
SCM g_key_hierarchy_down_schematic(void);
SCM g_key_hierarchy_down_symbol(void);
SCM g_key_hierarchy_up(void);
SCM g_key_hierarchy_documentation(void);
SCM g_key_attributes_attach(void);
SCM g_key_attributes_detach(void);
SCM g_key_attributes_show_name(void);
SCM g_key_attributes_show_value(void);
SCM g_key_attributes_show_both(void);
SCM g_key_attributes_visibility_toggle(void);
SCM g_key_script_console(void);
SCM g_key_options_text_size(void);
SCM g_key_options_afeedback(void);
SCM g_key_options_grid(void);
SCM g_key_options_snap(void);
SCM g_key_options_snap_size(void);
SCM g_key_options_rubberband(void);
SCM g_key_options_show_log_window(void);
SCM g_key_options_show_coord_window(void);
SCM g_key_misc(void);
SCM g_key_misc2(void);
SCM g_key_misc3(void);
SCM g_key_help_about(void);
SCM g_key_help_manual(void);
SCM g_key_help_hotkeys(void);
SCM g_key_cancel(void);
SCM g_get_selected_filename(void);
SCM g_get_selected_component_attributes(void);
/* g_rc.c */
char *g_rc_parse_path(void);
void g_rc_parse(void);
SCM g_rc_gschem_version(SCM version);
SCM g_rc_override_net_color(SCM index, SCM color, SCM outline_color, SCM ps_color, SCM ir, SCM ig, SCM ib);
SCM g_rc_override_bus_color(SCM index, SCM color, SCM outline_color, SCM ps_color, SCM ir, SCM ig, SCM ib);
SCM g_rc_override_pin_color(SCM index, SCM color, SCM outline_color, SCM ps_color, SCM ir, SCM ig, SCM ib);
SCM g_rc_attribute_color(SCM index, SCM color, SCM outline_color, SCM ps_color, SCM ir, SCM ig, SCM ib);
SCM g_rc_detachedattr_color(SCM index, SCM color, SCM outline_color, SCM ps_color, SCM ir, SCM ig, SCM ib);
SCM g_rc_text_color(SCM index, SCM color, SCM outline_color, SCM ps_color, SCM ir, SCM ig, SCM ib);
SCM g_rc_net_color(SCM index, SCM color, SCM outline_color, SCM ps_color, SCM ir, SCM ig, SCM ib);
SCM g_rc_bus_color(SCM index, SCM color, SCM outline_color, SCM ps_color, SCM ir, SCM ig, SCM ib);
SCM g_rc_pin_color(SCM index, SCM color, SCM outline_color, SCM ps_color, SCM ir, SCM ig, SCM ib);
SCM g_rc_graphic_color(SCM index, SCM color, SCM outline_color, SCM ps_color, SCM ir, SCM ig, SCM ib);
SCM g_rc_grid_color(SCM index, SCM color, SCM outline_color, SCM ps_color, SCM ir, SCM ig, SCM ib);
SCM g_rc_background_color(SCM index, SCM color, SCM outline_color, SCM ps_color, SCM ir, SCM ig, SCM ib);
SCM g_rc_select_color(SCM index, SCM color, SCM outline_color, SCM ps_color, SCM ir, SCM ig, SCM ib);
SCM g_rc_boundingbox_color(SCM index, SCM color, SCM outline_color, SCM ps_color, SCM ir, SCM ig, SCM ib);
SCM g_rc_zoom_box_color(SCM index, SCM color, SCM outline_color, SCM ps_color, SCM ir, SCM ig, SCM ib);
SCM g_rc_net_endpoint_color(SCM index, SCM color, SCM outline_color, SCM ps_color, SCM ir, SCM ig, SCM ib);
SCM g_rc_logic_bubble_color(SCM index, SCM color, SCM outline_color, SCM ps_color, SCM ir, SCM ig, SCM ib);
SCM g_rc_lock_color(SCM index, SCM color, SCM outline_color, SCM ps_color, SCM ir, SCM ig, SCM ib);
SCM g_rc_output_color_background(SCM index, SCM color, SCM outline_color, SCM ps_color, SCM ir, SCM ig, SCM ib);
SCM g_rc_stroke_color(SCM index, SCM color, SCM outline_color, SCM ps_color, SCM ir, SCM ig, SCM ib);
SCM g_rc_freestyle_color(SCM index, SCM color, SCM outline_color, SCM ps_color, SCM ir, SCM ig, SCM ib);
SCM g_rc_net_endpoint_mode(SCM mode);
SCM g_rc_net_midpoint_mode(SCM mode);
SCM g_rc_net_style(SCM mode);
SCM g_rc_bus_style(SCM mode);
SCM g_rc_pin_style(SCM mode);
SCM g_rc_action_feedback_mode(SCM mode);
SCM g_rc_zoom_with_pan(SCM mode);
SCM g_rc_text_feedback(SCM mode);
SCM g_rc_text_display_zoomfactor(SCM zoomfactor);
SCM g_rc_scrollbar_update(SCM mode);
SCM g_rc_object_clipping(SCM mode);
SCM g_rc_logging(SCM mode);
SCM g_rc_embed_components(SCM mode);
SCM g_rc_text_size(SCM size);
SCM g_rc_text_caps_style(SCM mode);
SCM g_rc_snap_size(SCM size);
SCM g_rc_logging_destination(SCM mode);
SCM g_rc_default_series_name(SCM name);
SCM g_rc_untitled_name(SCM name);
SCM g_rc_component_library(SCM path);
SCM g_rc_component_library_search(SCM path);
SCM g_rc_source_library(SCM path);
SCM g_rc_source_library_search(SCM path);
SCM g_rc_attribute_name(SCM path);
SCM g_rc_scheme_directory(SCM path);
SCM g_rc_bitmap_directory(SCM path);
SCM g_rc_font_directory(SCM path);
SCM g_rc_world_size(SCM width, SCM height, SCM border);
SCM g_rc_scrollbars(SCM mode);
SCM g_rc_paper_size(SCM width, SCM height);
SCM g_rc_paper_sizes(SCM papername, SCM scm_width, SCM scm_height);
SCM g_rc_output_text(SCM mode);
SCM g_rc_output_type(SCM mode);
SCM g_rc_output_orientation(SCM mode);
SCM g_rc_image_color(SCM mode);
SCM g_rc_image_size(SCM width, SCM height);
SCM g_rc_output_color(SCM mode);
SCM g_rc_output_capstyle(SCM mode);
SCM g_rc_log_window(SCM mode);
SCM g_rc_log_window_type(SCM mode);
SCM g_rc_third_button(SCM mode);
SCM g_rc_middle_button(SCM mode);
SCM g_rc_net_consolidate(SCM mode);
SCM g_rc_file_preview(SCM mode);
SCM g_rc_enforce_hierarchy(SCM mode);
SCM g_rc_text_origin_marker(SCM mode);
SCM g_rc_fast_mousepan(SCM mode);
SCM g_rc_raise_dialog_boxes_on_expose(SCM mode);
SCM g_rc_attribute_promotion(SCM mode);
SCM g_rc_promote_invisible(SCM mode);
SCM g_rc_keep_invisible(SCM mode);
SCM g_rc_continue_component_place(SCM mode);
SCM g_rc_undo_levels(SCM levels);
SCM g_rc_undo_control(SCM mode);
SCM g_rc_undo_type(SCM mode);
SCM g_rc_draw_grips(SCM mode);
SCM g_rc_netconn_rubberband(SCM mode);
SCM g_rc_sort_component_library(SCM mode);
SCM g_rc_add_menu(SCM menu_name, SCM menu_items);
SCM g_rc_window_size(SCM width, SCM height);
SCM g_rc_warp_cursor(SCM mode);
SCM g_rc_toolbars(SCM mode);
SCM g_rc_handleboxes(SCM mode);
SCM g_rc_setpagedevice_orientation(SCM mode);
SCM g_rc_setpagedevice_pagesize(SCM mode);
SCM g_rc_bus_ripper_size(SCM size);
SCM g_rc_bus_ripper_type(SCM mode);
SCM g_rc_bus_ripper_symname(SCM scmsymname);
SCM g_rc_bus_ripper_rotation(SCM mode);
SCM g_rc_force_boundingbox(SCM mode);
SCM g_rc_reset_component_library(void);
SCM g_rc_reset_source_library(void);
/* g_register.c */
void g_register_funcs(void);
/* globals.c */
/* gschem.c */
void gschem_quit(void);
void main_prog(int argc, char *argv[]);
int main(int argc, char *argv[]);
/* i_basic.c */
void i_allow_expose(void);
void i_show_state(TOPLEVEL *w_current, const char *message);
void i_set_state(TOPLEVEL *w_current, enum x_states newstate);
void i_set_state_msg(TOPLEVEL *w_current, enum x_states newstate, const char *message);
void i_update_left_button(const char *string);
void i_update_middle_button(TOPLEVEL *w_current, void *func_ptr, const char *string);
void i_update_right_button(const char *string);
void i_update_toolbar(TOPLEVEL *w_current);
void i_update_menus(TOPLEVEL *w_current);
void i_update_cursor(TOPLEVEL *w_current);
void i_set_filename(TOPLEVEL *w_current, const char *string);
/* i_callbacks.c */
void i_callback_file_new(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_toolbar_file_new(GtkWidget *widget, gpointer data);
void i_callback_file_new_window(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_file_open(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_toolbar_file_open(GtkWidget *widget, gpointer data);
void i_callback_file_script(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_file_save(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_toolbar_file_save(GtkWidget *widget, gpointer data);
void i_callback_file_save_all(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_file_save_as(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_file_print(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_file_write_png(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_file_close(gpointer data, guint callback_action, GtkWidget *widget);
int i_callback_close(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_file_quit(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_edit_undo(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_toolbar_edit_undo(GtkWidget *widget, gpointer data);
void i_callback_edit_redo(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_toolbar_edit_redo(GtkWidget *widget, gpointer data);
void i_callback_edit_select(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_toolbar_edit_select(GtkWidget *widget, gpointer data);
void i_callback_edit_copy(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_edit_copy_hotkey(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_edit_move(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_edit_move_hotkey(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_edit_delete(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_edit_edit(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_edit_text(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_edit_slot(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_edit_color(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_edit_rotate_90(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_edit_rotate_90_hotkey(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_edit_mirror(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_edit_mirror_hotkey(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_edit_lock(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_edit_unlock(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_edit_translate(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_edit_embed(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_edit_unembed(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_edit_update(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_edit_show_hidden(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_edit_make_visible(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_edit_find(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_edit_hide_text(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_edit_show_text(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_edit_autonumber_text(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_edit_linetype(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_edit_filltype(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_view_redraw(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_view_zoom_full(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_view_zoom_extents(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_view_zoom_box(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_view_zoom_box_hotkey(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_view_zoom_in(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_view_zoom_out(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_view_zoom_in_hotkey(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_view_zoom_out_hotkey(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_view_pan(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_view_pan_hotkey(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_view_update_cues(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_page_manager(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_page_next(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_page_prev(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_page_new(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_page_close(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_page_revert(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_page_discard(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_page_print(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_buffer_copy1(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_buffer_copy2(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_buffer_copy3(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_buffer_copy4(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_buffer_copy5(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_buffer_cut1(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_buffer_cut2(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_buffer_cut3(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_buffer_cut4(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_buffer_cut5(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_buffer_paste1(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_buffer_paste2(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_buffer_paste3(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_buffer_paste4(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_buffer_paste5(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_buffer_paste1_hotkey(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_buffer_paste2_hotkey(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_buffer_paste3_hotkey(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_buffer_paste4_hotkey(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_buffer_paste5_hotkey(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_add_component(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_toolbar_add_component(GtkWidget *widget, gpointer data);
void i_callback_add_attribute(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_add_attribute_hotkey(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_add_net(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_add_net_hotkey(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_toolbar_add_net(GtkWidget *widget, gpointer data);
void i_callback_add_bus(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_add_bus_hotkey(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_toolbar_add_bus(GtkWidget *widget, gpointer data);
void i_callback_add_text(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_toolbar_add_text(GtkWidget *widget, gpointer data);
void i_callback_add_line(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_add_line_hotkey(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_add_box(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_add_box_hotkey(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_add_circle(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_add_circle_hotkey(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_add_arc(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_add_arc_hotkey(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_add_pin(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_add_pin_hotkey(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_hierarchy_down_schematic(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_hierarchy_down_symbol(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_hierarchy_up(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_hierarchy_documentation(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_attributes_attach(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_attributes_detach(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_attributes_show_name(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_attributes_show_value(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_attributes_show_both(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_attributes_visibility_toggle(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_script_console(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_options_text_size(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_options_snap_size(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_options_afeedback(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_options_grid(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_options_snap(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_options_rubberband(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_options_show_log_window(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_misc(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_misc2(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_misc3(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_cancel(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_help_about(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_help_manual(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_help_hotkeys(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_options_show_coord_window(gpointer data, guint callback_action, GtkWidget *widget);
void i_callback_close_wm(GtkWidget *widget, GdkEvent *event, gpointer data);
/* i_vars.c */
void i_vars_set(TOPLEVEL *w_current);
void i_vars_setnames(TOPLEVEL *w_current);
/* o_arc.c */
void o_arc_draw(TOPLEVEL *w_current, OBJECT *o_current);
void o_arc_draw_solid(GdkWindow *w, GdkGC *gc, GdkColor *color, GdkCapStyle cap, gint x, gint y, gint radius, gint angle1, gint angle2, gint arc_width, gint length, gint space);
void o_arc_draw_dotted(GdkWindow *w, GdkGC *gc, GdkColor *color, GdkCapStyle cap, gint x, gint y, gint radius, gint angle1, gint angle2, gint arc_width, gint length, gint space);
void o_arc_draw_dashed(GdkWindow *w, GdkGC *gc, GdkColor *color, GdkCapStyle cap, gint x, gint y, gint radius, gint angle1, gint angle2, gint arc_width, gint length, gint space);
void o_arc_draw_center(GdkWindow *w, GdkGC *gc, GdkColor *color, GdkCapStyle cap, gint x, gint y, gint radius, gint angle1, gint angle2, gint arc_width, gint length, gint space);
void o_arc_draw_phantom(GdkWindow *w, GdkGC *gc, GdkColor *color, GdkCapStyle cap, gint x, gint y, gint radius, gint angle1, gint angle2, gint arc_width, gint length, gint space);
void o_arc_erase(TOPLEVEL *w_current, OBJECT *o_current);
void o_arc_eraserubber(TOPLEVEL *w_current);
void o_arc_draw_xor(TOPLEVEL *w_current, int dx, int dy, OBJECT *o_current);
void o_arc_start(TOPLEVEL *w_current, int x, int y);
void o_arc_end1(TOPLEVEL *w_current, int x, int y);
void o_arc_end2(TOPLEVEL *w_current, int x, int y);
void o_arc_end3(TOPLEVEL *w_current, int x, int y);
void o_arc_end4(TOPLEVEL *w_current, int start_angle, int end_angle);
void o_arc_rubberarc(TOPLEVEL *w_current, int x, int y, int whichone);
void o_arc_rubberarc_xor(TOPLEVEL *w_current);
void o_arc_draw_grips(TOPLEVEL *w_current, OBJECT *o_current);
void o_arc_erase_grips(TOPLEVEL *w_current, OBJECT *o_current);
/* o_attrib.c */
void o_attrib_add_selected(TOPLEVEL *w_current, SELECTION *selection_list, OBJECT *selected);
void o_attrib_toggle_visibility(TOPLEVEL *w_current, SELECTION *list);
void o_attrib_toggle_show_name_value(TOPLEVEL *w_current, SELECTION *list, int new_show_name_value);
void o_attrib_start(TOPLEVEL *w_current, int screen_x, int screen_y);
void o_attrib_end(TOPLEVEL *w_current);
void o_attrib_rubberattrib(TOPLEVEL *w_current);
OBJECT *o_attrib_add_attrib(TOPLEVEL *w_current, char *text_string, int visibility, int show_name_value, OBJECT *object);
/* o_basic.c */
void o_redraw_all(TOPLEVEL *w_current);
void o_redraw_all_fast(TOPLEVEL *w_current);
void o_redraw(TOPLEVEL *w_current, OBJECT *object_list);
void o_unselect_all(TOPLEVEL *w_current);
void o_draw_list(TOPLEVEL *w_current, GList *list);
void o_draw_selected(TOPLEVEL *w_current);
void o_erase_selected(TOPLEVEL *w_current);
void o_erase_single(TOPLEVEL *w_current, OBJECT *object);
void o_drawbounding(TOPLEVEL *w_current, OBJECT *o_list, SELECTION *s_list, GdkColor *color, int firsttime);
void o_erasebounding(TOPLEVEL *w_current, OBJECT *o_list, SELECTION *s_list);
int o_erase_rubber(TOPLEVEL *w_current);
/* o_box.c */
void o_box_draw(TOPLEVEL *w_current, OBJECT *o_current);
void o_box_draw_solid(GdkDrawable *w, GdkGC *gc, GdkColor *color, GdkCapStyle cap, gint filled, gint x, gint y, gint width, gint height, gint line_width, gint length, gint space);
void o_box_draw_dotted(GdkDrawable *w, GdkGC *gc, GdkColor *color, GdkCapStyle cap, gint filled, gint x, gint y, gint width, gint height, gint line_width, gint length, gint space);
void o_box_draw_dashed(GdkDrawable *w, GdkGC *gc, GdkColor *color, GdkCapStyle cap, gint filled, gint x, gint y, gint width, gint height, gint line_width, gint length, gint space);
void o_box_draw_center(GdkDrawable *w, GdkGC *gc, GdkColor *color, GdkCapStyle cap, gint filled, gint x, gint y, gint width, gint height, gint line_width, gint length, gint space);
void o_box_draw_phantom(GdkDrawable *w, GdkGC *gc, GdkColor *color, GdkCapStyle cap, gint filled, gint x, gint y, gint width, gint height, gint line_width, gint length, gint space);
void o_box_fill_hollow(GdkDrawable *w, GdkGC *gc, GdkColor *color, gint x, gint y, gint width, gint height, gint fill_width, gint angle1, gint pitch1, gint angle2, gint pitch2);
void o_box_fill_fill(GdkDrawable *w, GdkGC *gc, GdkColor *color, gint x, gint y, gint width, gint height, gint fill_width, gint angle1, gint pitch1, gint angle2, gint pitch2);
void o_box_fill_hatch(GdkDrawable *w, GdkGC *gc, GdkColor *color, gint x, gint y, gint width, gint height, gint fill_width, gint angle1, gint pitch1, gint angle2, gint pitch2);
void o_box_fill_mesh(GdkDrawable *w, GdkGC *gc, GdkColor *color, gint x, gint y, gint width, gint height, gint fill_width, gint angle1, gint pitch1, gint angle2, gint pitch2);
void o_box_erase(TOPLEVEL *w_current, OBJECT *o_current);
void o_box_eraserubber(TOPLEVEL *w_current);
void o_box_draw_xor(TOPLEVEL *w_current, int dx, int dy, OBJECT *o_current);
void o_box_start(TOPLEVEL *w_current, int x, int y);
void o_box_end(TOPLEVEL *w_current, int x, int y);
void o_box_rubberbox(TOPLEVEL *w_current, int x, int y);
void o_box_rubberbox_xor(TOPLEVEL *w_current);
void o_box_draw_grips(TOPLEVEL *w_current, OBJECT *o_current);
void o_box_erase_grips(TOPLEVEL *w_current, OBJECT *o_current);
/* o_buffer.c */
void o_buffer_copy(TOPLEVEL *w_current, int buf_num);
void o_buffer_cut(TOPLEVEL *w_current, int buf_num);
void o_buffer_paste_start(TOPLEVEL *w_current, int screen_x, int screen_y, int buf_num);
void o_buffer_paste_end(TOPLEVEL *w_current, int screen_x, int screen_y, int buf_num);
void o_buffer_paste_rubberpaste(TOPLEVEL *w_current, int buf_num);
void o_buffer_init(void);
void o_buffer_free(TOPLEVEL *w_current);
/* o_bus.c */
void o_bus_draw(TOPLEVEL *w_current, OBJECT *o_current);
void o_bus_erase(TOPLEVEL *w_current, OBJECT *o_current);
void o_bus_draw_xor(TOPLEVEL *w_current, int dx, int dy, OBJECT *o_current);
void o_bus_draw_xor_single(TOPLEVEL *w_current, int dx, int dy, int whichone, OBJECT *o_current);
void o_bus_start(TOPLEVEL *w_current, int x, int y);
int o_bus_end(TOPLEVEL *w_current, int x, int y);
void o_bus_rubberbus(TOPLEVEL *w_current, int x, int y);
void o_bus_eraserubber(TOPLEVEL *w_current);
void o_bus_xorrubber(TOPLEVEL *w_current);
/* o_circle.c */
void o_circle_draw(TOPLEVEL *w_current, OBJECT *o_current);
void o_circle_fill_hollow(GdkDrawable *w, GdkGC *gc, GdkColor *color, gint x, gint y, gint radius, gint width, gint angle1, gint pitch1, gint angle2, gint pitch2);
void o_circle_fill_fill(GdkDrawable *w, GdkGC *gc, GdkColor *color, gint x, gint y, gint radius, gint width, gint angle1, gint pitch1, gint angle2, gint pitch2);
void o_circle_fill_hatch(GdkDrawable *w, GdkGC *gc, GdkColor *color, gint x, gint y, gint radius, gint width, gint angle1, gint pitch1, gint angle2, gint pitch2);
void o_circle_fill_mesh(GdkDrawable *w, GdkGC *gc, GdkColor *color, gint x, gint y, gint radius, gint width, gint angle1, gint pitch1, gint angle2, gint pitch2);
void o_circle_erase(TOPLEVEL *w_current, OBJECT *o_current);
void o_circle_eraserubber(TOPLEVEL *w_current);
void o_circle_draw_xor(TOPLEVEL *w_current, int dx, int dy, OBJECT *o_current);
void o_circle_start(TOPLEVEL *w_current, int x, int y);
void o_circle_end(TOPLEVEL *w_current, int x, int y);
void o_circle_rubbercircle(TOPLEVEL *w_current, int x, int y);
void o_circle_rubbercircle_xor(TOPLEVEL *w_current);
void o_circle_draw_grips(TOPLEVEL *w_current, OBJECT *o_current);
void o_circle_erase_grips(TOPLEVEL *w_current, OBJECT *o_current);
/* o_complex.c */
void o_complex_draw(TOPLEVEL *w_current, OBJECT *o_current);
void o_complex_erase(TOPLEVEL *w_current, OBJECT *o_current);
void o_complex_draw_xor(TOPLEVEL *w_current, int dx, int dy, OBJECT *complex);
void o_complex_start(TOPLEVEL *w_current, int screen_x, int screen_y);
void o_complex_place_rotate(TOPLEVEL *w_current);
void o_complex_end(TOPLEVEL *w_current, int screen_x, int screen_y);
void o_complex_rubbercomplex(TOPLEVEL *w_current);
void o_complex_translate_display(TOPLEVEL *w_current, int x1, int y1, OBJECT *complex);
void o_complex_translate_display_selection(TOPLEVEL *w_current, int x1, int y1, SELECTION *head);
void o_complex_translate2(TOPLEVEL *w_current, int dx, int dy, OBJECT *object);
void o_complex_translate_all(TOPLEVEL *w_current, int offset);
void o_complex_translate_selection(TOPLEVEL *w_current, int dx, int dy, SELECTION *head);
void o_complex_rotate(TOPLEVEL *w_current, int centerx, int centery, int angle, int angle_change, OBJECT *object);
int o_complex_mirror(TOPLEVEL *w_current, int centerx, int centery, OBJECT *object);
OBJECT *o_complex_mirror2(TOPLEVEL *w_current, OBJECT *list, int centerx, int centery, OBJECT *object);
/* o_copy.c */
void o_copy_start(TOPLEVEL *w_current, int x, int y);
void o_copy_end(TOPLEVEL *w_current);
/* o_cue.c */
void o_cue_redraw_all(TOPLEVEL *w_current, OBJECT *head);
void o_cue_draw_lowlevel(TOPLEVEL *w_current, OBJECT *object, int whichone);
void o_cue_erase_lowlevel(TOPLEVEL *w_current, OBJECT *object, int whichone);
void o_cue_draw_lowlevel_midpoints(TOPLEVEL *w_current, OBJECT *object);
void o_cue_draw_single(TOPLEVEL *w_current, OBJECT *object);
void o_cue_erase_single(TOPLEVEL *w_current, OBJECT *object);
void o_cue_undraw(TOPLEVEL *w_current, OBJECT *object);
void o_cue_undraw_complex(TOPLEVEL *w_current, OBJECT *object);
void o_cue_draw_list(TOPLEVEL *w_current, GList *object_list);
void o_cue_undraw_list(TOPLEVEL *w_current, GList *object_list);
void o_cue_undraw_objects(TOPLEVEL *w_current, OBJECT *list);
/* o_delete.c */
void o_delete_net(TOPLEVEL *w_current, OBJECT *obj);
void o_delete_bus(TOPLEVEL *w_current, OBJECT *obj);
void o_delete_complex(TOPLEVEL *w_current, OBJECT *obj);
void o_delete_text(TOPLEVEL *w_current, OBJECT *obj);
void o_delete(TOPLEVEL *w_current);
/* o_find.c */
void o_find_object(TOPLEVEL *w_current, int screen_x, int screen_y);
/* o_grips.c */
OBJECT *o_grips_search(TOPLEVEL *w_current, int x, int y, int *whichone);
OBJECT *o_grips_search_arc(TOPLEVEL *w_current, OBJECT *o_current, int x, int y, int size, int *whichone);
OBJECT *o_grips_search_box(TOPLEVEL *w_current, OBJECT *o_current, int x, int y, int size, int *whichone);
OBJECT *o_grips_search_circle(TOPLEVEL *w_current, OBJECT *o_current, int x, int y, int size, int *whichone);
OBJECT *o_grips_search_line(TOPLEVEL *w_current, OBJECT *o_current, int x, int y, int size, int *whichone);
int o_grips_start(TOPLEVEL *w_current, int x, int y);
void o_grips_start_arc(TOPLEVEL *w_current, OBJECT *o_current, int x, int y, int whichone);
void o_grips_start_box(TOPLEVEL *w_current, OBJECT *o_current, int x, int y, int whichone);
void o_grips_start_circle(TOPLEVEL *w_current, OBJECT *o_current, int x, int y, int whichone);
void o_grips_start_line(TOPLEVEL *w_current, OBJECT *o_current, int x, int y, int whichone);
void o_grips_motion(TOPLEVEL *w_current, int x, int y);
void o_grips_motion_arc(TOPLEVEL *w_current, int x, int y, int whichone);
void o_grips_motion_box(TOPLEVEL *w_current, int x, int y, int whichone);
void o_grips_motion_circle(TOPLEVEL *w_current, int x, int y, int whichone);
void o_grips_motion_line(TOPLEVEL *w_current, int x, int y, int whichone);
void o_grips_end(TOPLEVEL *w_current);
void o_grips_end_arc(TOPLEVEL *w_current, OBJECT *o_current, int whichone);
void o_grips_end_box(TOPLEVEL *w_current, OBJECT *o_current, int whichone);
void o_grips_end_circle(TOPLEVEL *w_current, OBJECT *o_current, int whichone);
void o_grips_end_line(TOPLEVEL *w_current, OBJECT *o_current, int whichone);
int o_grips_size(TOPLEVEL *w_current);
void o_grips_draw(TOPLEVEL *w_current, int x, int y);
void o_grips_erase(TOPLEVEL *w_current, int x, int y);
/* o_line.c */
void o_line_draw(TOPLEVEL *w_current, OBJECT *o_current);
void o_line_draw_solid(GdkWindow *w, GdkGC *gc, GdkColor *color, GdkCapStyle cap, gint x1, gint y1, gint x2, gint y2, gint line_width, gint length, gint space);
void o_line_draw_dotted(GdkWindow *w, GdkGC *gc, GdkColor *color, GdkCapStyle cap, gint x1, gint y1, gint x2, gint y2, gint line_width, gint length, gint space);
void o_line_draw_dashed(GdkWindow *w, GdkGC *gc, GdkColor *color, GdkCapStyle cap, gint x1, gint y1, gint x2, gint y2, gint line_width, gint length, gint space);
void o_line_draw_center(GdkWindow *w, GdkGC *gc, GdkColor *color, GdkCapStyle cap, gint x1, gint y1, gint x2, gint y2, gint line_width, gint length, gint space);
void o_line_draw_phantom(GdkWindow *w, GdkGC *gc, GdkColor *color, GdkCapStyle cap, gint x1, gint y1, gint x2, gint y2, gint line_width, gint length, gint space);
void o_line_erase(TOPLEVEL *w_current, OBJECT *o_current);
void o_line_eraserubber(TOPLEVEL *w_current);
void o_line_draw_xor(TOPLEVEL *w_current, int dx, int dy, OBJECT *o_current);
void o_line_start(TOPLEVEL *w_current, int x, int y);
void o_line_end(TOPLEVEL *w_current, int x, int y);
void o_line_rubberline(TOPLEVEL *w_current, int x, int y);
void o_line_rubberline_xor(TOPLEVEL *w_current);
void o_line_draw_grips(TOPLEVEL *w_current, OBJECT *o_current);
void o_line_erase_grips(TOPLEVEL *w_current, OBJECT *o_current);
/* o_misc.c */
void o_edit(TOPLEVEL *w_current, SELECTION *list);
void o_lock(TOPLEVEL *w_current);
void o_unlock(TOPLEVEL *w_current);
void o_rotate_90(TOPLEVEL *w_current, SELECTION *list, int centerx, int centery);
void o_embed(TOPLEVEL *w_current);
void o_unembed(TOPLEVEL *w_current);
void o_mirror(TOPLEVEL *w_current, SELECTION *list, int centerx, int centery);
void o_edit_show_hidden_lowlevel(TOPLEVEL *w_current, OBJECT *o_list);
void o_edit_show_hidden(TOPLEVEL *w_current, OBJECT *o_list);
void o_edit_make_visible(TOPLEVEL *w_current, OBJECT *o_list);
int o_edit_find_text(TOPLEVEL *w_current, OBJECT *o_list, char *stext, int descend, int skip);
void find_max(TOPLEVEL *w_current, OBJECT *o_list, char *stext);
void autonumber_text(TOPLEVEL *w_current, OBJECT *o_list, char *stext);
void o_edit_autonumber_text(TOPLEVEL *w_current, OBJECT *o_list, char *stext);
void o_edit_hide_specific_text(TOPLEVEL *w_current, OBJECT *o_list, char *stext);
void o_edit_show_specific_text(TOPLEVEL *w_current, OBJECT *o_list, char *stext);
void o_update_component(TOPLEVEL *w_current, SELECTION *list);
/* o_move.c */
void o_move_start(TOPLEVEL *w_current, int x, int y);
void o_move_end_lowlevel(TOPLEVEL *w_current, OBJECT *list, int type, int diff_x, int diff_y, int screen_diff_x, int screen_diff_y, GList **other_objects, GList **connected_objects);
void o_move_end(TOPLEVEL *w_current);
int o_move_return_whichone(OBJECT *object, int x, int y);
void o_move_check_endpoint(TOPLEVEL *w_current, OBJECT *object);
void o_move_prep_rubberband(TOPLEVEL *w_current);
int o_move_zero_length(OBJECT *object);
void o_move_end_rubberband(TOPLEVEL *w_current, int world_diff_x, int world_diff_y, GList **objects, GList **other_objects, GList **connected_objects);
void o_move_stretch_rubberband(TOPLEVEL *w_current);
/* o_net.c */
void o_net_draw(TOPLEVEL *w_current, OBJECT *o_current);
void o_net_erase(TOPLEVEL *w_current, OBJECT *o_current);
void o_net_draw_xor(TOPLEVEL *w_current, int dx, int dy, OBJECT *o_current);
void o_net_draw_xor_single(TOPLEVEL *w_current, int dx, int dy, int whichone, OBJECT *o_current);
void o_net_start(TOPLEVEL *w_current, int x, int y);
int o_net_end(TOPLEVEL *w_current, int x, int y);
void o_net_rubbernet(TOPLEVEL *w_current, int x, int y);
void o_net_eraserubber(TOPLEVEL *w_current);
void o_net_xorrubber(TOPLEVEL *w_current);
int o_net_add_busrippers(TOPLEVEL *w_current, OBJECT *net_obj, GList *other_objects);
/* o_pin.c */
void o_pin_draw(TOPLEVEL *w_current, OBJECT *o_current);
void o_pin_erase(TOPLEVEL *w_current, OBJECT *o_current);
void o_pin_draw_xor(TOPLEVEL *w_current, int dx, int dy, OBJECT *o_current);
void o_pin_start(TOPLEVEL *w_current, int x, int y);
void o_pin_end(TOPLEVEL *w_current, int x, int y);
void o_pin_rubberpin(TOPLEVEL *w_current, int x, int y);
void o_pin_eraserubber(TOPLEVEL *w_current);
/* o_select.c */
void o_select_object(TOPLEVEL *w_current, OBJECT *o_current, int type, int count);
void o_select_box_start(TOPLEVEL *w_current, int x, int y);
void o_select_box_end(TOPLEVEL *w_current, int x, int y);
void o_select_box_rubberband(TOPLEVEL *w_current, int x, int y);
void o_select_box_search(TOPLEVEL *w_current);
OBJECT *o_select_return_first_object(TOPLEVEL *w_current);
int o_select_selected(TOPLEVEL *w_current);
void o_select_unselect_all(TOPLEVEL *w_current);
/* o_slot.c */
void o_slot_start(TOPLEVEL *w_current, OBJECT *list);
void o_slot_end(TOPLEVEL *w_current, char *string, int len);
/* o_text.c */
void o_text_draw_lowlevel(TOPLEVEL *w_current, OBJECT *o_current);
void o_text_draw_rectangle(TOPLEVEL *w_current, OBJECT *o_current);
void o_text_draw(TOPLEVEL *w_current, OBJECT *o_current);
void o_text_erase(TOPLEVEL *w_current, OBJECT *o_current);
void o_text_draw_xor(TOPLEVEL *w_current, int dx, int dy, OBJECT *o_current);
void o_text_input(TOPLEVEL *w_current);
void o_text_start(TOPLEVEL *w_current, int screen_x, int screen_y);
void o_text_end(TOPLEVEL *w_current);
void o_text_rubberattrib(TOPLEVEL *w_current);
void o_text_edit(TOPLEVEL *w_current, OBJECT *o_current);
void o_text_edit_end(TOPLEVEL *w_current, char *string, int len, int text_size, int text_alignment);
void o_text_change(TOPLEVEL *w_current, OBJECT *object, char *string, int visibility, int show);
void o_text_place_rotate(TOPLEVEL *w_current);
/* o_undo.c */
void o_undo_init(void);
void o_undo_savestate(TOPLEVEL *w_current, int flag);
char *o_undo_find_prev_filename(UNDO *start);
OBJECT *o_undo_find_prev_object_head(UNDO *start);
void o_undo_callback(TOPLEVEL *w_current, int type);
void o_undo_cleanup(void);
/* parsecmd.c */
void usage(char *cmd);
int parse_commandline(int argc, char *argv[]);
/* x_attribedit.c */
gint option_menu_get_history(GtkOptionMenu *option_menu);
int attrib_edit_dialog_keypress(GtkWidget *widget, GdkEventKey *event, TOPLEVEL *w_current);
void attrib_edit_dialog_ok(GtkWidget *w, TOPLEVEL *w_current);
void attrib_edit_dialog_cancel(GtkWidget *w, TOPLEVEL *w_current);
void attrib_edit_dialog_delete(GtkWidget *w, TOPLEVEL *w_current);
void attrib_edit_dialog(TOPLEVEL *w_current, OBJECT *list, int flag);
/* x_basic.c */
void x_repaint_background(TOPLEVEL *w_current);
void x_hscrollbar_set_ranges(TOPLEVEL *w_current);
void x_hscrollbar_update(TOPLEVEL *w_current);
void x_vscrollbar_set_ranges(TOPLEVEL *w_current);
void x_vscrollbar_update(TOPLEVEL *w_current);
void x_scrollbars_update(TOPLEVEL *w_current);
GtkWidget *x_create_dialog_box(GtkWidget **out_vbox, GtkWidget **out_action_area);
GtkWidget *x_create_dialog_box_horiz(GtkWidget **out_hbox, GtkWidget **out_action_area);
void x_basic_warp_cursor(GtkWidget *widget, gint x, gint y, gboolean relative);
/* x_color.c */
void x_color_allocate_all(void);
GdkColor *x_get_color(int color);
GdkColor *x_get_darkcolor(int color);
int x_color_get_name(int index, char *string);
/* x_dialog.c */
#ifdef HAS_GTK22
int text_view_calculate_real_tab_width(GtkTextView *textview, int tab_size);
void select_all_text_in_textview(GtkTextView *textview);
#endif
void destroy_window(GtkWidget *widget, GtkWidget **window);
int text_input_dialog_keypress(GtkWidget *widget, GdkEventKey *event, TOPLEVEL *w_current);
void text_input_dialog_apply(GtkWidget *w, TOPLEVEL *w_current);
void text_input_dialog_close(GtkWidget *w, TOPLEVEL *w_current);
void text_input_dialog(TOPLEVEL *w_current);
gint change_alignment(GtkWidget *w, TOPLEVEL *w_current);
int text_edit_dialog_keypress(GtkWidget *widget, GdkEventKey *event, TOPLEVEL *w_current);
void text_edit_dialog_ok(GtkWidget *w, TOPLEVEL *w_current);
void text_edit_dialog_cancel(GtkWidget *w, TOPLEVEL *w_current);
void text_edit_dialog(TOPLEVEL *w_current, char *string, int text_size, int text_alignment);
gint change_linetype(GtkWidget *w, TOPLEVEL *w_current);
int line_type_dialog_keypress(GtkWidget *widget, GdkEventKey *event, TOPLEVEL *w_current);
void line_type_dialog_ok(GtkWidget *w, TOPLEVEL *w_current);
void line_type_dialog_cancel(GtkWidget *w, TOPLEVEL *w_current);
void line_type_dialog(TOPLEVEL *w_current, OBJECT *object);
gint change_filltype(GtkWidget *w, TOPLEVEL *w_current);
int fill_type_dialog_keypress(GtkWidget *widget, GdkEventKey *event, TOPLEVEL *w_current);
void fill_type_dialog_ok(GtkWidget *w, TOPLEVEL *w_current);
void fill_type_dialog_cancel(GtkWidget *w, TOPLEVEL *w_current);
void fill_type_dialog(TOPLEVEL *w_current, OBJECT *object);
int exit_dialog_keypress(GtkWidget *widget, GdkEventKey *event, TOPLEVEL *w_current);
void exit_dialog_ok(GtkWidget *w, TOPLEVEL *w_current);
void exit_dialog_cancel(GtkWidget *w, TOPLEVEL *w_current);
void exit_dialog(TOPLEVEL *w_current);
int arc_angles_dialog_keypress(GtkWidget *widget, GdkEventKey *event, TOPLEVEL *w_current);
void arc_angles_dialog_ok(GtkWidget *w, TOPLEVEL *w_current);
void arc_angles_dialog_cancel(GtkWidget *w, TOPLEVEL *w_current);
void arc_angle_dialog(TOPLEVEL *w_current);
int translate_dialog_keypress(GtkWidget *widget, GdkEventKey *event, TOPLEVEL *w_current);
void translate_dialog_ok(GtkWidget *w, TOPLEVEL *w_current);
void translate_dialog_cancel(GtkWidget *w, TOPLEVEL *w_current);
void translate_dialog(TOPLEVEL *w_current);
int text_size_dialog_keypress(GtkWidget *widget, GdkEventKey *event, TOPLEVEL *w_current);
void text_size_dialog_ok(GtkWidget *w, TOPLEVEL *w_current);
void text_size_dialog_cancel(GtkWidget *w, TOPLEVEL *w_current);
void text_size_dialog(TOPLEVEL *w_current);
int snap_size_dialog_keypress(GtkWidget *widget, GdkEventKey *event, TOPLEVEL *w_current);
void snap_size_dialog_ok(GtkWidget *w, TOPLEVEL *w_current);
void snap_size_dialog_cancel(GtkWidget *w, TOPLEVEL *w_current);
void snap_size_dialog(TOPLEVEL *w_current);
int slot_edit_dialog_keypress(GtkWidget *widget, GdkEventKey *event, TOPLEVEL *w_current);
void slot_edit_dialog_ok(GtkWidget *w, TOPLEVEL *w_current);
void slot_edit_dialog_cancel(GtkWidget *w, TOPLEVEL *w_current);
void slot_edit_dialog(TOPLEVEL *w_current, char *string);
int about_dialog_keypress(GtkWidget *widget, GdkEventKey *event, TOPLEVEL *w_current);
void about_dialog_close(GtkWidget *w, TOPLEVEL *w_current);
void about_dialog(TOPLEVEL *w_current);
int coord_dialog_keypress(GtkWidget *widget, GdkEventKey *event, TOPLEVEL *w_current);
void coord_dialog_close(GtkWidget *w, TOPLEVEL *w_current);
void coord_display_update(TOPLEVEL *w_current, int x, int y);
void coord_dialog(TOPLEVEL *w_current, int x, int y);
gint color_set(GtkWidget *w, gpointer data);
char *index2functionstring(int index);
int color_edit_dialog_keypress(GtkWidget *widget, GdkEventKey *event, TOPLEVEL *w_current);
void color_edit_dialog_close(GtkWidget *w, TOPLEVEL *w_current);
void color_edit_dialog_apply(GtkWidget *w, TOPLEVEL *w_current);
void color_edit_dialog(TOPLEVEL *w_current);
int x_dialog_hotkeys_keypress(GtkWidget *widget, GdkEventKey *event, TOPLEVEL *w_current);
void x_dialog_hotkeys_close(GtkWidget *w, TOPLEVEL *w_current);
void x_dialog_hotkeys_free_all(void);
void x_dialog_hotkeys_fill(char *string);
void x_dialog_hotkeys(TOPLEVEL *w_current);
void x_dialog_raise_all(TOPLEVEL *w_current);
void generic_text_input_ok(GtkWidget *w, TOPLEVEL *w_current);
void generic_text_input_dialog(TOPLEVEL *w_current);
int find_text_keypress(GtkWidget *widget, GdkEventKey *event, TOPLEVEL *w_current);
void find_text_ok(GtkWidget *w, TOPLEVEL *w_current);
void find_text_done(GtkWidget *w, TOPLEVEL *w_current);
void find_text_dialog(TOPLEVEL *w_current);
int hide_text_keypress(GtkWidget *widget, GdkEventKey *event, TOPLEVEL *w_current);
void hide_text_ok(GtkWidget *w, TOPLEVEL *w_current);
void hide_text_done(GtkWidget *w, TOPLEVEL *w_current);
void hide_text_dialog(TOPLEVEL *w_current);
int show_text_keypress(GtkWidget *widget, GdkEventKey *event, TOPLEVEL *w_current);
void show_text_ok(GtkWidget *w, TOPLEVEL *w_current);
void show_text_done(GtkWidget *w, TOPLEVEL *w_current);
void show_text_dialog(TOPLEVEL *w_current);
int autonumber_text_keypress(GtkWidget *widget, GdkEventKey *event, TOPLEVEL *w_current);
void autonumber_text_ok(GtkWidget *w, TOPLEVEL *w_current);
void autonumber_text_done(GtkWidget *w, TOPLEVEL *w_current);
void autonumber_text_dialog(TOPLEVEL *w_current);
/* x_event.c */
gint x_event_expose(GtkWidget *widget, GdkEventExpose *event, TOPLEVEL *w_current);
gint x_event_button_pressed(GtkWidget *widget, GdkEventButton *event, TOPLEVEL *w_current);
gint x_event_button_released(GtkWidget *widget, GdkEventButton *event, TOPLEVEL *w_current);
gint x_event_motion(GtkWidget *widget, GdkEventMotion *event, TOPLEVEL *w_current);
gint x_event_configure(GtkWidget *widget, GdkEventConfigure *event, TOPLEVEL *w_current);
void x_manual_resize(TOPLEVEL *w_current);
void x_event_hschanged(GtkAdjustment *adj, TOPLEVEL *w_current);
void x_event_vschanged(GtkAdjustment *adj, TOPLEVEL *w_current);
gint x_event_enter(GtkWidget *widget, GdkEventCrossing *event, TOPLEVEL *w_current);
gint x_event_key_press(GtkWidget *widget, GdkEventKey *event, TOPLEVEL *w_current);
/* x_fileselect.c */
void x_fileselect_destroy_window(GtkWidget *widget, FILEDIALOG *f_current);
int x_fileselect_keypress(GtkWidget *widget, GdkEventKey *event, FILEDIALOG *f_current);
void x_fileselect_init_list_buffers(FILEDIALOG *f_current);
void x_fileselect_free_list_buffers(FILEDIALOG *f_current);
void x_fileselect_update_dirfile(FILEDIALOG *f_current, char *filename);
void x_fileselect_setup_list_buffers(FILEDIALOG *f_current, int num_files, int num_directories);
int x_fileselect_include_file(char *filename, int filter_type);
void x_fileselect_fill_lists(FILEDIALOG *f_current);
gint x_fileselect_sch_files(GtkWidget *w, FILEDIALOG *f_current);
gint x_fileselect_sym_files(GtkWidget *w, FILEDIALOG *f_current);
gint x_fileselect_both_files(GtkWidget *w, FILEDIALOG *f_current);
gint x_fileselect_all_files(GtkWidget *w, FILEDIALOG *f_current);
int x_fileselect_preview_checkbox(GtkWidget *widget, FILEDIALOG *f_current);
void x_fileselect_saveas_close(GtkWidget *w, FILEDIALOG *f_current);
void x_fileselect_saveas(GtkWidget *w, FILEDIALOG *f_current);
void x_fileselect_change_dir(FILEDIALOG *f_current, char *new_directory);
void x_fileselect_open_file(GtkWidget *w, FILEDIALOG *f_current);
void x_fileselect_dir_button(GtkWidget *widget, gint row, gint column, GdkEventButton *bevent, FILEDIALOG *f_current);
void x_fileselect_file_button(GtkWidget *widget, gint row, gint column, GdkEventButton *bevent, FILEDIALOG *f_current);
void x_fileselect_update_dirfile_saveas(FILEDIALOG *f_current, char *new_filename);
void x_fileselect_close(GtkWidget *w, FILEDIALOG *f_current);
void x_fileselect_search(GtkWidget *w, FILEDIALOG *f_current);
gint default_components(GtkWidget *w, TOPLEVEL *w_current);
gint embed_components(GtkWidget *w, TOPLEVEL *w_current);
gint include_components(GtkWidget *w, TOPLEVEL *w_current);
void x_fileselect_comp_fill_libs(TOPLEVEL *w_current, FILEDIALOG *f_current);
void x_fileselect_comp_fill_components(FILEDIALOG *f_current, int row);
void x_fileselect_comp_update_current(FILEDIALOG *f_current, char *library, char *component);
void x_fileselect_change_clib(FILEDIALOG *f_current, char *new_clib, int row);
void x_fileselect_lib_select(GtkWidget *widget, gint row, gint column, GdkEventButton *bevent, FILEDIALOG *f_current);
void x_fileselect_comp_select(GtkWidget *widget, gint row, gint column, GdkEventButton *bevent, FILEDIALOG *f_current);
void x_fileselect_comp_apply(GtkWidget *w, FILEDIALOG *f_current);
void x_fileselect_comp_close(GtkWidget *w, FILEDIALOG *f_current);
int x_fileselect_search_library(FILEDIALOG *f_current, char *library, char *string);
void x_fileselect_comp_search(GtkWidget *w, FILEDIALOG *f_current);
void x_fileselect_setup(TOPLEVEL *w_current, int type, int filesel_type);
/* x_grid.c */
void x_grid_draw(TOPLEVEL *w_current);
void x_draw_tiles(TOPLEVEL *w_current);
/* x_image.c */
gint image_320(GtkWidget *w, TOPLEVEL *w_current);
gint image_640(GtkWidget *w, TOPLEVEL *w_current);
gint image_800(GtkWidget *w, TOPLEVEL *w_current);
gint image_1024(GtkWidget *w, TOPLEVEL *w_current);
gint image_1280(GtkWidget *w, TOPLEVEL *w_current);
gint image_1600(GtkWidget *w, TOPLEVEL *w_current);
gint image_3200(GtkWidget *w, TOPLEVEL *w_current);
void x_image_lowlevel(TOPLEVEL *w_current, char* filename);
gint x_image_write(GtkWidget *w, TOPLEVEL *w_current);
gint x_image_cancel(GtkWidget *w, TOPLEVEL *w_current);
int x_image_keypress(GtkWidget *widget, GdkEventKey *event, TOPLEVEL *w_current);
void x_image_setup(TOPLEVEL *w_current, char *filename);
/* x_log.c */
void x_log_init(char *cwd, char *filename);
void x_log_read(void);
void x_log_update(char *buf);
void x_log_close(GtkWidget *w, TOPLEVEL *w_current);
void x_log_free(void);
void x_log_setup_win(TOPLEVEL *w_current);
/* x_menus.c */
void get_main_menu(TOPLEVEL *w_current, GtkWidget **menubar);
void get_main_popup(TOPLEVEL *w_current, GtkWidget **menu);
gint do_popup(TOPLEVEL *w_current, GdkEventButton *event);
void x_menus_sensitivity(TOPLEVEL *w_current, char *buf, int flag);
/* x_multiattrib.c */
int multi_attrib_edit_keypress(GtkWidget *widget, GdkEventKey *event, TOPLEVEL *w_current);
char *multi_attrib_edit_parser(GtkWidget *w, char **text, int *vis, int *show);
void multi_attrib_edit_set_values(GtkWindow *window, OBJECT *attrib);
void multi_attrib_edit_clear(GtkWidget *w, GtkWindow *window);
void multi_attrib_edit_select_row(GtkCList *clist, gint row, gint col, GdkEventButton *event, TOPLEVEL *w_current);
void multi_attrib_edit_add(GtkWidget *w, TOPLEVEL *w_current);
void multi_attrib_edit_change(GtkWidget *w, TOPLEVEL *w_current);
void multi_attrib_edit_delete(GtkWidget *w, TOPLEVEL *w_current);
void multi_attrib_edit_close(GtkWidget *w, TOPLEVEL *w_current);
void multi_attrib_edit(TOPLEVEL *w_current, SELECTION *list);
void multi_attrib_parse_attribute(GtkWidget *w, GtkWidget *w_current);
/* x_multimulti.c */
/* x_pagesel.c */
void update_page_manager(GtkWidget *widget, TOPLEVEL *w_current);
gint save_page(GtkWidget *gtklist, TOPLEVEL *w_current);
gint file_new(GtkWidget *gtklist, TOPLEVEL *w_current);
gint file_open(GtkWidget *gtklist, TOPLEVEL *w_current);
gint page_close(GtkWidget *gtklist, TOPLEVEL *w_current);
gint page_discard(GtkWidget *gtklist, TOPLEVEL *w_current);
gint change_page(GtkWidget *widget, gint row, gint column, GdkEventButton *bevent);
gint page_manager_close(GtkWidget *w, TOPLEVEL *w_current);
int page_manager_keypress(GtkWidget *widget, GdkEventKey *event, TOPLEVEL *w_current);
void setup_page_selector(TOPLEVEL *w_current);
/* x_preview.c */
void x_preview_update(TOPLEVEL *preview, char *directory, char *filename);
void x_preview_close(TOPLEVEL *w_current);
gint x_preview_expose(GtkWidget *widget, GdkEventExpose *event, TOPLEVEL *w_current);
gint x_preview_button_pressed(GtkWidget *widget, GdkEventButton *event, TOPLEVEL *w_current);
gint x_preview_motion(GtkWidget *widget, GdkEventMotion *event, TOPLEVEL *w_current);
void x_preview_create_drawing(GtkWidget *drawbox, TOPLEVEL *w_current);
void x_preview_setup_rest(TOPLEVEL *preview);
TOPLEVEL *x_preview_setup(GtkWidget *xfwindow, GtkWidget *drawbox);
/* x_print.c */
gint print_landscape(GtkWidget *w, TOPLEVEL *w_current);
gint print_portrait(GtkWidget *w, TOPLEVEL *w_current);
gint x_print_set_window(GtkWidget *w, TOPLEVEL *w_current);
gint x_print_set_extents(GtkWidget *w, TOPLEVEL *w_current);
gint x_print_set_nomargins(GtkWidget *w, TOPLEVEL *w_current);
gint x_print_change_size(GtkWidget *gtklist, TOPLEVEL *w_current);
gint x_print_print(GtkWidget *w, TOPLEVEL *w_current);
gint x_print_cancel(GtkWidget *w, TOPLEVEL *w_current);
int x_print_keypress(GtkWidget *widget, GdkEventKey *event, TOPLEVEL *w_current);
void x_print_setup(TOPLEVEL *w_current, char *filename);
/* x_script.c */
void script_selection_ok(GtkWidget *w, TOPLEVEL *w_current);
void script_selection_cancel(GtkWidget *w, TOPLEVEL *w_current);
void setup_script_selector(TOPLEVEL *w_current);
/* x_stroke.c */
void x_stroke_add_point(TOPLEVEL *w_current, int x, int y);
void x_stroke_erase_all(TOPLEVEL *w_current);
void x_stroke_free_all(void);
int x_stroke_search_execute(char *sequence);
/* x_window.c */
TOPLEVEL *x_window_add(TOPLEVEL *w_head, TOPLEVEL *w_current);
void x_window_add_head(void);
void x_window_free_head(void);
void x_window_delete(TOPLEVEL *w_head, TOPLEVEL *w_current);
void x_window_setup_world(TOPLEVEL *w_current);
void x_window_setup_rest(TOPLEVEL *w_current);
void x_window_setup_colors(void);
void x_window_free_colors(TOPLEVEL *w_current);
void x_window_setup_gc(TOPLEVEL *w_current);
void x_window_free_gc(TOPLEVEL *w_current);
void x_window_create_drawing(GtkWidget *drawbox, TOPLEVEL *w_current);
void x_window_setup_draw_events(TOPLEVEL *w_current);
void x_window_create_main(TOPLEVEL *w_current);
TOPLEVEL *x_window_create_new(void);
void x_window_close(TOPLEVEL *w_current);
void x_window_close_all(void);
TOPLEVEL *x_window_get_ptr(int wid);
TOPLEVEL *x_window_search_page_clist(GtkWidget *findme);
