#line 36 "../noweb/o_misc.nw"
/* gEDA - GPL Electronic Design Automation
 * gschem - gEDA Schematic Capture
 * Copyright (C) 1998-2000 Ales V. Hvezda
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */


#line 11 "../noweb/o_misc.nw"
/* DO NOT read or edit this file ! Use ../noweb/o_misc.nw instead */

#line 59 "../noweb/o_misc.nw"
#include <config.h>

#include <stdio.h>
#include <ctype.h>
#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include <libgeda/libgeda.h>

#include "../include/globals.h"
#include "../include/prototype.h"

#line 81 "../noweb/o_misc.nw"
/* break with the tradition here and input a list */
/* TODO: probably should go back and do the same for o_copy o_move
   o_delete... */
void o_edit(TOPLEVEL * w_current, SELECTION * list)
{
  char *equal_ptr;
  OBJECT *o_current;
#if 0				/* was HAS_LIBGTKEXTRA, no longer user */
  SELECTION *s_current;
  int object_count = 0;
#endif
  int num_lines = 0;

  if (list == NULL) {
    w_current->inside_action = 0;
    i_set_state(w_current, SELECT);
    return;
  }

  o_current = list->selected_object;
  if (o_current == NULL) {
    fprintf(stderr, _("Got an unexpected NULL in o_edit\n"));
    exit(-1);
  }
#if 0				/* was HAS_LIBGTKEXTRA, no longer used */
  /* count up how many non-text objects exist in the selection */
  /* list.  Why?  Because if there are multiple objects, invoke the */
  /* multi_multi_edit dialog box */
  s_current = list;
  while (s_current != NULL) {
    if (s_current->selected_object) {
      if (s_current->selected_object->type != OBJ_TEXT) {
	object_count++;
      }
    }
    s_current = s_current->next;
  }

  /* now decide what we want to do, either single edit or */
  /* multi multi edit */
  if (object_count == 1 && o_current->type != OBJ_TEXT) {
    multi_attrib_edit(w_current, list);
    return;
  } else if (object_count > 1) {
    multi_multi_edit(w_current, list);
    return;
  }
#endif


  /* for now deal with only the first item */
  switch (o_current->type) {

    /* also add the ability to multi attrib edit: nets, busses, pins */
  case (OBJ_COMPLEX):
  case (OBJ_NET):
  case (OBJ_PIN):
  case (OBJ_BUS):
    multi_attrib_edit(w_current, list);
    break;

  case (OBJ_TEXT):
    if (strchr(o_current->text->string, '=')) {

      /* now really make sure it's an attribute by 
       * checking that there are NO spaces around the ='s 
       */
      equal_ptr = strchr(o_current->text->string, '=');

      /* and also make sure it is only a single line */
      num_lines = o_text_num_lines(o_current->text->string);

      /* there is a possiblity for core dump yes? */
      /* by exceeding the size of the text_string? */
      /* or maybe not, since if the ='s is at the end of */
      /* the string, there better be a null after it! */
      if ((*(equal_ptr + 1) != ' ') &&
	  (*(equal_ptr - 1) != ' ') && (num_lines == 1)) {
	attrib_edit_dialog(w_current, o_current, FROM_MENU);
	/*      multi_attrib_edit(w_current, o_current); */

      } else {
	o_text_edit(w_current, o_current);
      }
    } else {
      o_text_edit(w_current, o_current);
    }
    break;
  }

  /* has to be more extensive in the future */
  /* some sort of redrawing? */
}


#line 188 "../noweb/o_misc.nw"
/* This locks the entire selected list.  It does lock components, but does NOT
 * change the color (of primatives of the components) though 
 * this cannot be called recursively */
void o_lock(TOPLEVEL * w_current)
{
  OBJECT *object = NULL;
  SELECTION *s_current = NULL;

  /* skip over head */
  s_current = w_current->page_current->selection2_head->next;

  while (s_current != NULL) {
    object = s_current->selected_object;
    if (object) {
      /* check to see if locked_color is already being used */
      if (object->locked_color == -1) {
	object->sel_func = NULL;
	object->locked_color = object->color;
	object->color = w_current->lock_color;
	w_current->page_current->CHANGED = 1;
      } else {
	s_log_message(_("Object alreadly locked\n"));
      }
    }

    s_current = s_current->next;
  }

  o_unselect_all(w_current);
  o_undo_savestate(w_current, UNDO_ALL);
  i_update_menus(w_current);
}

#line 232 "../noweb/o_misc.nw"
/* You can unlock something by selecting it with a bounding box... */
/* this will probably change in the future, but for now it's a
   something.. :-) */
/* this cannot be called recursively */
void o_unlock(TOPLEVEL * w_current)
{
  OBJECT *object = NULL;
  SELECTION *s_current = NULL;

  s_current = w_current->page_current->selection2_head->next;

  while (s_current != NULL) {
    object = s_current->selected_object;
    if (object) {
      /* only unlock if sel_func is not set to something */
      if (object->sel_func == NULL) {
	object->sel_func = select_func;
	object->color = object->locked_color;
	object->locked_color = -1;
	w_current->page_current->CHANGED = 1;
      } else {
	s_log_message(_("Object alreadly unlocked\n"));
      }
    }

    s_current = s_current->next;
  }
  o_undo_savestate(w_current, UNDO_ALL);
}


#line 273 "../noweb/o_misc.nw"
void
o_rotate_90(TOPLEVEL * w_current, SELECTION * list, int centerx,
	    int centery)
{
  OBJECT *object;
  SELECTION *s_current;
  int new_angle;
  GList *other_objects = NULL;
  GList *connected_objects = NULL;
  OBJECT *o_current;

  /* this is okay if you just hit rotate and have nothing selected */
  if (list == NULL) {
    w_current->inside_action = 0;
    i_set_state(w_current, SELECT);
    return;
  }

  s_current = list;

  while (s_current != NULL) {
    object = s_current->selected_object;

    if (!object) {
      fprintf(stderr, _("ERROR: NULL object in o_rotate_90!\n"));
      return;
    }

    g_list_free(other_objects);
    other_objects = NULL;
    g_list_free(connected_objects);
    connected_objects = NULL;

    switch (object->type) {


    case (OBJ_NET):
      o_cue_undraw(w_current, object);
      o_net_erase(w_current, object);
      o_line_erase_grips(w_current, object);

      /* save the other objects */
      other_objects = s_conn_return_others(other_objects, object);
      s_conn_remove(w_current, object);

      o_net_rotate(w_current, centerx, centery, 90, object);
      s_conn_update_object(w_current, object);
      o_net_draw(w_current, object);

      /* draw the other objects */
      o_cue_undraw_list(w_current, other_objects);
      o_cue_draw_list(w_current, other_objects);

      /* get other connected objects and redraw */
      connected_objects = s_conn_return_others(connected_objects, object);
      o_cue_undraw_list(w_current, connected_objects);
      o_cue_draw_list(w_current, connected_objects);

      /* finally redraw the cues on the current object */
      o_cue_draw_single(w_current, object);
      break;

    case (OBJ_BUS):
      o_cue_undraw(w_current, object);
      o_bus_erase(w_current, object);
      o_line_erase_grips(w_current, object);

      other_objects = s_conn_return_others(other_objects, object);
      s_conn_remove(w_current, object);

      o_bus_rotate(w_current, centerx, centery, 90, object);
      s_conn_update_object(w_current, object);
      o_bus_draw(w_current, object);

      /* draw the other objects */
      o_cue_undraw_list(w_current, other_objects);
      o_cue_draw_list(w_current, other_objects);

      /* get other connected objects and redraw */
      connected_objects = s_conn_return_others(connected_objects, object);
      o_cue_undraw_list(w_current, connected_objects);
      o_cue_draw_list(w_current, connected_objects);

      /* finally redraw the cues on the current object */
      o_cue_draw_single(w_current, object);
      break;

    case (OBJ_PIN):
      o_cue_undraw(w_current, object);
      o_pin_erase(w_current, object);
      o_line_erase_grips(w_current, object);

      other_objects = s_conn_return_others(other_objects, object);
      s_conn_remove(w_current, object);

      o_pin_rotate(w_current, centerx, centery, 90, object);
      s_conn_update_object(w_current, object);
      o_pin_draw(w_current, object);

      /* draw the other objects */
      o_cue_undraw_list(w_current, other_objects);
      o_cue_draw_list(w_current, other_objects);

      /* get other connected objects and redraw */
      connected_objects = s_conn_return_others(connected_objects, object);
      o_cue_undraw_list(w_current, connected_objects);
      o_cue_draw_list(w_current, connected_objects);

      /* finally redraw the cues on the current object */
      o_cue_draw_single(w_current, object);
      break;

    case (OBJ_COMPLEX):
      o_cue_undraw_objects(w_current, object->complex->prim_objs);
      /* erase the current selection */
      o_complex_erase(w_current, object);

      other_objects = s_conn_return_complex_others(other_objects, object);

      /* remove all conn references */
      o_current = object->complex->prim_objs;
      while (o_current != NULL) {
	s_conn_remove(w_current, o_current);
	o_current = o_current->next;
      }

      /* do the rotate */
      /*w_current->ADDING_SEL=1; NEWSEL: needed? */
      new_angle = (object->complex->angle + 90) % 360;
      o_complex_rotate(w_current, centerx, centery, new_angle, 90, object);
      /*w_current->ADDING_SEL = 0; NEWSEL: needed? */
      s_conn_update_complex(w_current, object->complex->prim_objs);
      o_complex_draw(w_current, object);

      o_cue_undraw_list(w_current, other_objects);
      o_cue_draw_list(w_current, other_objects);

      /* now draw the newly connected objects */
      connected_objects = s_conn_return_complex_others(connected_objects,
						       object);
      o_cue_undraw_list(w_current, connected_objects);
      o_cue_draw_list(w_current, connected_objects);
      break;

    case (OBJ_LINE):
      o_line_erase_grips(w_current, object);
      o_line_erase(w_current, object);

      o_line_rotate(w_current, centerx, centery, 90, object);

      o_line_draw(w_current, object);
      break;

    case (OBJ_BOX):
      /* erase the current selection */
      o_box_erase_grips(w_current, object);
      o_box_erase(w_current, object);

      o_box_rotate(w_current, centerx, centery, 90, object);

      o_box_draw(w_current, object);
      break;

    case (OBJ_CIRCLE):
      o_circle_erase_grips(w_current, object);
      o_circle_erase(w_current, object);

      o_circle_rotate(w_current, centerx, centery, 90, object);

      o_circle_draw(w_current, object);
      break;

    case (OBJ_ARC):
      o_arc_erase(w_current, object);

#if 0				/* not needed anymore */
      SCREENtoWORLD(w_current, centerx, centery,
		    &world_centerx, &world_centery);
      o_arc_rotate_world(w_current, world_centerx, world_centery, 90,
			 object);
#endif

      o_arc_rotate(w_current, centerx, centery, 90, object);
      o_arc_draw(w_current, object);
      break;

    case (OBJ_TEXT):
      /* erase the current selection */
      o_text_erase(w_current, object);

      new_angle = (object->text->angle + 90) % 360;
      o_text_rotate(w_current, centerx, centery, new_angle, 90, object);

      o_text_draw(w_current, object);
      break;
    }
    s_current = s_current->next;
  }

  w_current->page_current->CHANGED = 1;
  o_undo_savestate(w_current, UNDO_ALL);
}


#line 490 "../noweb/o_misc.nw"
void o_embed(TOPLEVEL * w_current)
{
  OBJECT *object = NULL;
  char *new_basename;
  SELECTION *s_current = NULL;

  s_current = w_current->page_current->selection2_head->next;

  while (s_current != NULL) {
    object = s_current->selected_object;

    if (!object) {
      fprintf(stderr, _("ERROR: NULL object in o_embed!\n"));
      return;
    }

    if (object->type == OBJ_COMPLEX) {
      if (strncmp(object->complex_clib, "EMBEDDED", 8) != 0) {

	if (object->complex_clib) {
	  free(object->complex_clib);
	}

	object->complex_clib = u_basic_strdup("EMBEDDED");
	new_basename = u_basic_strdup_multiple("EMBEDDED",
					       object->
					       complex_basename, NULL);

	free(object->complex_basename);

	object->complex_basename = u_basic_strdup(new_basename);

	free(new_basename);

	w_current->page_current->CHANGED = 1;
      }
    }
    s_current = s_current->next;
  }
}


#line 546 "../noweb/o_misc.nw"
void o_unembed(TOPLEVEL * w_current)
{
  OBJECT *object = NULL;
  char *new_basename;
  char *new_clib;
  SELECTION *s_current = NULL;

  s_current = w_current->page_current->selection2_head->next;

  while (s_current != NULL) {
    object = s_current->selected_object;

    if (!object) {
      fprintf(stderr, _("ERROR: NULL object in o_embed!\n"));
      return;
    }

    if (object->type == OBJ_COMPLEX) {
      if (strncmp(object->complex_clib, "EMBEDDED", 8) == 0) {

	new_basename =
	    (char *) malloc(sizeof(char) *
			    (strlen(object->complex_basename) + 1));

	sprintf(new_basename, "%s", (object->complex_basename + 8));

	new_clib = (char *) s_clib_search(new_basename);

	if (!new_clib) {
	  fprintf(stderr,
		  _
		  ("Could not find component [%s], while trying to unembed.\n"),
		  object->complex_basename);
	  fprintf(stderr, _("Component is still embedded\n"));
	} else {
	  free(object->complex_basename);

	  object->complex_basename = new_basename;

	  free(object->complex_clib);

	  object->complex_clib = new_clib;

	  w_current->page_current->CHANGED = 1;
	}
      }
    }

    s_current = s_current->next;
  }
}


#line 612 "../noweb/o_misc.nw"
void
o_mirror(TOPLEVEL * w_current, SELECTION * list, int centerx, int centery)
{
  OBJECT *object;
  SELECTION *s_current;
  OBJECT *o_current = NULL;
  GList *other_objects = NULL;
  GList *connected_objects = NULL;

  if (list == NULL) {
    w_current->inside_action = 0;
    i_set_state(w_current, SELECT);
    return;
  }

  s_current = list;

  while (s_current != NULL) {

    object = s_current->selected_object;

    if (!object) {
      fprintf(stderr, _("ERROR: NULL object in o_mirror!\n"));
      return;
    }

    g_list_free(other_objects);
    other_objects = NULL;
    g_list_free(connected_objects);
    connected_objects = NULL;

    switch (object->type) {


    case (OBJ_NET):
      o_cue_undraw(w_current, object);
      o_net_erase(w_current, object);
      o_line_erase_grips(w_current, object);

      other_objects = s_conn_return_others(other_objects, object);
      s_conn_remove(w_current, object);

      o_net_mirror(w_current, centerx, centery, object);
      s_conn_update_object(w_current, object);
      o_net_draw(w_current, object);

      /* draw the other objects */
      o_cue_undraw_list(w_current, other_objects);
      o_cue_draw_list(w_current, other_objects);

      /* get other connected objects and redraw */
      connected_objects = s_conn_return_others(connected_objects, object);
      o_cue_undraw_list(w_current, connected_objects);
      o_cue_draw_list(w_current, connected_objects);

      /* finally redraw the cues on the current object */
      o_cue_draw_single(w_current, object);
      break;

    case (OBJ_PIN):
      o_cue_undraw(w_current, object);
      o_pin_erase(w_current, object);
      o_line_erase_grips(w_current, object);

      other_objects = s_conn_return_others(other_objects, object);
      s_conn_remove(w_current, object);

      o_pin_mirror(w_current, centerx, centery, object);
      s_conn_update_object(w_current, object);
      o_pin_draw(w_current, object);

      /* draw the other objects */
      o_cue_undraw_list(w_current, other_objects);
      o_cue_draw_list(w_current, other_objects);

      /* get other connected objects and redraw */
      connected_objects = s_conn_return_others(connected_objects, object);
      o_cue_undraw_list(w_current, connected_objects);
      o_cue_draw_list(w_current, connected_objects);

      /* finally redraw the cues on the current object */
      o_cue_draw_single(w_current, object);
      break;

    case (OBJ_BUS):
      o_bus_erase(w_current, object);
      o_line_erase_grips(w_current, object);

      other_objects = s_conn_return_others(other_objects, object);
      s_conn_remove(w_current, object);

      o_bus_mirror(w_current, centerx, centery, object);
      s_conn_update_object(w_current, object);
      o_bus_draw(w_current, object);

      /* draw the other objects */
      o_cue_undraw_list(w_current, other_objects);
      o_cue_draw_list(w_current, other_objects);

      /* get other connected objects and redraw */
      connected_objects = s_conn_return_others(connected_objects, object);
      o_cue_undraw_list(w_current, connected_objects);
      o_cue_draw_list(w_current, connected_objects);

      /* finally redraw the cues on the current object */
      o_cue_draw_single(w_current, object);
      break;

    case (OBJ_COMPLEX):
      o_cue_undraw_objects(w_current, object->complex->prim_objs);
      /* erase the current selection */
      o_complex_erase(w_current, object);

      other_objects = s_conn_return_complex_others(other_objects, object);

      /* remove all conn references */
      o_current = object->complex->prim_objs;
      while (o_current != NULL) {
	s_conn_remove(w_current, o_current);
	o_current = o_current->next;
      }

      o_complex_mirror(w_current, centerx, centery, object);
      s_conn_update_complex(w_current, object->complex->prim_objs);
      o_complex_draw(w_current, object);

      o_cue_undraw_list(w_current, other_objects);
      o_cue_draw_list(w_current, other_objects);

      /* now draw the newly connected objects */
      connected_objects = s_conn_return_complex_others(connected_objects,
						       object);
      o_cue_undraw_list(w_current, connected_objects);
      o_cue_draw_list(w_current, connected_objects);
      break;

    case (OBJ_LINE):
      o_line_erase_grips(w_current, object);
      o_line_erase(w_current, object);
      o_line_mirror(w_current, centerx, centery, object);
      o_line_draw(w_current, object);
      break;

    case (OBJ_BOX):
      o_box_erase_grips(w_current, object);
      o_box_erase(w_current, object);
      o_box_mirror(w_current, centerx, centery, object);
      o_box_draw(w_current, object);
      break;

    case (OBJ_CIRCLE):
      o_circle_erase_grips(w_current, object);
      o_circle_erase(w_current, object);
      o_circle_mirror(w_current, centerx, centery, object);
      o_circle_draw(w_current, object);
      break;

    case (OBJ_ARC):
      o_arc_erase(w_current, object);
#if 0				/* not needed anymore */
      SCREENtoWORLD(w_current, centerx, centery,
		    &world_centerx, &world_centery);
#endif
      o_arc_mirror(w_current, centerx, centery, object);
      o_arc_draw(w_current, object);
      break;

    case (OBJ_TEXT):
      o_text_erase(w_current, object);
      o_text_mirror(w_current, centerx, centery, object);
      o_text_draw(w_current, object);
      break;

    }

    s_current = s_current->next;

  }

  w_current->page_current->CHANGED = 1;
  o_undo_savestate(w_current, UNDO_ALL);
}


#line 808 "../noweb/o_misc.nw"
void o_edit_show_hidden_lowlevel(TOPLEVEL * w_current, OBJECT * o_list)
{
  OBJECT *o_current = o_list;

  if (o_current == NULL) {
    return;
  }

  while (o_current != NULL) {
    if (o_current->type == OBJ_TEXT && o_current->visibility == INVISIBLE) {

      /* don't toggle the visibility flag */

      if (w_current->show_hidden_text) {
	/* draw the text object if it hidden  */
	if (o_current->text->prim_objs == NULL) {
	  o_text_recreate(w_current, o_current);
	}
	o_text_recalc(w_current, o_current);
	o_text_draw(w_current, o_current);
      } else {
	/* object is hidden and we are now NOT drawing it, so */
	/* get rid of the extra primitive data */
	o_text_recreate(w_current, o_current);
	o_text_recalc(w_current, o_current);
	/* unfortunately, you cannot erase the old visible text here */
	/* because o_text_draw will just return */
      }
    }

    if (o_current->type == OBJ_COMPLEX) {
      o_edit_show_hidden_lowlevel(w_current,
				  o_current->complex->prim_objs);
      o_complex_recalc(w_current, o_current);
    }

    o_current = o_current->next;
  }
}

#line 857 "../noweb/o_misc.nw"
void o_edit_show_hidden(TOPLEVEL * w_current, OBJECT * o_list)
{
  /* this function just shows the hidden text, but doesn't toggle it */
  /* this function does not change the CHANGED bit, no real changes are */
  /* made to the schematic */

  /* toggle show_hidden_text variable, which when it is true */
  /* means that hidden text IS drawn */
  w_current->show_hidden_text = !w_current->show_hidden_text;
  i_show_state(w_current, NULL);	/* update screen status */

  o_edit_show_hidden_lowlevel(w_current, o_list);
  o_redraw_all_fast(w_current);

  if (w_current->show_hidden_text) {
    s_log_message(_("Hidden text is now visible\n"));
  } else {
    s_log_message(_("Hidden text is now invisible\n"));
  }
}


#line 889 "../noweb/o_misc.nw"
void o_edit_make_visible(TOPLEVEL * w_current, OBJECT * o_list)
{
  /* this function actually changes the visibility flag */
  OBJECT *o_current = NULL;

  if (o_list == NULL)
    return;
  o_current = o_list;

  while (o_current != NULL) {

    if (o_current->type == OBJ_TEXT) {
      if (o_current->visibility == INVISIBLE) {
	o_current->visibility = VISIBLE;

	if (o_current->text->prim_objs == NULL) {
	  o_text_recreate(w_current, o_current);
	}

	o_text_draw(w_current, o_current);

	w_current->page_current->CHANGED = 1;
      }
    }
    o_current = o_current->next;
  }
  o_undo_savestate(w_current, UNDO_ALL);

}

#line 928 "../noweb/o_misc.nw"
#define FIND_WINDOW_HALF_SIZE (5000)

OBJECT *last_o = NULL;
int skiplast;

int o_edit_find_text(TOPLEVEL * w_current, OBJECT * o_list, char *stext,
		     int descend, int skip)
{

  char *attrib = NULL;
  int count = 0;
  PAGE *parent = NULL;
  char *current_filename = NULL;
  int page_control = 0;
  int pcount = 0;
  int rv;
  int text_screen_height;

  OBJECT *o_current = NULL;

  skiplast = skip;
  o_current = o_list;

  if (o_current == NULL) {
    return 1;
  }

  while (o_current != NULL) {

    if (descend) {
      if (o_current->type == OBJ_COMPLEX) {
	parent = w_current->page_current;
	attrib = o_attrib_search_name_single_count(o_current,
						   "source", count);

	/* if above is null, then look inside symbol */
	if (attrib == NULL) {
	  attrib = o_attrib_search_name(o_current->
					complex->
					prim_objs, "source", count);
	  /*          looking_inside = TRUE; */
	}

	if (attrib) {
	  pcount = 0;
	  current_filename = u_basic_breakup_string(attrib, ',', pcount);
	  if (current_filename != NULL) {
	    page_control =
		s_hierarchy_down_schematic_single(w_current,
						  current_filename,
						  parent,
						  page_control,
						  HIERARCHY_NORMAL_LOAD);
	    /* o_redraw_all(w_current); */

	    rv = o_edit_find_text(w_current,
				  w_current->page_current->object_head,
				  stext, descend, skiplast);
	    if (!rv) {
	      return 0;
	    }
	    s_hierarchy_up(w_current, w_current->page_current->up);
	  }
	}
      }
    }

    if (o_current->type == OBJ_TEXT) {
      /* replaced strcmp with strstr to simplify the search */
      if (strstr(o_current->text->string, stext)) {
	/*            printf(_("Found %s\n"), stext);
	   if (!o_current->selected&&(!descend)) {
	   o_selection_add(w_current->page_current->selection2_head,
	   o_current);
	   } */
	if (!skiplast) {

#if 0				/* replaced by code below by avh, might not quite be right though */
	  set_window(w_current, o_current->text->x - FIND_WINDOW_HALF_SIZE,
		     o_current->text->x + FIND_WINDOW_HALF_SIZE,
		     o_current->text->y - FIND_WINDOW_HALF_SIZE,
		     o_current->text->y + FIND_WINDOW_HALF_SIZE);
	  correct_aspect(w_current);

#endif
	  a_zoom(w_current, ZOOM_FULL, HOTKEY, A_PAN_DONT_REDRAW);
	  text_screen_height = SCREENabs(w_current,
					 o_text_height(o_current->
						       text->string,
						       o_current->
						       text->size));
	  /* this code will zoom/pan till the text screen height is about */
	  /* 50 pixels high, perhaps a future enhancement will be to make */
	  /* this number configurable */
	  while (text_screen_height < 50) {
	    a_zoom(w_current, ZOOM_IN, HOTKEY, A_PAN_DONT_REDRAW);
	    a_pan_general(w_current, o_current->text->x,
			  o_current->text->y, 1, A_PAN_DONT_REDRAW);
	    text_screen_height =
		SCREENabs(w_current,
			  o_text_height(o_current->text->string,
					o_current->text->size));
	  }
	  x_scrollbars_update(w_current);
	  o_redraw_all_fast(w_current);

	  last_o = o_current;
	  break;
	}
	if (last_o == o_current) {
	  skiplast = 0;
	}

      }
    }
    o_current = o_current->next;

    if (o_current == NULL) {
      return 1;
    }
  }
  return (o_current == NULL);
}

#line 1062 "../noweb/o_misc.nw"
int current_max;
int used_count;
int used_list[4096];
void find_max(TOPLEVEL * w_current, OBJECT * o_list, char *stext)
{

  OBJECT *o_current = NULL;
  char *attrib = NULL;
  int count = 0;
  PAGE *parent = NULL;
  char *current_filename = NULL;
  int page_control = 0;
  int pcount = 0;

  int l, m;


  if (o_list == NULL)
    return;

  o_current = o_list;

  while (o_current != NULL) {


    if (o_current->type == OBJ_COMPLEX) {

      parent = w_current->page_current;
      attrib = o_attrib_search_name_single_count(o_current,
						 "source", count);

      /* if above is null, then look inside symbol */
      if (attrib == NULL) {
	attrib = o_attrib_search_name(o_current->
				      complex->prim_objs, "source", count);
	/*            looking_inside = TRUE; */
      }

      if (attrib) {
	pcount = 0;
	current_filename = u_basic_breakup_string(attrib, ',', pcount);
	if (current_filename != NULL) {
	  page_control =
	      s_hierarchy_down_schematic_single(w_current,
						current_filename,
						parent,
						page_control,
						HIERARCHY_NORMAL_LOAD);

	  find_max(w_current, w_current->page_current->object_head, stext);
	  s_hierarchy_up(w_current, w_current->page_current->up);
	}
      }
    }
    if (o_current->type == OBJ_TEXT) {
      if ((l = strlen(o_current->text->string) - strlen(stext)) > 0) {
	if (!strncmp(stext, o_current->text->string, strlen(stext))) {
	  if (isdigit(o_current->text->string[strlen(stext)])) {
	    sscanf(o_current->text->string + strlen(stext), "%d", &m);
	    if (used_count < 4094) {
	      used_list[used_count++] = m;
	    }
	    if (m > current_max) {
	      current_max = m;
	    }
	    /*            printf("%d %d\n", m, max); */
	  }
	}
      }
    }
    o_current = o_current->next;
  }
}

#line 1145 "../noweb/o_misc.nw"
void autonumber_text(TOPLEVEL * w_current, OBJECT * o_list, char *stext)
{
  OBJECT *o_current = NULL;
  char *attrib = NULL;
  int count = 0;
  PAGE *parent = NULL;
  char *current_filename = NULL;
  int page_control = 0;
  int pcount = 0;

  unsigned char *ss;
  int l;

  o_current = o_list;
  while (o_current != NULL) {


    if (o_current->type == OBJ_COMPLEX) {

      parent = w_current->page_current;
      attrib = o_attrib_search_name_single_count(o_current,
						 "source", count);

      /* if above is null, then look inside symbol */
      if (attrib == NULL) {
	attrib = o_attrib_search_name(o_current->
				      complex->prim_objs, "source", count);
	/*            looking_inside = TRUE; */
      }

      if (attrib) {
	pcount = 0;
	current_filename = u_basic_breakup_string(attrib, ',', pcount);
	if (current_filename != NULL) {
	  page_control =
	      s_hierarchy_down_schematic_single(w_current,
						current_filename,
						parent,
						page_control,
						HIERARCHY_NORMAL_LOAD);
	  /*o_redraw_all(w_current); */
	  autonumber_text(w_current, w_current->page_current->object_head,
			  stext);

	  s_hierarchy_up(w_current, w_current->page_current->up);

	}
      }
    }

    if (o_current->type == OBJ_TEXT) {
      if ((l = strlen(o_current->text->string) - strlen(stext)) > 0) {
	if (!strncmp(stext, o_current->text->string, strlen(stext))) {
	  /* printf("%s %d\n", o_current->text->string, (unsigned char) o_current->text->string[strlen(stext)]); */
	  if (o_current->text->string[strlen(stext)] == '?') {
	    free(o_current->text->string);

	    while (current_max > used_list[used_count]) {
	      used_count++;
	    }
	    while (current_max == used_list[used_count]) {
	      current_max++;
	      used_count++;
	    }

	    ss = g_strdup_printf("%s%d", stext, current_max++);
	    /*            printf("%s\n", ss); */
	    o_current->text->string =
		(char *) malloc(sizeof(char) * (strlen(ss) + 1));
	    strcpy(o_current->text->string, ss);
	    free(ss);
	    o_text_erase(w_current, o_current);
	    o_text_recreate(w_current, o_current);
	    o_text_draw(w_current, o_current);
	    w_current->page_current->CHANGED = 1;
	  }


	}
      }
    }
    o_current = o_current->next;
  }
  o_undo_savestate(w_current, UNDO_ALL);
}

#line 1241 "../noweb/o_misc.nw"
void
o_edit_autonumber_text(TOPLEVEL * w_current, OBJECT * o_list, char *stext)
{
  int i, tmp, sorted = 0;
  int current_max = 0;		/* AVH 8/18/2002 changed to 0, so 1 would be used */
  int used_count = 0;

  find_max(w_current, o_list, stext);

  if ((used_count < 4094) && (used_count > 0)) {
    while (!sorted) {
      sorted = 1;
      for (i = 0; i < used_count - 1; i++) {
	if (used_list[i] > used_list[i + 1]) {
	  sorted = 0;
	  tmp = used_list[i];
	  used_list[i] = used_list[i + 1];
	  used_list[i + 1] = tmp;
	}
	if (used_list[i] == used_list[i + 1]) {
	  printf(_("Warning: two components with same refdes: %d\n"),
		 used_list[i]);
	}
      }
    }
    current_max = 1;
  } else {
    used_list[0] = current_max;
    used_count = 1;
  }
  used_list[used_count] = 1000000;
  used_count = 0;

  /*    printf("max: %d\n", current_max); */
  autonumber_text(w_current, o_list, stext);
  o_redraw_all(w_current);

}

#line 1288 "../noweb/o_misc.nw"
void
o_edit_hide_specific_text(TOPLEVEL * w_current, OBJECT * o_list,
			  char *stext)
{
  OBJECT *o_current = NULL;

  if (o_list == NULL)
    return;

  o_current = o_list;

  while (o_current != NULL) {

    if (o_current->type == OBJ_TEXT) {
      if (!strncmp(stext, o_current->text->string, strlen(stext))) {
	if (o_current->visibility == VISIBLE) {
	  o_current->visibility = INVISIBLE;

	  if (o_current->text->prim_objs == NULL) {
	    o_text_recreate(w_current, o_current);
	  }
	  w_current->page_current->CHANGED = 1;
	}
      }
    }
    o_current = o_current->next;
  }
  o_undo_savestate(w_current, UNDO_ALL);
  o_redraw_all(w_current);
}

#line 1329 "../noweb/o_misc.nw"
void
o_edit_show_specific_text(TOPLEVEL * w_current, OBJECT * o_list,
			  char *stext)
{
  OBJECT *o_current = NULL;

  if (o_list == NULL)
    return;

  o_current = o_list;

  while (o_current != NULL) {

    if (o_current->type == OBJ_TEXT) {
      if (!strncmp(stext, o_current->text->string, strlen(stext))) {
	if (o_current->visibility == INVISIBLE) {
	  o_current->visibility = VISIBLE;

	  if (o_current->text->prim_objs == NULL) {
	    o_text_recreate(w_current, o_current);
	  }
	  o_text_draw(w_current, o_current);
	  w_current->page_current->CHANGED = 1;
	}
      }
    }
    o_current = o_current->next;
  }
  o_undo_savestate(w_current, UNDO_ALL);
}

#line 1368 "../noweb/o_misc.nw"
void o_update_component(TOPLEVEL * w_current, SELECTION * list)
{
  OBJECT *o_current;
  OBJECT *new_object;
  OBJECT *o_temp;
  SELECTION *temp_list = NULL;
  SELECTION *s_current;
  ATTRIB *attrib_tail;
  GList *object_list = NULL;
  GList *new_objects = NULL;
  GList *connected_objects = NULL;
  int i, temp, new_angle;
  int x, y, angle, mirror, was_embedded = FALSE;
  char *complex_clib;
  char *complex_basename;
  char *new_clib;
  char *new_basename;

  if (list == NULL) {
    w_current->inside_action = 0;
    i_set_state(w_current, SELECT);
    return;
  }

  o_current = list->selected_object;
  if (o_current == NULL) {
    fprintf(stderr, _("Got an unexpected NULL in o_update_component\n"));
    exit(-1);
  }
  s_current = list;
  while (s_current != NULL) {
    o_current = s_current->selected_object;

    if (o_current && o_current->type == OBJ_COMPLEX) {
      object_list = g_list_append(object_list, o_current);
    }
    s_current = s_current->next;
  }
  o_select_unselect_all(w_current);

  temp_list = o_selection_new_head();
  while (object_list != NULL) {

    o_current = (OBJECT *) object_list->data;

    if (strncmp(o_current->complex_clib, "EMBEDDED", 8) == 0) {

      new_basename = (char *) malloc(sizeof(char) *
				     (strlen(o_current->complex_basename) +
				      1));

      /* skip over EMBEDDED word */
      sprintf(new_basename, "%s", (o_current->complex_basename + 8));

      new_clib = (char *) s_clib_search(new_basename);

      if (!new_clib) {
	s_log_message
	    ("Could not unembedded component, could not find appropriate .sym file\n");
	s_log_message("Component still embedded and not updated\n");
	return;
      }

      free(o_current->complex_clib);
      free(o_current->complex_basename);
      o_current->complex_clib = new_clib;
      o_current->complex_basename = new_basename;

      was_embedded = TRUE;
    }

    x = o_current->complex->x;
    y = o_current->complex->y;
    angle = o_current->complex->angle;
    mirror = o_current->complex->mirror;

    complex_clib = u_basic_strdup(o_current->complex_clib);
    complex_basename = u_basic_strdup(o_current->complex_basename);

    o_temp = w_current->page_current->object_tail;
    new_object = w_current->page_current->object_tail =
	o_complex_add(w_current,
		      w_current->page_current->object_tail,
		      OBJ_COMPLEX,
		      WHITE, x, y, angle, mirror,
		      complex_clib, complex_basename, 1, TRUE);
    w_current->page_current->object_tail =
	return_tail(w_current->page_current->object_tail);

    free(complex_clib);
    free(complex_basename);

    /* re-emb the object */
    if (was_embedded) {

      if (new_object->complex_clib) {
	free(new_object->complex_clib);
      }

      new_object->complex_clib = u_basic_strdup("EMBEDDED");
      new_basename = u_basic_strdup_multiple("EMBEDDED",
					     new_object->complex_basename,
					     NULL);
      if (new_object->complex_basename) {
	free(new_object->complex_basename);
      }

      new_object->complex_basename = new_basename;

    }

    /* take those attached attributes and put them on the new object */
    attrib_tail = o_attrib_return_tail(new_object->attribs);
    if (attrib_tail && o_current->attribs && o_current->attribs->next) {
      attrib_tail->next = o_current->attribs->next;
      attrib_tail->next->prev = attrib_tail;
      o_current->attribs->next = NULL;
    }

    /* complex rotate post processing */
    o_temp = o_temp->next;	/* skip over last object */
    while (o_temp != NULL) {
      switch (o_temp->type) {
      case (OBJ_TEXT):
	temp = new_object->complex->angle / 90;
	for (i = 0; i < temp; i++) {
	  new_angle = (o_temp->text->angle + 90) % 360;
	  o_text_rotate(w_current,
			new_object->complex->screen_x,
			new_object->complex->screen_y,
			new_angle, 90, o_temp);
	}
	break;
      }

      o_temp = o_temp->next;
    }


    o_selection_add(temp_list, new_object);
    o_attrib_add_selected(w_current, temp_list, new_object);
    o_attrib_slot_update(w_current, new_object);

    o_delete_complex(w_current, o_current);

    s_conn_update_complex(w_current, new_object->complex->prim_objs);
    new_objects = g_list_append(new_objects, new_object);
    connected_objects = s_conn_return_complex_others(connected_objects,
						     new_object);
    o_redraw_single(w_current, new_object);

    object_list = object_list->next;
  }

  o_selection_destroy_head(w_current->page_current->selection2_head);
  w_current->page_current->selection2_head = temp_list;
  w_current->page_current->selection2_tail =
      o_selection_return_tail(temp_list);

  o_cue_draw_list(w_current, new_objects);
  o_cue_undraw_list(w_current, connected_objects);
  o_cue_draw_list(w_current, connected_objects);

  g_list_free(new_objects);
  g_list_free(connected_objects);

  w_current->page_current->CHANGED = 1;
  o_undo_savestate(w_current, UNDO_ALL);
}
