#line 29 "../noweb/x_log.nw"
/* gEDA - GPL Electronic Design Automation
 * gschem - gEDA Schematic Capture
 * Copyright (C) 1998-2000 Ales V. Hvezda
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */


#line 11 "../noweb/x_log.nw"
/* DO NOT read or edit this file ! Use ../noweb/x_log.nw instead */

/* TODO: STILL NEED to clean up line lengths in aa and tr */

#line 52 "../noweb/x_log.nw"
#include <config.h>

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include <libgeda/libgeda.h>

#include "../include/globals.h"
#include "../include/prototype.h"

#line 79 "../noweb/x_log.nw"
GtkWidget *stwindow = NULL;

#ifdef HAS_GTK22
static GtkTextBuffer *sttextbuf = NULL;
static GtkTextView *sttextview = NULL;
static GtkTextIter startIter, endIter;
static GtkTextMark *endMark;
#else
static GtkWidget *sttext = NULL;
#endif

static char *logfilename;

#line 101 "../noweb/x_log.nw"
void x_log_init(char *cwd, char *filename)
{
  logfilename = u_basic_strdup_multiple(cwd, PATH_SEPARATER_STRING,
					filename, NULL);
}


#line 118 "../noweb/x_log.nw"
void x_log_read(void)
{
  char buf[200];		/* increased size to make multibyte character sets happy */
  int tmp_fd;
  int len;


  if (do_logging == FALSE) {
    return;
  }

  tmp_fd = open(logfilename, O_RDONLY, 0600);

  if (tmp_fd == -1) {
    do_logging = FALSE;
    return;
  }

  while ((len = read(tmp_fd, &buf, 198)) != 0) {
    /* not sure if this nukes the last char or not... */
    buf[len] = '\0';		/* null terminate the buffer */
#ifdef HAS_GTK22
    gtk_text_buffer_insert_at_cursor(sttextbuf, buf, len);
#else
    gtk_text_insert(GTK_TEXT(sttext), NULL, NULL, NULL, buf, len);
#endif
  }

  close(tmp_fd);
}


#line 162 "../noweb/x_log.nw"
void x_log_update(char *buf)
{
  int nchars;

  if (do_logging == FALSE) {
    return;
  }

  if (buf == NULL) {
    return;
  }

  switch (logging_dest) {
  case (LOG_WINDOW):
    if (!stwindow) {
      return;
    }

    nchars = strlen(buf);
#ifdef HAS_GTK22
    gtk_text_buffer_insert_at_cursor(sttextbuf, buf, nchars);
    gtk_text_view_scroll_mark_onscreen(sttextview, endMark);
#else
    gtk_text_insert(GTK_TEXT(sttext), NULL, NULL, NULL, buf, nchars);
#endif
    break;

  case (STDOUT_TTY):
    fputs(buf, stdout);
    break;

  case (BOTH):
    fputs(buf, stdout);

    if (!stwindow) {
      break;
    }

    nchars = strlen(buf);
#if HAS_GTK22
    gtk_text_buffer_insert_at_cursor(sttextbuf, buf, nchars);
    gtk_text_view_scroll_mark_onscreen(sttextview, endMark);
#else
    gtk_text_insert(GTK_TEXT(sttext), NULL, NULL, NULL, buf, nchars);
#endif
    break;
  }
}


#line 226 "../noweb/x_log.nw"
void x_log_close(GtkWidget * w, TOPLEVEL * w_current)
{
  gtk_widget_destroy(stwindow);
  stwindow = NULL;


#if 0
  gtk_grab_remove(w_current->stwindow);
#endif
}


#line 248 "../noweb/x_log.nw"
void x_log_free(void)
{
  free(logfilename);
  logfilename = NULL;
}


#line 265 "../noweb/x_log.nw"
int
x_log_keypress(GtkWidget * widget, GdkEventKey * event,
	       TOPLEVEL * w_current)
{
  if (strcmp(gdk_keyval_name(event->keyval), "Escape") == 0) {
    x_log_close(NULL, w_current);
    return TRUE;
  }

  return FALSE;
}


#line 287 "../noweb/x_log.nw"
void x_log_setup_win(TOPLEVEL * w_current)
{
  GtkWidget *buttoncancel = NULL;
#ifdef HAS_GTK12
  GtkWidget *hscrollbar = NULL;
  GtkWidget *vscrollbar = NULL;
#endif
  GtkWidget *table = NULL;
  GtkWidget *vbox, *action_area, *hbuttonbox1;
#ifdef HAS_GTK22
  GtkWidget *viewport1;
  GtkWidget *textView;
  GtkWidget *scrolledWin;
  GtkScrolledWindow *swin;
#endif

  if (do_logging == FALSE) {
    return;
  }


  if (!stwindow) {

    stwindow = x_create_dialog_box(&vbox, &action_area);

    /* comment this out if you want the log window to have
     * wm decorations */
    if (w_current->log_window_type == TRANSIENT) {
      gtk_window_set_transient_for(GTK_WINDOW(stwindow),
				   GTK_WINDOW(w_current->main_window));
      gtk_window_position(GTK_WINDOW(stwindow), GTK_WIN_POS_MOUSE);
    } else {
      gtk_window_position(GTK_WINDOW(stwindow), GTK_WIN_POS_NONE);
    }

    gtk_widget_set_usize(stwindow, 600, 200);

    gtk_signal_connect(GTK_OBJECT(stwindow),
		       "destroy", GTK_SIGNAL_FUNC(destroy_window),
		       &stwindow);

#if 0				/* this was causing the dialog box to not die */
    gtk_signal_connect(GTK_OBJECT(stwindow),
		       "delete_event",
		       GTK_SIGNAL_FUNC(destroy_window), &stwindow);
#endif

    gtk_window_set_title(GTK_WINDOW(stwindow), _("Status"));
    gtk_container_border_width(GTK_CONTAINER(stwindow), 5);

    table = gtk_table_new(2, 2, FALSE);
    gtk_table_set_row_spacing(GTK_TABLE(table), 0, 2);
    gtk_table_set_col_spacing(GTK_TABLE(table), 0, 2);
    gtk_box_pack_start(GTK_BOX(vbox), table, TRUE, TRUE, 5);
    gtk_widget_show(table);

#ifdef HAS_GTK22
    sttextbuf = gtk_text_buffer_new(gtk_text_tag_table_new());
    textView = gtk_text_view_new_with_buffer(sttextbuf);
    sttextview = GTK_TEXT_VIEW(textView);
    gtk_text_view_set_editable(sttextview, FALSE);

    scrolledWin = gtk_scrolled_window_new(sttextview->hadjustment,
					  sttextview->vadjustment);
    swin = GTK_SCROLLED_WINDOW(scrolledWin);
    gtk_scrolled_window_set_policy(swin, GTK_POLICY_AUTOMATIC,
				   GTK_POLICY_AUTOMATIC);

    viewport1 = gtk_viewport_new(NULL, NULL);
    gtk_widget_show(viewport1);
    gtk_container_add(GTK_CONTAINER(viewport1), scrolledWin);
#else
    sttext = gtk_text_new(NULL, NULL);
    gtk_text_set_editable(GTK_TEXT(sttext), FALSE);
#endif

#ifdef HAS_GTK22
    gtk_table_attach(GTK_TABLE(table), GTK_WIDGET(viewport1),
#else
    gtk_table_attach(GTK_TABLE(table), sttext,
#endif
		     0, 1, 0, 1,
		     GTK_EXPAND | GTK_SHRINK | GTK_FILL,
		     GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
#ifdef HAS_GTK22
    gtk_container_add(GTK_CONTAINER(swin), GTK_WIDGET(sttextview));
    gtk_widget_show(GTK_WIDGET(swin));
    gtk_widget_show(GTK_WIDGET(sttextview));
#else
    gtk_widget_show(sttext);
#endif

#ifdef HAS_GTK12
    hscrollbar = gtk_hscrollbar_new(GTK_TEXT(sttext)->hadj);
    gtk_table_attach(GTK_TABLE(table), hscrollbar, 0, 1, 1, 2,
		     GTK_EXPAND | GTK_FILL | GTK_SHRINK, GTK_FILL, 0, 0);
    gtk_widget_show(hscrollbar);

    vscrollbar = gtk_vscrollbar_new(GTK_TEXT(sttext)->vadj);
    gtk_table_attach(GTK_TABLE(table), vscrollbar, 1, 2, 0, 1,
		     GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
    gtk_widget_show(vscrollbar);
#endif

    hbuttonbox1 = gtk_hbutton_box_new();
    gtk_widget_show(hbuttonbox1);
    gtk_button_box_set_layout(GTK_BUTTON_BOX(hbuttonbox1),
			      GTK_BUTTONBOX_END);
    gtk_box_pack_start(GTK_BOX(action_area), hbuttonbox1, TRUE, TRUE, 0);

    buttoncancel = gtk_button_new_with_label(_("Close"));
    gtk_container_add(GTK_CONTAINER(hbuttonbox1), buttoncancel);
    GTK_WIDGET_SET_FLAGS(buttoncancel, GTK_CAN_DEFAULT);
#if 0
    gtk_box_pack_start(GTK_BOX(action_area),
		       buttoncancel, FALSE, FALSE, 0);
#endif
    gtk_signal_connect(GTK_OBJECT(buttoncancel), "clicked",
		       GTK_SIGNAL_FUNC(x_log_close), NULL);
    gtk_widget_show(buttoncancel);

    gtk_signal_connect(GTK_OBJECT(stwindow), "key_press_event",
		       (GtkSignalFunc) x_log_keypress, w_current);
  }

  if (!GTK_WIDGET_VISIBLE(stwindow)) {
    gtk_widget_show(stwindow);
    x_log_read();		/* update the contents of the log */
  } else {
    gdk_window_raise(stwindow->window);
  }

#ifdef HAS_GTK22
  gtk_text_buffer_get_bounds(sttextbuf, &startIter, &endIter);
  endMark = gtk_text_buffer_create_mark(sttextbuf, NULL, &endIter, FALSE);
  gtk_text_view_scroll_mark_onscreen(sttextview, endMark);
#endif

}
