Name:    genders 
Version: 1.13
Release: 1
Summary: Static cluster configuration database.
Group: System Environment/Base
License: GPL
Source: %{name}-%{version}.tar.gz
Requires: perl
BuildRequires: bison flex
BuildRoot: %{_tmppath}/%{name}-%{version}

%description
Genders is a static cluster configuration database used for cluster
configuration management.  It is used by a variety of tools and
scripts for management of large clusters.  The genders database is
typically replicated on every node of the cluster. It describes the
layout and configuration of the cluster so that tools and scripts can
sense the variations of cluster nodes. By abstracting this information
into a plain text file, it becomes possible to change the
configuration of a cluster by modifying only one file.

%package compat
Summary: compatability library 
Group: System Environment/Base
%description compat
genders API that is compatible with earlier releases of genders

%{!?_with_perl_extensions: %{!?_without_perl_extensions: %define _with_perl_extensions --with-perl-extensions}}

%prep
%setup  -q -n %{name}-%{version}

%build
%configure --program-prefix=%{?_program_prefix:%{_program_prefix}} \
    --with-perl-destdir="$RPM_BUILD_ROOT" \
    %{?_with_perl_extensions} \
    %{?_without_perl_extensions}
make 

%install
rm -rf $RPM_BUILD_ROOT
DESTDIR="$RPM_BUILD_ROOT" make install 

%files
%defattr(-,root,root)
%doc README NEWS ChangeLog DISCLAIMER DISCLAIMER.UC COPYING TUTORIAL genders.sample
# It doesn't matter if the user chooses a 32bit or 64bit target.  The
# packaging must work off whatever Perl is installed.  
%define _perldir %(perl -e 'use Config; $T=$Config{installsitearch}; $T=~/(.*)\\/site_perl.*/; print $1;')
%{_mandir}/man1/*
%{_mandir}/man3/genders*
%{_mandir}/man3/libgenders* 
%{_includedir}/*
%{_bindir}/*
%{_libdir}/libgenders.*
%if %{?_with_perl_extensions:1}%{!?_with_perl_extensions:0}
%{_mandir}/man3/Libgenders*
%{_mandir}/man3/Genders*
%{_perldir}/*
%endif

%files compat
%defattr(-,root,root)
%{_mandir}/man3/gendlib*
%{_prefix}/lib/genders/*


