// genesis

/**********************************************************************
**
**	DO NOT EDIT THIS FILE IN THE neurokit DIRECTORY!
**
**	Make a copy of this file in every directory that contains .p
**	files and edit the copies, in order to customize neurokit for
**	different simulations. When you run neurokit from other
**	directories, the simulator will look for the local version of
**	userprefs.g, and if it cannot find it there will look for the
**	default in the neurokit directory. This version of userprefs is
**	set up to run the Coarse Asymmetric Mitral cell demo.
**	
**	There are three aspects to customisation :
**	
**	1	Include the appropriate script files from the /neuron/prototype
**		directory and from wherever you have defined new prototype
**		elements.
**
**	2	Invoke the functions that make the prototypes you want for
**		your simulation.
**
**	3	Put your preferences for the user_variables defined in
** 		defaults.g in the copies of this file.
**
**********************************************************************/

echo Using local user preferences

/**********************************************************************
**
**	1	Including script files for prototype functions
**
**********************************************************************/

/* file for standard compartments */
include compartments

/* file for Fox, Nowycky and Tsien's channels */
include FNTchan.g


/**********************************************************************
**
**	2	Invoking functions to make prototypes in the /library element
**
**********************************************************************/

	/* To ensure that all subsequent elements are made in the library */
	ce /library



	/* These make the standard types of compartments that can be
	**	invoked in .p files */
	make_cylind_compartment			/* makes "compartment" */
	make_sphere_compartment			/* makes "compartment_sphere" */
	make_cylind_symcompartment		/* makes "symcompartment" */
	make_sphere_symcompartment		/* makes "symcompartment_sphere" */

	/* Making Ca channel */
	make_NCa_drg_fnt

	/* returning to the root element */
	ce /


/**********************************************************************
**
**	3	Setting preferences for user-variables.
**
**********************************************************************/

/* See defaults.g for default values of these */
user_cell = "/soma"
user_pfile = "soma.p"
user_name = "Upinder S. Bhalla"
user_inject = 0.01
user_ymin1 = -8.0e-11
user_ymax1 = 8.0e-11
user_xmax1 = 0.15
user_xmax2 = 0.15
user_field1	= "Ik"
user_path1 = "NCa_drg_fnt"
user_numxouts = 2
user_yoffset1  = 0.0
user_yoffset2  = 0.0
