/*
** 1998-08-27 -	I've gotten pretty far without a native command for creating directories,
**		but now is the time. I want one!
** 1998-09-01 -	Added the possibility to enter the newly created directory, something I
**		find I want to do occasionally. Having it here saves one click. :^)
** 1999-03-13 -	Adjusted for new dialog module.
** 1999-04-04 -	Moved "CD New" flag out into min->cfg, making it behave a bit more like
**		the other commands and paving the way for saving this info in config file.
** 1999-06-19 -	Adapted for the new dialog module. Cleaner now.
*/

#include "gentoo.h"
#include "cmd_delete.h"
#include "cmdseq.h"
#include "cmdseq_config.h"
#include "configure.h"
#include "convutil.h"
#include "dialog.h"
#include "dirpane.h"
#include "errors.h"
#include "gfam.h"
#include "overwrite.h"
#include "strutil.h"

#include "cmd_mkdir.h"

#define	CMD_ID	"mkdir"

/* ----------------------------------------------------------------------------------------- */

typedef struct {
	GtkWidget	*vbox;
	GtkWidget	*entry;
	DirPane		*src;
} MkdInfo;

typedef struct {			/* Command-specific configuration data. */
	gboolean	modified;		/* Has the setting(s) been modified? */
	gboolean	cd_new;			/* CD into new directory after creation? */
	gboolean	focus_new;		/* Focus the new directory? */
} OptMkDir;

static OptMkDir	mkdir_options;
static CmdCfg	*mkdir_cmc = NULL;

/* ----------------------------------------------------------------------------------------- */

/* 1998-08-27 -	This gets called when user closes down the mkdir dialog. Create the
**		dir (and, optionally, enter or focus it).
*/
static void make_dir(MkdInfo *mdi)
{
	MainInfo	*min = mdi->src->main;
	gchar		buf[PATH_MAX], *name;
	const gchar	*text = gtk_entry_get_text(GTK_ENTRY(mdi->entry));
	gboolean	doit = FALSE;
	struct stat	stbuf;
	Conv		conv;

	if(*text == '\0')				/* Avoid attempting to create "". */
		return;
	if(*mdi->src->dir.path == '\0')			/* Don't blow up in strlen() below. */
		return;
	name = conv_begin(&conv, text);
	if(strchr(name, G_DIR_SEPARATOR) != NULL)	/* Also avoid clever paths. */
	{
		conv_end(&conv);
		return;
	}

	/* Build destination directory name, taking care to get a single slash between parts. */
	g_snprintf(buf, sizeof buf, "%s%s%s", mdi->src->dir.path,
			mdi->src->dir.path[strlen(mdi->src->dir.path) - 1] == G_DIR_SEPARATOR ? "" : G_DIR_SEPARATOR_S,
			name);
	ovw_overwrite_begin(min, _("\"%s\" Already Exists - Proceed With MkDir?"), 0UL);
	switch(ovw_overwrite_file(min, buf, NULL))
	{
	case OVW_SKIP:
	case OVW_CANCEL:
		break;
	case OVW_PROCEED:
		doit = TRUE;
		break;
	case OVW_PROCEED_FILE:
		doit = del_delete_file(min, buf);
		break;
	case OVW_PROCEED_DIR:
		doit = FALSE;
	}
	ovw_overwrite_end(min);
	err_clear(min);
	if(doit)
		mkdir(buf, 0755);
	if(lstat(buf, &stbuf) == 0 && S_ISDIR(stbuf.st_mode))
	{
		if(mkdir_options.cd_new)
			csq_execute_format(min, "DirEnter 'dir=%s'", stu_escape(buf));
		else
		{
			dp_rescan(mdi->src);
			csq_execute_format(min, "DpGotoRow focus=%s nocase=no 're=%s'", mkdir_options.focus_new ? "yes" : "no", name);
		}
	}
	else
	{
		err_set(min, errno, CMD_ID, buf);
		err_show(min);
	}
	conv_end(&conv);
	if(mkdir_options.modified)
		cfg_modified_set(min);
}

/* ----------------------------------------------------------------------------------------- */

/* 1998-08-27 -	The mkdir entry point. Simple stuff. */
gint cmd_mkdir(MainInfo *min, DirPane *src, DirPane *dst, const CmdArg *ca)
{
	Dialog		*dlg;
	MkdInfo		mi;
	GtkWidget	*wid;

	mi.src = src;
	mi.vbox = gtk_vbox_new(FALSE, 0);
	wid = gtk_label_new(_("Enter Name of Directory to Create"));
	gtk_box_pack_start(GTK_BOX(mi.vbox), wid, FALSE, FALSE, 0);
	mi.entry = gtk_entry_new_with_max_length(MAXNAMLEN - 1);
	gtk_box_pack_start(GTK_BOX(mi.vbox), mi.entry, FALSE, FALSE, 0);
	wid = cmc_field_build(mkdir_cmc, "cd_new", &mkdir_options);
	gtk_box_pack_start(GTK_BOX(mi.vbox), wid, FALSE, FALSE, 0);
	wid = cmc_field_build(mkdir_cmc, "focus_new", &mkdir_options);
	gtk_box_pack_start(GTK_BOX(mi.vbox), wid, FALSE, FALSE, 0);
	dlg = dlg_dialog_sync_new(mi.vbox, _("Make Directory"), NULL);
	gtk_widget_grab_focus(mi.entry);
	if(dlg_dialog_sync_wait(dlg) == DLG_POSITIVE)
		make_dir(&mi);
	dlg_dialog_sync_destroy(dlg);

	return 1;
}

/* ----------------------------------------------------------------------------------------- */

/* 1999-04-04 -	Support function for dynamic command configuration management (buzz, buzz). */
void cfg_mkdir(MainInfo *min)
{
	if(mkdir_cmc == NULL)
	{
		/* Initialize default option values. */
		mkdir_options.modified	= FALSE;
		mkdir_options.cd_new	= FALSE;
		mkdir_options.focus_new = FALSE;

		mkdir_cmc = cmc_config_new("MkDir", &mkdir_options);
		cmc_field_add_boolean(mkdir_cmc, "modified", NULL, offsetof(OptMkDir, modified));
		cmc_field_add_boolean(mkdir_cmc, "cd_new", _("CD Into New Directory?"), offsetof(OptMkDir, cd_new));
		cmc_field_add_boolean(mkdir_cmc, "focus_new", _("Focus New Directory?"), offsetof(OptMkDir, focus_new));
		cmc_config_register(mkdir_cmc);
	}
}
