/* Gerris - The GNU Flow Solver
 * Copyright (C) 2001 National Institute of Water and Atmospheric Research
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.  
 */

#ifndef __EVENT_H__
#define __EVENT_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "simulation.h"

typedef struct _GfsEvent                GfsEvent;
typedef struct _GfsEventClass           GfsEventClass;

struct _GfsEvent {
  GtsSListContainee parent;

  gdouble t, start, end, step;
  guint i, istart, iend, istep;
  
  guint n;
  gboolean end_event;
};

struct _GfsEventClass {
  GtsSListContaineeClass parent_class;

  gboolean (* event) (GfsEvent * event, GfsSimulation * sim);
};

#define GFS_EVENT(obj)            GTS_OBJECT_CAST (obj,\
					           GfsEvent,\
					           gfs_event_class ())
#define GFS_EVENT_CLASS(klass)    GTS_OBJECT_CLASS_CAST (klass,\
						   GfsEventClass,\
						   gfs_event_class())
#define GFS_IS_EVENT(obj)         (gts_object_is_from_class (obj,\
						   gfs_event_class ()))
     
GfsEventClass * gfs_event_class       (void);
GfsEvent *      gfs_event_new         (GfsEventClass * klass);
void            gfs_event_set         (GfsEvent * e, 
				       gdouble start, 
				       gdouble end, 
				       gdouble step,
				       gint istart, 
				       gint iend, 
				       gint istep);

/* GfsInit: Header */

typedef struct _GfsEvent      GfsInit;
typedef struct _GfsEventClass GfsInitClass;

#define GFS_IS_INIT(obj)         (gts_object_is_from_class (obj,\
						 gfs_init_class ()))

GfsEventClass * gfs_init_class         (void);

/* GfsInitFlowConstant: Header */

typedef struct _GfsInitFlowConstant         GfsInitFlowConstant;

struct _GfsInitFlowConstant {
  /*< private >*/
  GfsEvent parent;

  /*< public >*/
  FttVector u;
};

#define GFS_INIT_FLOW_CONSTANT(obj)            GTS_OBJECT_CAST (obj,\
					       GfsInitFlowConstant,\
					       gfs_init_flow_constant_class ())
#define GFS_IS_INIT_FLOW_CONSTANT(obj)         (gts_object_is_from_class (obj,\
					       gfs_init_flow_constant_class ()))

GfsEventClass * gfs_init_flow_constant_class  (void);

#ifdef FTT_2D

/* GfsInitVorticity: Header */

typedef struct _GfsInitVorticity         GfsInitVorticity;

struct _GfsInitVorticity {
  /*< private >*/
  GfsInit parent;
};

typedef struct _GfsInitVorticityClass    GfsInitVorticityClass;

struct _GfsInitVorticityClass {
  /*< private >*/
  GfsInitClass parent_class;
};

#define GFS_INIT_VORTICITY(obj)            GTS_OBJECT_CAST (obj,\
					         GfsInitVorticity,\
					         gfs_init_vorticity_class ())
#define GFS_INIT_VORTICITY_CLASS(klass)    GTS_OBJECT_CLASS_CAST (klass,\
						 GfsInitVorticityClass,\
						 gfs_init_vorticity_class())
#define GFS_IS_INIT_VORTICITY(obj)         (gts_object_is_from_class (obj,\
						 gfs_init_vorticity_class ()))

GfsInitVorticityClass * gfs_init_vorticity_class  (void);

#endif /* FTT_2D */

/* GfsEventSum: Header */

typedef struct _GfsEventSum         GfsEventSum;

struct _GfsEventSum {
  GfsEvent parent;

  GfsVariable * v, * sv;
  FttCellTraverseFunc sum;
  gdouble last, dt;
};

#define GFS_EVENT_SUM(obj)            GTS_OBJECT_CAST (obj,\
					         GfsEventSum,\
					         gfs_event_sum_class ())
#define GFS_IS_EVENT_SUM(obj)         (gts_object_is_from_class (obj,\
						 gfs_event_sum_class ()))

GfsEventClass * gfs_event_sum_class  (void);

/* GfsEventSum2: Header */

GfsEventClass * gfs_event_sum2_class (void);

/* GfsInitFraction: Header */

typedef struct _GfsInitFraction         GfsInitFraction;

struct _GfsInitFraction {
  /*< private >*/
  GfsInit parent;

  GfsVariable * c;
  GtsSurface * surface;
  GNode * stree;
  gboolean is_open;
};

typedef struct _GfsInitFractionClass    GfsInitFractionClass;

struct _GfsInitFractionClass {
  /*< private >*/
  GfsInitClass parent_class;

  /*< public >*/
};

#define GFS_INIT_FRACTION(obj)            GTS_OBJECT_CAST (obj,\
					         GfsInitFraction,\
					         gfs_init_fraction_class ())
#define GFS_INIT_FRACTION_CLASS(klass)    GTS_OBJECT_CLASS_CAST (klass,\
						 GfsInitFractionClass,\
						 gfs_init_fraction_class())
#define GFS_IS_INIT_FRACTION(obj)         (gts_object_is_from_class (obj,\
						 gfs_init_fraction_class ()))

GfsInitFractionClass * gfs_init_fraction_class  (void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __EVENT_H__ */
