/* Gerris - The GNU Flow Solver
 * Copyright (C) 2001 National Institute of Water and Atmospheric Research
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.  
 */

#ifndef __TIMESTEP_H__
#define __TIMESTEP_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "advection.h"
#include "poisson.h"

typedef struct _GfsProjectionParams GfsProjectionParams;

struct _GfsProjectionParams {
  gdouble tolerance;
  guint nrelax;
  guint minlevel;
  guint nitermax;

  guint niter;
  GfsNorm residual_before, residual;
};

void          gfs_projection_params_init      (GfsProjectionParams * par);
void          gfs_projection_params_write     (GfsProjectionParams * par, 
					      FILE * fp);
void          gfs_projection_params_read      (GfsProjectionParams * par, 
					       GtsFile * fp);

void          gfs_correct_normal_velocities   (const FttCellFace * face,
					       const GfsAdvectionParams * par);
void          gfs_correct_centered_velocity   (const FttCellFace * face,
					       const GfsAdvectionParams * par);

void          gfs_mac_projection              (GfsDomain * domain,
					       GfsProjectionParams * par,
					       GfsAdvectionParams * apar);
void          gfs_approximate_projection      (GfsDomain * domain,
					       GfsProjectionParams * par,
					       GfsAdvectionParams * apar);
void          gfs_centered_velocity_advection (GfsDomain * domain,
					       GfsAdvectionParams * par);
void          gfs_tracer_advection            (GfsDomain * domain,
					       GfsAdvectionParams * par,
					       GfsVariable * half);
void          gfs_predicted_face_velocities   (GfsDomain * domain,
					       GfsAdvectionParams * par);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __TIMESTEP_H__ */
