#! /bin/sh
# $1: stderr output of poisson
# $2: description (command line used to run poisson)

if test -z "$1"; then
    echo "usage: divfig.sh INPUT DESCRIPTION"
    echo "  INPUT: output of poisson"
    echo "  DESCRIPTION: command line used to run poisson"
    exit 1;
fi

echo "@description \"$2\""

echo "@WITH G0" 
echo "@G0 ON" 
echo "@G0 TYPE logy" 
echo "@XAXIS LABEL \"Iteration\"" 
echo "@xaxis label char size 0.6" 
echo "@xaxis ticklabel char size 0.6" 
echo "@YAXIS LABEL \"Divergence\"" 
echo "@yaxis label char size 0.6" 
echo "@yaxis ticklabel char size 0.6" 
echo "@LEGEND STRING 0 \"first\""
echo "@LEGEND STRING 1 \"second\""
echo "@LEGEND STRING 2 \"infinite\""
echo "@TARGET S0" 
echo "@TYPE xy" 
awk -f divergence.awk < $1 | awk '{print $1 " " $3}' 
echo "&" 
echo "@TARGET S1" 
echo "@TYPE xy" 
awk -f divergence.awk < $1 | awk '{print $1 " " $4}' 
echo "&" 
echo "@TARGET S2" 
echo "@TYPE xy" 
awk -f divergence.awk < $1 | awk '{print $1 " " $5}' 
echo "&" 

echo "@WITH G1" 
echo "@G1 ON" 
echo "@G1 TYPE logy" 
echo "@XAXIS LABEL \"Time\"" 
echo "@xaxis label char size 0.6" 
echo "@xaxis ticklabel char size 0.6" 
echo "@YAXIS LABEL \"Divergence\"" 
echo "@yaxis label char size 0.6" 
echo "@yaxis ticklabel char size 0.6" 
echo "@LEGEND STRING 0 \"first\"" 
echo "@LEGEND STRING 1 \"second\"" 
echo "@LEGEND STRING 2 \"infinite\"" 
echo "@TARGET S0" 
echo "@TYPE xy" 
awk -f divergence.awk < $1 | awk '{print $2 " " $3}' 
echo "&" 
echo "@TARGET S1" 
echo "@TYPE xy" 
awk -f divergence.awk < $1 | awk '{print $2 " " $4}' 
echo "&" 
echo "@TARGET S1" 
echo "@TYPE xy" 
awk -f divergence.awk < $1 | awk '{print $2 " " $5}' 
echo "&" 

echo "@WITH G2" 
echo "@G2 ON" 
echo "@G2 TYPE xy" 
echo "@XAXIS LABEL \"Iteration\"" 
echo "@xaxis label char size 0.6" 
echo "@xaxis ticklabel char size 0.6" 
echo "@YAXIS LABEL \"Convergence rate\"" 
echo "@yaxis label char size 0.6" 
echo "@yaxis ticklabel char size 0.6" 
echo "@LEGEND STRING 0 \"first\"" 
echo "@LEGEND STRING 1 \"second\"" 
echo "@LEGEND STRING 2 \"infinite\"" 
echo "@TARGET S0" 
echo "@TYPE xy" 
awk -f divergence_rate.awk < $1 | awk '{print $1 " " $3}' 
echo "&" 
echo "@TARGET S1" 
echo "@TYPE xy" 
awk -f divergence_rate.awk < $1 | awk '{print $1 " " $4}' 
echo "&" 
echo "@TARGET S2" 
echo "@TYPE xy" 
awk -f divergence_rate.awk < $1 | awk '{print $1 " " $5}' 
echo "&" 

echo "@with g3" 
echo "@g3 on" 
echo "@g3 hidden true"
