% FUNCTION M = gf_model_get(cmd, [, args])
%   Get information from a model object.
% 
%   * b = gf_model_get(mds,'is_complex')
%   Return 0 is the model is real, 1 if it is complex.
% 
%   * T = gf_model_get(mds,'tangent_matrix')
%   Return the tangent matrix stored in the model .
% 
%   * gf_model_get(mds,'rhs')
%   Return the right hand side of the tangent problem.
% 
%   * z = gf_model_get(mds,'memsize')
%   Return a rough approximation of the amount of memory (in bytes) used by the
%   model.
% 
%   * gf_model_get(mds,'listvar')
%   print to the output the list of variables and constants of the model.
% 
%   * gf_model_get(mds,'listbricks')
%   print to the output the list of bricks of the model.
% 
%   * V = gf_model_get(mds,'variable', string name[, int niter])
%   Gives the value of a variable or data.
% 
%   * name = gf_model_get(mds,'mult varname Dirichlet', int ind_brick)
%   Gives the name of the multiplier variable for a Dirichlet brick. If the brick
%   is not a Dirichlet condition with multiplier brick, this function has an
%   undefined behavior
% 
%   * V = gf_model_get(mds,'from_variables')
%   Return the vector of all the degrees of freedom of the model consisting of the
%   concatenation of the variables of the model (usefull to solve your problem
%   with you own solver).
% 
%   * gf_model_get(mds,'solve'[,...])
%   Run the standard getfem solver.  Note that you should be able to use your own
%   solver if you want (it is possible to obtain the tangent matrix and its right
%   hand side with the gf_model_get(mds,'tangent_matrix') etc.).
%   
%     Various options can be specified:
%   
%     - 'noisy' or 'very noisy'
%       the solver will display some information showing the progress
%       (residual values etc.).
%    - 'max_iter', NIT
%       set the maximum iterations numbers.
%    - 'max_res', RES
%       set the target residual value.
%    - 'lsolver', SOLVERNAME
%       select explicitely the solver used for the linear systems (the
%       default value is 'auto', which lets getfem choose itself).
%       Possible values are 'superlu', 'mumps' (if supported),
%       'cg/ildlt', 'gmres/ilu' and 'gmres/ilut'.
% 
%   * V = gf_model_get(mds,'compute isotropic linearized Von Mises or Tresca',
%   string varname, string dataname_lambda, string dataname_mu, MeshFem mf_vm[,
%   string version])
%   Compute the Von-Mises stress or the Tresca stress of a field (only valid for
%   isotropic linearized elasticity in 3D). `version` should be  'Von Mises' or
%   'Tresca' ('Von Mises' is the default).
% 
function [varargout]=gf_model_get(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('model_get',varargin{:});
  else
    gf_matlab('model_get',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
