#ifndef STREAM_H
#define STREAM_H

#include "getstream.h"
#include "sap.h"
#include "libhttp.h"

#include <glib/glist.h>

#include <event.h>

#define RTCP_BUFFER_SIZE	4096

#define RTCP_VERSION_OFF	0
#define RTCP_VERSION_SHIFT	6
#define RTCP_PT_OFF		1
#define	RTCP_VERSION(x)		(x[RTCP_VERSION_OFF]>>RTCP_VERSION_SHIFT)
#define RTCP_PT(x)		(x[RTCP_PT_OFF])

#define RTP_PT_H261		31		/* RFC2032 */
#define RTP_PT_MP2T		33		/* RFC2250 */
#define RTP_PT_RR		201
#define RTP_PT_BYE		203

#define RTP_PT_OFF		1
#define RTP_VERSION_OFF		0
#define RTP_SEQ_OFF		2
#define RTP_TSTAMP_OFF		4
#define RTP_SSRC_OFF		8

#define RTP_MAX_PAYLOAD		1000
#define RTP_HEADROOM		12

#define SOUT_UDP_PAYLOAD_MAX	(1500-40)

enum {
	STYPE_UDP,
	STYPE_RTP,
	STYPE_RTCP,
	STYPE_HTTP,
	STYPE_PIPE
};

#if 0
struct stream_out_rtp_s {
	/* RTCP informations */
	int			rtcpfd;
	struct event		rtcpevent;
	char			*rtcpbuf;
	struct sockaddr		*rtcpsockaddr;
	int			rtcpsockaddrlen;

	/* RTP Informations */
	int			rtpfd;
	struct addrspec		local,
				remote;

	struct rtp_receiver_s	*rcvr;


	int			ttl;

	uint8_t			*buffer;
	int			buffervalid;
};
#endif

struct http_receiver_s {
	struct http_receiver_s	*next;
	struct http_connection	*hc;
	struct stream_s		*stream;
	int			overflow;
};

struct rtp_receiver_s {
	struct rtp_receiver_s	*next;
	char			*addr;
	int			port;
	struct sockaddr_in	sin;
	int			sinlen;
	time_t			lastrr;
	uint32_t		ssrc;
};

struct stream_s	{
	/* Config elements */
	struct stream_s		*next;
	int			type;

	/* UDP & RTP - MCast or UCast */
	char			*remoteaddr;
	int			remoteport;
	int			ttl;

	/* RTCP or HTTP local port or local address */
	char			*localaddr;
	int			localport;

	struct sap_s		*sap;

	/* */
	struct channel_s	*channel;
	int			receiver;		/* No of receivers */
	uint8_t			*buffer;
	int			buffervalid;
	int			sockfd;

	/* RTP/RTCP */
	uint8_t			*rtcpbuffer;
	struct rtp_receiver_s	*rtpreceiver;
	int			rtcpfd;
	uint16_t		rtpseq;
	uint32_t		rtpssrc;
	int			rtpport,
				rtcpport;
	struct event		rtcpevent;

	/* HTTP */
	char			*url;
	GList			*http_receiver;
	struct http_url		*hurl;

	/* PIPE */
	char			*filename;
	int			pipefd;
	time_t			pipelast;
};

int stream_init(struct channel_s *channel);
int stream_init_udp(struct stream_s *stream);
int stream_init_rtp(struct stream_s *stream);
int stream_init_http(struct stream_s *stream);
int stream_init_pipe(struct stream_s *stream);

void stream_send(struct channel_s *c, uint8_t *tsp);
void stream_send_udp(struct stream_s *s, uint8_t *tsp);
void stream_send_rtp(struct stream_s *s, uint8_t *tsp);
void stream_send_http(struct stream_s *s, uint8_t *tsp);
void stream_send_pipe(struct stream_s *s, uint8_t *tsp);

#endif
