.\" @(#)$RCSfile: gfal_access.man,v $ $Revision: 1.1.1.1 $ $Date: 2003/11/19 12:56:29 $ CERN Jean-Philippe Baud
.\" Copyright (C) 2003 by CERN
.\" All rights reserved
.\"
.TH GFAL_ACCESS 3 "$Date: 2003/11/19 12:56:29 $" GFAL "Library Functions"
.SH NAME
gfal_access \- check existence/accessibility of a file/directory
.SH SYNOPSIS
.B #include <unistd.h>
.br
\fB#include "gfal_api.h"\fR
.sp
.BI "int gfal_access (const char *" path ,
.BI "int " amode );
.SH DESCRIPTION
.B gfal_access
checks the existence or the accessibility of the file/directory
.I path
according to the bit pattern in
.I amode
using the real user ID.
.TP
.I path
specifies the file name (this can only be a TURL in the current implementation).
.TP
.I amode
the bit pattern is built by an OR of the constants defined in
.RB < unistd.h >.
.SH RETURN VALUE
This routine returns 0 if the operation was successful or -1 if the operation
failed. In the latter case,
.B errno
is set appropriately.
.SH ERRORS
.TP 1.3i
.B ENOENT
The named file/directory does not exist.
.TP
.B EACCES
Search permission is denied on a component of the
.I path
prefix or specified access to the file itself is denied.
.TP
.B EFAULT
.I path
is a NULL pointer.
.TP
.B ENOTDIR
A component of
.I path
prefix is not a directory.
.TP
.B EINVAL
.I path
has an invalid syntax or
.I amode
is invalid.
.TP
.B ECOMM
Communication error.
.TP
.B EPROTONOSUPPORT
Access method not supported.
.SH SEE ALSO
.B gfal(3)
