#include "parser.h"
#include "printer.h"
#include "polynomial.h"
#include "division.h"
#include "buchberger.h"
#include "wallideal.h"
#include "lp.h"
#include "reversesearch.h"
#include "termorder.h"
#include "ep_standard.h"
#include "ep_xfig.h"
#include "polyhedralcone.h"
#include "gfanapplication.h"
#include "saturation.h"
#include "field_rationals.h"
#include "field_zmodpz.h"

class TestApplication : public GFanApplication
{
  FieldOption theFieldOption;
public:
  bool includeInDefaultInstallation()
  {
    return false;
  }
  const char *helpText()
  {
    return "This\n";
  }
  TestApplication()
  {
    registerOptions();
  }

  char *name()
  {
    return "_test";
  }

  Field test(Field &a)
  {
    return a;
  }

  FieldElement test2()
  {
    FieldZModPZ f(3);
    return f.zHomomorphism(1);
  }

  FieldElement test3(FieldElement &a)
  {
    return a.one();
  }
    
  int main()
  {
    FieldElement a=Q.zHomomorphism(2);
    FieldElement b=Q.zHomomorphism(3);

    FieldElement c=Q.zHomomorphism(3);
    c=a*b;

    Field QQ(Q);
    QQ=Q;
    QQ=QQ;
    QQ=test(Q);
    QQ=test(Q);

    c=c;
    c=test3(c);

    PolynomialRing R=StringParser("Q[a]").parsePolynomialRing();
    //    Term s=StringParser("a").parseTerm(R);

    FieldElement k(R.getField());
    //    k=R.getField().zHomomorphism(1);
    
    /*
{
    {
      FieldElement k(r.getField());
      k=r.getField().zHomomorphism(1);
      Monomial m=parseMonomial(r);
      return Term(k,m);
    }
}

    */


    //    Polynomial s2=s;

    FieldElement e=test2();
    


    AsciiPrinter(Stdout).printFieldElement(e);

    //  fprintf(Stderr,"Number of living FieldImplementations:%i\n",FieldImplementation::getNumberOfLivingFieldImplementations());

    AsciiPrinter(Stdout).printField(e.getField());
    //    AsciiPrinter(Stdout).printFieldElement(c);
    /*    PolynomialSet g=FileParser(Stdin).parsePolynomialSetWithRing();

    AsciiPrinter(Stdout).printPolynomialSet(nonHomogeneousSaturation(g));
    */


    //    Field FF=c.getField();

    return 0;
  }
};

static TestApplication theApplication;

