#ifndef MULTIPLICITY_H_INCLUDED
#define MULTIPLICITY_H_INCLUDED

#include "polynomial.h"
#include "matrix.h"

int multiplicity(PolynomialSet const &g);
/* Computes the multiplicity of a d-dimensional ideal with the d-dimensional homogeneity space. The input must be a marked, reduced Gr\"oebner basis */
int numberOfStandardMonomials(PolynomialSet const &markedGroebnerBasis);



Polynomial multiplicativeChangeInv(Polynomial const &p, IntegerMatrix const &lattice, PolynomialRing const &r2);
PolynomialSet multiplicativeChangeInv(PolynomialSet const &g, IntegerMatrix const &lattice, PolynomialRing const &r2);

#endif
