#include "symmetriccomplex.h"

#include <sstream>
#include "printer.h"

// {ab+aa+cc+dd,ba+ca+db}

bool SymmetricComplex::Cone::isSubsetOf(Cone const &c)const
{
  for(set<int>::const_iterator i=begin();i!=end();i++)
    if(c.count(*i)==0)return false;
  return true;
}


SymmetricComplex::Cone SymmetricComplex::Cone::permuted(IntegerVector const &permutation, SymmetricComplex const &complex)const
{
  Cone ret;
  ret.dimension=dimension;
  ret.multiplicity=multiplicity;
  for(set<int>::const_iterator i=begin();i!=end();i++)
    {
      IntegerVector ny=SymmetryGroup::compose(permutation,complex.vertices[*i]);
      if(complex.indexMap.find(ny)==complex.indexMap.end())
	{
	  AsciiPrinter(Stderr).printVector(complex.vertices[*i]);
	  AsciiPrinter(Stderr).printVector(ny);

	  assert(0);
	}
      ret.insert(complex.indexMap.find(ny)->second);
    }
  return ret;
}


SymmetricComplex::SymmetricComplex(int n_, IntegerVectorList const &v, SymmetryGroup const &sym_):
  n(n_),
  sym(sym_)
{
  vertices=rowsToIntegerMatrix(v,n);
  for(int i=0;i<vertices.getHeight();i++)indexMap[vertices[i]]=i;
}


bool SymmetricComplex::contains(Cone const &c)const
{
  for(SymmetryGroup::ElementContainer::const_iterator k=sym.elements.begin();k!=sym.elements.end();k++)
    {
      Cone c2=c.permuted(*k,*this);
      for(list<Cone>::const_iterator i=cones.begin();i!=cones.end();i++)
	{
	  if(c2==*i)return true;
	}
    }
  return false;
}


void SymmetricComplex::insert(Cone const &c)
{
  if(!contains(c))cones.push_back(c);
}


int SymmetricComplex::getMaxDim()const
{
  int ret=-1;
  for(list<Cone>::const_iterator i=cones.begin();i!=cones.end();i++)
    {
      if(i->dimension>ret)ret=i->dimension;
    }
  return ret;
}


int SymmetricComplex::getMinDim()const
{
  int ret=100000;
  for(list<Cone>::const_iterator i=cones.begin();i!=cones.end();i++)
    {
      if(i->dimension<ret)ret=i->dimension;
    }
  return ret;
}


bool SymmetricComplex::isMaximal(Cone const &c)const
{
  for(SymmetryGroup::ElementContainer::const_iterator k=sym.elements.begin();k!=sym.elements.end();k++)
    {
      Cone c2=c.permuted(*k,*this);
      for(list<Cone>::const_iterator i=cones.begin();i!=cones.end();i++)
	{
	  if(c2.isSubsetOf(*i) && !i->isSubsetOf(c2))return false;
	}
    }
  return true;
}


string SymmetricComplex::toString(int dimLow, int dimHigh, bool onlyMaximal, bool group, ostream *multiplicities)const
{
  stringstream ret;

  for(int d=dimLow;d<=dimHigh;d++)
    {
      bool newDimension=true;
      for(list<Cone>::const_iterator i=cones.begin();i!=cones.end();i++)
	if(!onlyMaximal || isMaximal(*i))
	  {
	    bool isMax=isMaximal(*i);
	    bool newOrbit=true;
	    set<Cone> temp;
	    if(i->dimension==d)
	      for(SymmetryGroup::ElementContainer::const_iterator k=sym.elements.begin();k!=sym.elements.end();k++)
		{
		  temp.insert(i->permuted(*k,*this));
		}
	    for(set<Cone>::const_iterator j=temp.begin();j!=temp.end();j++)
	      {
		ret << "{";
		for(Cone::const_iterator a=j->begin();a!=j->end();a++)
		  {
		    if(a!=j->begin())ret<<" ";
		    ret << *a;
		  }
		ret << "}";
		if(group)if(newOrbit)ret << "\t# New orbit";
		if(newDimension)ret << "\t# Dimension "<<d;
		ret <<endl;
		if(isMax)if(multiplicities)
		  {
		    *multiplicities << i->multiplicity;
		    if(group)if(newOrbit)*multiplicities << "\t# New orbit";
		    if(newDimension)*multiplicities << "\t# Dimension "<<d;
		    *multiplicities << endl;
		  }
		newOrbit=false;
		newDimension=false;
	      }
	  }
    }

  return ret.str();
}


IntegerVector SymmetricComplex::fvector()const
{
  int min=getMinDim();
  IntegerVector ret(getMaxDim()-min+1);

  for(list<Cone>::const_iterator i=cones.begin();i!=cones.end();i++)
    {
      set<Cone> temp;
      for(SymmetryGroup::ElementContainer::const_iterator k=sym.elements.begin();k!=sym.elements.end();k++)
	temp.insert(i->permuted(*k,*this));
      ret[i->dimension-min]+=temp.size();
    }
  return ret;
}


bool SymmetricComplex::isPure()const
{
  int dim=-1;
  for(list<Cone>::const_iterator i=cones.begin();i!=cones.end();i++)
    if(isMaximal(*i))
      {
	int dim2=i->dimension;
	if(dim==-1)dim=dim2;
	if(dim!=dim2)return false;
      }
  return true;
}
