#ifndef WALLIDEAL_H_INCLUDED
#define WALLIDEAL_H_INCLUDED

#include "polynomial.h"
#include "polyhedralcone.h"

/* The correct way to get a set of defining inequalities for a
   full-dimensional groebner cone is by calling wallInequalities() and
   possibly algebraicTest(). It is important not to use
   wallFlipableNormals() sincce this will not work for non-homogeneous
   ideals. The algebraicTest() however works fine in the
   non-homogeneous case. */

IntegerVectorList algebraicTest(IntegerVectorList const &l, PolynomialSet const &groebnerBasis);//run the list through the algebraic test
Polynomial wallPolynomial(Polynomial const &p, IntegerVector const &wallNormal);
PolynomialSet wallIdeal(PolynomialSet const &groebnerBasis, IntegerVector const &wallNormal);
PolynomialSet lowerDimensionalWallIdeal(PolynomialSet const &groebnerBasis, IntegerVectorList const &wallEqualities);
//IntegerVectorList wallNormals(PolynomialSet const &groebnerBasis);
IntegerVectorList wallRemoveScaledInequalities(IntegerVectorList const &l);
IntegerVectorList wallInequalities(PolynomialSet const &groebnerBasis);
bool wallContainsPositiveVector(IntegerVector const &wallNormal);
PolynomialSet flip(PolynomialSet const &groebnerBasis, IntegerVector const &wallNormal);
PolynomialSet flipMinkowski(PolynomialSet const &groebnerBasis, IntegerVector const &wallNormal);
void wallAddCoordinateWalls(IntegerVectorList &normals);
IntegerVectorList wallFlipableNormals(PolynomialSet const &groebnerBasis, bool isKnownToBeHomogeneous=false);
bool isIdealHomogeneous(PolynomialSet const &groebnerBasis); //wrt a positive vector
PolyhedralCone homogeneitySpace(PolynomialSet const &reducedGroebnerBasis);
PolyhedralCone groebnerCone(PolynomialSet const &reducedGroebnerBasis, bool useAlgebraicTest);
int dimensionOfHomogeneitySpace(PolynomialSet const &reducedGroebnerBasis);
PolynomialSet liftBasis(PolynomialSet const &toBeLifted, PolynomialSet const &originalBasisForFullIdeal);
IntegerVectorList normalizedWithSumsAndDuplicatesRemoved(IntegerVectorList const &a);

bool isMarkingConsistent(PolynomialSet const &g);

#endif
