/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  pixbuf-loadersignals.cc - Gdk::PixbufLoader virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "pixbuf-loader.hh"
#include "pixbuf-loadersignals.hh"
#include "private/pixbuf-loaderclass.hh"

using namespace GFC;

/*  Gdk::PixbufLoaderSignals
 */

Gdk::PixbufLoaderSignals::PixbufLoaderSignals(PixbufLoader *pixbuf_loader)
: G::ObjectSignals(pixbuf_loader)
{
	Gdk::PixbufLoaderClass::init(GDK_PIXBUF_LOADER_GET_CLASS(pixbuf_loader->gdk_pixbuf_loader()));
}
	
Gdk::PixbufLoaderSignals::~PixbufLoaderSignals()
{
}

void
Gdk::PixbufLoaderSignals::on_size_prepared(int width, int height)
{
	GdkPixbufLoaderClass *g_class = PixbufLoaderClass::get_parent_class(instance_);
	if (g_class->size_prepared)
		g_class->size_prepared((GdkPixbufLoader*)instance_, width, height);
}

void
Gdk::PixbufLoaderSignals::on_area_prepared()
{
	GdkPixbufLoaderClass *g_class = PixbufLoaderClass::get_parent_class(instance_);
	if (g_class->area_prepared)
		g_class->area_prepared((GdkPixbufLoader*)instance_);
}

void
Gdk::PixbufLoaderSignals::on_area_updated(int x, int y, int width, int height)
{
	GdkPixbufLoaderClass *g_class = PixbufLoaderClass::get_parent_class(instance_);
	if (g_class->area_updated)
		g_class->area_updated((GdkPixbufLoader*)instance_, x, y, width, height);
}

void
Gdk::PixbufLoaderSignals::on_closed()
{
	GdkPixbufLoaderClass *g_class = PixbufLoaderClass::get_parent_class(instance_);
	if (g_class->closed)
		g_class->closed((GdkPixbufLoader*)instance_);
}

/*  Gdk::PixbufLoaderClass
 */

void
Gdk::PixbufLoaderClass::init(GdkPixbufLoaderClass *g_class)
{
	g_class->size_prepared = &size_prepared_proxy;
	g_class->area_prepared = &area_prepared_proxy;
	g_class->area_updated = &area_updated_proxy;
	g_class->closed = &closed_proxy;
}

GdkPixbufLoaderClass*
Gdk::PixbufLoaderClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GDK_PIXBUF_LOADER_GET_CLASS(instance));
	return static_cast<GdkPixbufLoaderClass*>(ptr);
}

GType
Gdk::PixbufLoaderClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GDK_TYPE_PIXBUF_LOADER);
	}
	return type;
}

void*
Gdk::PixbufLoaderClass::create()
{
	return g_object_new(get_type(), 0);
}

void 
Gdk::PixbufLoaderClass::size_prepared_proxy(GdkPixbufLoader *loader, int width, int height)
{
	void *ptr = g_object_get_qdata((GObject*)loader, G::ObjectSignals::quark());
	if (ptr)
		static_cast<PixbufLoaderSignals*>(ptr)->on_size_prepared(width, height);
	else
	{
		GdkPixbufLoaderClass *g_class = PixbufLoaderClass::get_parent_class(loader);
		if (g_class->size_prepared)
			g_class->size_prepared(loader, width, height);
	}
}

void
Gdk::PixbufLoaderClass::area_prepared_proxy(GdkPixbufLoader *loader)
{
	void *ptr = g_object_get_qdata((GObject*)loader, G::ObjectSignals::quark());
	if (ptr)
		static_cast<PixbufLoaderSignals*>(ptr)->on_area_prepared();
	else
	{
		GdkPixbufLoaderClass *g_class = PixbufLoaderClass::get_parent_class(loader);
		if (g_class->area_prepared)
			g_class->area_prepared(loader);
	}
}

void
Gdk::PixbufLoaderClass::area_updated_proxy(GdkPixbufLoader *loader, int x, int y, int width, int height)
{
	void *ptr = g_object_get_qdata((GObject*)loader, G::ObjectSignals::quark());
	if (ptr)
		static_cast<PixbufLoaderSignals*>(ptr)->on_area_updated(x, y, width, height);
	else
	{
		GdkPixbufLoaderClass *g_class = PixbufLoaderClass::get_parent_class(loader);
		if (g_class->area_updated)
			g_class->area_updated(loader, x, y, width, height);
	}
}

void
Gdk::PixbufLoaderClass::closed_proxy(GdkPixbufLoader *loader)
{
	void *ptr = g_object_get_qdata((GObject*)loader, G::ObjectSignals::quark());
	if (ptr)
		static_cast<PixbufLoaderSignals*>(ptr)->on_closed();
	else
	{
		GdkPixbufLoaderClass *g_class = PixbufLoaderClass::get_parent_class(loader);
		if (g_class->closed)
			g_class->closed(loader);
	}
}

