/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  curvesignals.cc - Gtk::Curve virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "curve.hh"
#include "curvesignals.hh"
#include "private/curveclass.hh"

using namespace GFC;

/*  Gtk::CurveSignals
 */

Gtk::CurveSignals::CurveSignals(Curve *curve)
: WidgetSignals(curve)
{
	Gtk::CurveClass::init(GTK_CURVE_GET_CLASS(curve->gtk_curve()));
}

Gtk::CurveSignals::~CurveSignals() 
{
}
	
void
Gtk::CurveSignals::on_curve_type_changed()
{
	GtkCurveClass *g_class = CurveClass::get_parent_class(instance_);
	if (g_class->curve_type_changed)
		g_class->curve_type_changed((GtkCurve*)instance_);
}

/*  Gtk::CurveClass
 */

void
Gtk::CurveClass::init(GtkCurveClass *g_class)
{
	g_class->curve_type_changed = &curve_type_changed_proxy;
}

GtkCurveClass*
Gtk::CurveClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_CURVE_GET_CLASS(instance));
	return static_cast<GtkCurveClass*>(ptr);
}

GType
Gtk::CurveClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_CURVE);
	}
	return type;
}

void*
Gtk::CurveClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::CurveClass::curve_type_changed_proxy(GtkCurve *curve)
{
	void *ptr = g_object_get_qdata((GObject*)curve, G::ObjectSignals::quark());
	if (ptr)
		static_cast<CurveSignals*>(ptr)->on_curve_type_changed();
	else
	{
		GtkCurveClass *g_class = CurveClass::get_parent_class(curve);
		if (g_class->curve_type_changed)
			g_class->curve_type_changed(curve);
	}
}

