/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  dialogsignals.cc - Gtk::Dialog virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "dialog.hh"
#include "dialogsignals.hh"
#include "private/dialogclass.hh"

using namespace GFC;

/*  Gtk::DialogSignals
 */

Gtk::DialogSignals::DialogSignals(Dialog *dialog)
: WindowSignals(dialog)
{
	Gtk::DialogClass::init(GTK_DIALOG_GET_CLASS(dialog->gtk_dialog()));
}

Gtk::DialogSignals::~DialogSignals()
{
}

void
Gtk::DialogSignals::on_response(int response_id)
{
	GtkDialogClass *g_class = DialogClass::get_parent_class(instance_);
	if (g_class->response)
		g_class->response((GtkDialog*)instance_, response_id);
}

void
Gtk::DialogSignals::on_close()
{
	GtkDialogClass *g_class = DialogClass::get_parent_class(instance_);
	if (g_class->close)
		g_class->close((GtkDialog*)instance_);
}

/*  Gtk::DialogClass
 */

void
Gtk::DialogClass::init(GtkDialogClass *g_class)
{
	g_class->response = &response_proxy;
	g_class->close = &close_proxy;
}

GtkDialogClass*
Gtk::DialogClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_DIALOG_GET_CLASS(instance));
	return static_cast<GtkDialogClass*>(ptr);
}

GType
Gtk::DialogClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_DIALOG);
	}
	return type;
}

void*
Gtk::DialogClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::DialogClass::response_proxy(GtkDialog *dialog, gint response_id)
{
	void *ptr = g_object_get_qdata((GObject*)dialog, G::ObjectSignals::quark());
	if (ptr)
		static_cast<DialogSignals*>(ptr)->on_response(response_id);
	else
	{
		GtkDialogClass *g_class = DialogClass::get_parent_class(dialog);
		if (g_class->response)
			g_class->response(dialog, response_id);
	}
}

void
Gtk::DialogClass::close_proxy(GtkDialog *dialog)
{
	void *ptr = g_object_get_qdata((GObject*)dialog, G::ObjectSignals::quark());
	if (ptr)
		static_cast<DialogSignals*>(ptr)->on_close();
	else
	{
		GtkDialogClass *g_class = DialogClass::get_parent_class(dialog);
		if (g_class->close)
			g_class->close(dialog);
	}
}

