/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  entrycompletion.cc - GtkEntryCompletion C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "entrycompletion.hh"
#include "private/entrycompletionclass.hh"
#include "private/marshal.hh"
#include "treemodel.hh"

using namespace GFC;

/*  Gtk::EntryCompletion
 */

Gtk::EntryCompletion::EntryCompletion(GtkEntryCompletion *completion, bool owns_reference)
: G::Object((GObject*)completion, owns_reference)
{
}

Gtk::EntryCompletion::EntryCompletion()
: G::Object((GObject*)EntryCompletionClass::create())
{
}

Gtk::EntryCompletion::~EntryCompletion()
{
}

Gtk::Entry* 
Gtk::EntryCompletion::get_entry() const
{	
	return G::Object::wrap<Entry>((GtkEntry*)gtk_entry_completion_get_entry(gtk_entry_completion()));
}
	
Gtk::TreeModel* 
Gtk::EntryCompletion::get_model() const
{
	Gtk::TreeModel *tmp_model = 0;
	GtkTreeModel *model = gtk_entry_completion_get_model(gtk_entry_completion());
	if (model)
	{
		G::Object *object = G::Object::pointer((GObject*)model);
		tmp_model = dynamic_cast<Gtk::TreeModel*>(object);
	}
	return tmp_model;
}

void 
Gtk::EntryCompletion::set_model(TreeModel& model)
{
	gtk_entry_completion_set_model(gtk_entry_completion(), model.gtk_tree_model());
}

namespace { // MatchCallback

struct MatchCallback
{
	typedef Gtk::EntryCompletion::MatchSlot MatchSlot;
	MatchSlot slot_;

	MatchCallback(const MatchSlot& slot)
	: slot_(slot)
	{
	}

	static gboolean notify(GtkEntryCompletion*, const char *key, GtkTreeIter *iter, void *data)
	{
		MatchCallback *cb = static_cast<MatchCallback*>(data);
		String s(key);		
		Gtk::TreeIter tmp_iter(iter);
		return cb->slot_(s, tmp_iter);
	}

	static void destroy(void *data)
	{
		MatchSlot *cb = static_cast<MatchSlot*>(data);
		delete cb;
	}
};

} // namespace

void 
Gtk::EntryCompletion::set_match_func(const MatchSlot& slot)
{
	MatchCallback *cb = new MatchCallback(slot);
	gtk_entry_completion_set_match_func(gtk_entry_completion(), &MatchCallback::notify, cb, &MatchCallback::destroy);
}

void 
Gtk::EntryCompletion::insert_action_text(int index, const String& text)
{
	insert_action_text(index, text.c_str());
}
	
void 
Gtk::EntryCompletion::insert_action_markup(int index, const String& markup)
{
	insert_action_markup(index, markup.c_str());
}

/*  Gtk::EntryCompletion signals
 */

const Gtk::EntryCompletion::MatchSelectedSignalType Gtk::EntryCompletion::match_selected_signal("match_selected", (GCallback)&Marshal::bool_treemodel_treeiter_callback);

const Gtk::EntryCompletion::ActionActivatedSignalType Gtk::EntryCompletion::action_activated_signal("action_activated", (GCallback)&Marshal::void_int_callback);

