/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  action.inl - Gtk::Action inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline GtkAction*
GFC::Gtk::Action::gtk_action() const
{
	return reinterpret_cast<GtkAction*>(instance_);
}

inline GFC::Gtk::Action::operator GtkAction* () const
{
	return this ? gtk_action() : 0;
}

inline bool 
GFC::Gtk::Action::get_sensitive() const
{
	return gtk_action_get_sensitive(gtk_action());
}

inline bool 
GFC::Gtk::Action::get_visible() const
{
	return gtk_action_get_visible(gtk_action());
}

inline bool 
GFC::Gtk::Action::is_sensitive() const
{
	return gtk_action_is_sensitive(gtk_action());
}

inline bool 
GFC::Gtk::Action::is_visible() const
{
	return gtk_action_is_visible(gtk_action());
}

inline void
GFC::Gtk::Action::set_accel_path(const char *accel_path)
{
	gtk_action_set_accel_path(gtk_action(), accel_path);
}

inline void
GFC::Gtk::Action::activate()
{
	gtk_action_activate(gtk_action());
}

inline void
GFC::Gtk::Action::connect_accelerator()
{
	gtk_action_connect_accelerator(gtk_action());
}

inline void
GFC::Gtk::Action::disconnect_accelerator()
{
	gtk_action_disconnect_accelerator(gtk_action());
}

inline void 
GFC::Gtk::Action::set_tooltip(const char *tooltip)
{
	g_object_set(gtk_action(), "tooltip", tooltip, 0);
}

inline const GFC::Gtk::Action::LabelPropertyProxy
GFC::Gtk::Action::prop_label()
{
	return LabelPropertyProxy(this, &label_property);
}

inline const GFC::Gtk::Action::ShortLabelPropertyProxy
GFC::Gtk::Action::prop_short_label()
{
	return ShortLabelPropertyProxy(this, &short_label_property);
}

inline const GFC::Gtk::Action::TooltipPropertyProxy
GFC::Gtk::Action::prop_tooltip()
{
	return TooltipPropertyProxy(this, &tooltip_property);
}

inline const GFC::Gtk::Action::StockIdPropertyProxy
GFC::Gtk::Action::prop_stock_id()
{
	return StockIdPropertyProxy(this, &stock_id_property);
}

inline const GFC::Gtk::Action::IsImportantPropertyProxy
GFC::Gtk::Action::prop_is_important()
{
	return IsImportantPropertyProxy(this, &is_important_property);
}

inline const GFC::Gtk::Action::HideIfEmptyPropertyProxy
GFC::Gtk::Action::prop_hide_if_empty()
{
	return HideIfEmptyPropertyProxy(this, &hide_if_empty_property);
}

inline const GFC::Gtk::Action::SensitivePropertyProxy
GFC::Gtk::Action::prop_sensitive()
{
	return SensitivePropertyProxy(this, &sensitive_property);
}

inline const GFC::Gtk::Action::VisiblePropertyProxy
GFC::Gtk::Action::prop_visible()
{
	return VisiblePropertyProxy(this, &visible_property);
}

inline const GFC::Gtk::Action::VisibleHorizontalPropertyProxy
GFC::Gtk::Action::prop_visible_horizontal()
{
	return VisibleHorizontalPropertyProxy(this, &visible_horizontal_property);
}

inline const GFC::Gtk::Action::VisibleVerticalPropertyProxy
GFC::Gtk::Action::prop_visible_vertical()
{
	return VisibleVerticalPropertyProxy(this, &visible_vertical_property);
}

inline const GFC::Gtk::Action::ActivateSignalProxy
GFC::Gtk::Action::sig_activate()
{
	return ActivateSignalProxy(this, &activate_signal);
}

