/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  curve.inl - Gtk::Curve inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline GtkCurve*
GFC::Gtk::Curve::gtk_curve() const
{
	return reinterpret_cast<GtkCurve*>(instance_);
}

inline GFC::Gtk::Curve::operator GtkCurve* () const
{
	return this ? gtk_curve() : 0;
}

inline void
GFC::Gtk::Curve::get_vector(int count, float data[]) const
{
	gtk_curve_get_vector(gtk_curve(), count, data);
}

inline void
GFC::Gtk::Curve::reset()
{
	gtk_curve_reset(gtk_curve());
}

inline void
GFC::Gtk::Curve::set_gamma(float gamma)
{
	gtk_curve_set_gamma(gtk_curve(), gamma);
}

inline void
GFC::Gtk::Curve::set_range(float min_x, float max_x, float min_y, float max_y)
{
	gtk_curve_set_range(gtk_curve(), min_x, max_x, min_y, max_y);
}

inline void
GFC::Gtk::Curve::set_vector(int count, float data[])
{
	gtk_curve_set_vector(gtk_curve(), count, data);
}

inline void
GFC::Gtk::Curve::set_curve_type(CurveType type)
{
	gtk_curve_set_curve_type(gtk_curve(), (GtkCurveType)type);
}

inline const GFC::Gtk::Curve::CurveTypeChangedSignalProxy
GFC::Gtk::Curve::sig_curve_type_changed()
{
	return CurveTypeChangedSignalProxy(this, &curve_type_changed_signal);
}

