/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  viewport.inl - Gtk::Viewport inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline GtkViewport*
GFC::Gtk::Viewport::gtk_viewport() const
{
	return reinterpret_cast<GtkViewport*>(instance_);
}

inline GFC::Gtk::Viewport::operator GtkViewport* () const
{
	return this ? gtk_viewport() : 0;
}

inline void
GFC::Gtk::Viewport::set_shadow_type(ShadowType type)
{
	gtk_viewport_set_shadow_type(gtk_viewport(), (GtkShadowType)type);
}

inline const GFC::Gtk::Viewport::SetScrollAdjustmentsSignalProxy
GFC::Gtk::Viewport::sig_set_scroll_adjustments()
{
	return SetScrollAdjustmentsSignalProxy(this, &set_scroll_adjustments_signal);
}

