/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  item.cc - GtkItem C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "item.hh"
#include "private/marshal.hh"

using namespace GFC;

/*  Gtk::Item
 */

Gtk::Item::Item(GtkItem *item, bool owns_reference)
: Bin((GtkBin*)item, owns_reference)
{
}

Gtk::Item::~Item()
{
}

/*  Gtk::Item Signals
 */

const Gtk::Item::SelectSignalType Gtk::Item::select_signal("select", (GCallback)&G::Marshal::void_callback);

const Gtk::Item::DeselectSignalType Gtk::Item::deselect_signal("deselect", (GCallback)&G::Marshal::void_callback);

const Gtk::Item::ToggleSignalType Gtk::Item::toggle_signal("toggle", (GCallback)&G::Marshal::void_callback);

