/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  notebooksignals.cc - Gtk::Notebook virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "notebook.hh"
#include "notebooksignals.hh"
#include "private/notebookclass.hh"

using namespace GFC;

/*  Gtk::NotebookSignals
 */

Gtk::NotebookSignals::NotebookSignals(Notebook *notebook)
: ContainerSignals(notebook)
{
	Gtk::NotebookClass::init(GTK_NOTEBOOK_GET_CLASS(notebook->gtk_notebook()));
}

Gtk::NotebookSignals::~NotebookSignals() 
{
}

void
Gtk::NotebookSignals::on_switch_page(Widget& page_child, unsigned int page_num)
{
	GtkNotebookClass *g_class = NotebookClass::get_parent_class(instance_);
	if (g_class->switch_page)
		g_class->switch_page((GtkNotebook*)instance_, (GtkNotebookPage*)page_child.gtk_widget(), page_num);
}

/*  Gtk::NotebookClass
 */

void
Gtk::NotebookClass::init(GtkNotebookClass *g_class)
{
	g_class->switch_page = &switch_page_proxy;
}

GtkNotebookClass*
Gtk::NotebookClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_NOTEBOOK_GET_CLASS(instance));
	return static_cast<GtkNotebookClass*>(ptr);
}

GType
Gtk::NotebookClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_NOTEBOOK);
	}
	return type;
}

void*
Gtk::NotebookClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::NotebookClass::switch_page_proxy(GtkNotebook *notebook, GtkNotebookPage *page, guint page_num)
{
	void *ptr = g_object_get_qdata((GObject*)notebook, G::ObjectSignals::quark());
	if (ptr)
	{
		GtkWidget *widget = reinterpret_cast<GtkWidget*>(page);
		static_cast<NotebookSignals*>(ptr)->on_switch_page(*G::Object::wrap<Widget>(widget), page_num);
	}
	else
	{
		GtkNotebookClass *g_class = NotebookClass::get_parent_class(notebook);
		if (g_class->switch_page)
			g_class->switch_page(notebook, page, page_num);
	}
}

