/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  toolbar.cc - GtkToolbar C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "toolbar.hh"
#include "tooltips.hh"
#include "private/toolbarclass.hh"
#include "private/marshal.hh"

using namespace GFC;

/*  Gtk::Toolbar
 */

Gtk::Toolbar::Toolbar(GtkToolbar *toolbar, bool owns_reference)
: Container((GtkContainer*)toolbar, owns_reference)
{
}

Gtk::Toolbar::Toolbar()
: Container((GtkContainer*)ToolbarClass::create())
{
}

Gtk::Toolbar::Toolbar(Orientation orientation)
: Container((GtkContainer*)ToolbarClass::create())
{
	set_orientation(orientation);
}

Gtk::Toolbar::Toolbar(Orientation orientation, ToolbarStyle style)
: Container((GtkContainer*)ToolbarClass::create())
{
	set_orientation(orientation);
	set_style(style);
}

Gtk::Toolbar::~Toolbar()
{
}
	
Gtk::ToolItem*
Gtk::Toolbar::get_nth_item(int n) const
{
	return G::Object::wrap<ToolItem>(gtk_toolbar_get_nth_item(gtk_toolbar(), n));
}

void 
Gtk::Toolbar::append(ToolItem& item, const char *tooltip)
{
	insert(item, -1, tooltip);
}
	
void 
Gtk::Toolbar::append(ToolItem& item, const String& tooltip)
{
	insert(item, -1, tooltip.c_str());
}
	
void 
Gtk::Toolbar::prepend(ToolItem& item, const char *tooltip)
{
	insert(item, 0, tooltip);
}
	
void 
Gtk::Toolbar::prepend(ToolItem& item, const String& tooltip)
{
	insert(item, 0, tooltip.c_str());
}
	
void 
Gtk::Toolbar::insert(ToolItem& item, int pos, const char *tooltip)
{
	gtk_toolbar_insert(gtk_toolbar(), item.gtk_tool_item(), pos);
	if (tooltip)
		set_tooltip(item, tooltip);
}

void 
Gtk::Toolbar::insert(ToolItem& item, int pos, const String& tooltip)
{
	insert(item, pos, tooltip.c_str());
}

void 
Gtk::Toolbar::append_separator()
{
	insert_separator(-1);
}
	
void 
Gtk::Toolbar::insert_separator(int pos)
{
	GtkToolItem *separator = gtk_separator_tool_item_new();
	gtk_toolbar_insert(gtk_toolbar(), separator, pos);
	gtk_widget_show((GtkWidget*)separator);
}
	
void
Gtk::Toolbar::set_drop_highlight_item(ToolItem& item, int index)
{
	gtk_toolbar_set_drop_highlight_item(gtk_toolbar(), item.gtk_tool_item(), index);
}

void 
Gtk::Toolbar::set_tooltip(ToolItem& item, const char *tip_text, const char *tip_private)
{
	gtk_tool_item_set_tooltip(item.gtk_tool_item(), gtk_toolbar()->tooltips, tip_text, tip_private);	
}
	
void 
Gtk::Toolbar::set_tooltip(ToolItem& item, const String& tip_text, const String& tip_private)
{
	set_tooltip(item, tip_text.c_str(), tip_private.c_str());
}

/*  Gtk::Toolbar signals
 */

const Gtk::Toolbar::OrientationChangedSignalType Gtk::Toolbar::orientation_changed_signal("orientation-changed", (GCallback)&Marshal::void_orientation_callback);

const Gtk::Toolbar::StyleChangedSignalType Gtk::Toolbar::style_changed_signal("style-changed", (GCallback)&Marshal::void_toolbarstyle_callback);

const Gtk::Toolbar::PopupContextMenuSignalType Gtk::Toolbar::popup_context_menu_signal("popup_context_menu", (GCallback)&Marshal::bool_int_int_int_callback);
